/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.hdds.protocol.DatanodeDetails;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public final class ReplicateContainerCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto> {
    private final long containerID;
    private final List<DatanodeDetails> sourceDatanodes;
    private final DatanodeDetails targetDatanode;
    private int replicaIndex = 0;
    private StorageContainerDatanodeProtocolProtos.ReplicationCommandPriority priority = StorageContainerDatanodeProtocolProtos.ReplicationCommandPriority.NORMAL;

    public static ReplicateContainerCommand fromSources(long containerID, List<DatanodeDetails> sourceDatanodes) {
        return new ReplicateContainerCommand(containerID, sourceDatanodes, null);
    }

    public static ReplicateContainerCommand toTarget(long containerID, DatanodeDetails target) {
        return new ReplicateContainerCommand(containerID, Collections.emptyList(), target);
    }

    public static ReplicateContainerCommand forTest(long containerID) {
        return new ReplicateContainerCommand(containerID, Collections.emptyList(), null);
    }

    private ReplicateContainerCommand(long containerID, List<DatanodeDetails> sourceDatanodes, DatanodeDetails target) {
        this.containerID = containerID;
        this.sourceDatanodes = sourceDatanodes;
        this.targetDatanode = target;
    }

    private ReplicateContainerCommand(long containerID, List<DatanodeDetails> sourceDatanodes, long id, DatanodeDetails targetDatanode) {
        super(id);
        this.containerID = containerID;
        this.sourceDatanodes = sourceDatanodes;
        this.targetDatanode = targetDatanode;
    }

    public void setReplicaIndex(int index) {
        this.replicaIndex = index;
    }

    public void setPriority(StorageContainerDatanodeProtocolProtos.ReplicationCommandPriority priority) {
        this.priority = priority;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.replicateContainerCommand;
    }

    @Override
    public boolean contributesToQueueSize() {
        return this.priority == StorageContainerDatanodeProtocolProtos.ReplicationCommandPriority.NORMAL;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto getProto() {
        StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto.Builder builder = StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto.newBuilder().setCmdId(this.getId()).setContainerID(this.containerID);
        for (DatanodeDetails dd : this.sourceDatanodes) {
            builder.addSources(dd.getProtoBufMessage());
        }
        builder.setReplicaIndex(this.replicaIndex);
        if (this.targetDatanode != null) {
            builder.setTarget(this.targetDatanode.getProtoBufMessage());
        }
        builder.setPriority(this.priority);
        return builder.build();
    }

    public static ReplicateContainerCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.ReplicateContainerCommandProto protoMessage) {
        Preconditions.checkNotNull((Object)protoMessage);
        List sources = protoMessage.getSourcesList();
        List<DatanodeDetails> sourceNodes = !sources.isEmpty() ? sources.stream().map(DatanodeDetails::getFromProtoBuf).collect(Collectors.toList()) : Collections.emptyList();
        DatanodeDetails targetNode = protoMessage.hasTarget() ? DatanodeDetails.getFromProtoBuf((HddsProtos.DatanodeDetailsProto)protoMessage.getTarget()) : null;
        ReplicateContainerCommand cmd = new ReplicateContainerCommand(protoMessage.getContainerID(), sourceNodes, protoMessage.getCmdId(), targetNode);
        if (protoMessage.hasReplicaIndex()) {
            cmd.setReplicaIndex(protoMessage.getReplicaIndex());
        }
        if (protoMessage.hasPriority()) {
            cmd.setPriority(protoMessage.getPriority());
        }
        return cmd;
    }

    public long getContainerID() {
        return this.containerID;
    }

    public List<DatanodeDetails> getSourceDatanodes() {
        return this.sourceDatanodes;
    }

    public DatanodeDetails getTargetDatanode() {
        return this.targetDatanode;
    }

    public int getReplicaIndex() {
        return this.replicaIndex;
    }

    public StorageContainerDatanodeProtocolProtos.ReplicationCommandPriority getPriority() {
        return this.priority;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getType());
        sb.append(": containerId=").append(this.getContainerID());
        sb.append(", replicaIndex=").append(this.getReplicaIndex());
        if (this.targetDatanode != null) {
            sb.append(", targetNode=").append(this.targetDatanode);
        } else {
            sb.append(", sourceNodes=").append(this.sourceDatanodes);
        }
        sb.append(", priority=").append(this.priority);
        return sb.toString();
    }
}

