/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ozone.protocol.commands;

import com.google.common.base.Preconditions;
import org.apache.hadoop.hdds.protocol.proto.HddsProtos;
import org.apache.hadoop.hdds.protocol.proto.StorageContainerDatanodeProtocolProtos;
import org.apache.hadoop.ozone.protocol.commands.SCMCommand;

public class SetNodeOperationalStateCommand
extends SCMCommand<StorageContainerDatanodeProtocolProtos.SetNodeOperationalStateCommandProto> {
    private final HddsProtos.NodeOperationalState opState;
    private long stateExpiryEpochSeconds;

    public SetNodeOperationalStateCommand(long id, HddsProtos.NodeOperationalState state, long stateExpiryEpochSeconds) {
        super(id);
        this.opState = state;
        this.stateExpiryEpochSeconds = stateExpiryEpochSeconds;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type getType() {
        return StorageContainerDatanodeProtocolProtos.SCMCommandProto.Type.setNodeOperationalStateCommand;
    }

    @Override
    public StorageContainerDatanodeProtocolProtos.SetNodeOperationalStateCommandProto getProto() {
        return StorageContainerDatanodeProtocolProtos.SetNodeOperationalStateCommandProto.newBuilder().setCmdId(this.getId()).setNodeOperationalState(this.opState).setStateExpiryEpochSeconds(this.stateExpiryEpochSeconds).build();
    }

    public HddsProtos.NodeOperationalState getOpState() {
        return this.opState;
    }

    public long getStateExpiryEpochSeconds() {
        return this.stateExpiryEpochSeconds;
    }

    public static SetNodeOperationalStateCommand getFromProtobuf(StorageContainerDatanodeProtocolProtos.SetNodeOperationalStateCommandProto cmdProto) {
        Preconditions.checkNotNull((Object)cmdProto);
        return new SetNodeOperationalStateCommand(cmdProto.getCmdId(), cmdProto.getNodeOperationalState(), cmdProto.getStateExpiryEpochSeconds());
    }
}

