/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

package model

import (
	"context"
	stdErrors "errors"
	"fmt"

	"github.com/pkg/errors"
	"github.com/rs/zerolog"

	"github.com/apache/plc4x/plc4go/spi/utils"
)

// Code generated by code-generation. DO NOT EDIT.

// BACnetWeekNDay is the corresponding interface of BACnetWeekNDay
type BACnetWeekNDay interface {
	fmt.Stringer
	utils.LengthAware
	utils.Serializable
	utils.Copyable
	// IsBACnetWeekNDay is a marker method to prevent unintentional type checks (interfaces of same signature)
	IsBACnetWeekNDay()
	// CreateBuilder creates a BACnetWeekNDayBuilder
	CreateBACnetWeekNDayBuilder() BACnetWeekNDayBuilder
}

// _BACnetWeekNDay is the data-structure of this message
type _BACnetWeekNDay struct {
}

var _ BACnetWeekNDay = (*_BACnetWeekNDay)(nil)

// NewBACnetWeekNDay factory function for _BACnetWeekNDay
func NewBACnetWeekNDay() *_BACnetWeekNDay {
	return &_BACnetWeekNDay{}
}

///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////
/////////////////////// Builder
///////////////////////

// BACnetWeekNDayBuilder is a builder for BACnetWeekNDay
type BACnetWeekNDayBuilder interface {
	utils.Copyable
	// WithMandatoryFields adds all mandatory fields (convenience for using multiple builder calls)
	WithMandatoryFields() BACnetWeekNDayBuilder
	// Build builds the BACnetWeekNDay or returns an error if something is wrong
	Build() (BACnetWeekNDay, error)
	// MustBuild does the same as Build but panics on error
	MustBuild() BACnetWeekNDay
}

// NewBACnetWeekNDayBuilder() creates a BACnetWeekNDayBuilder
func NewBACnetWeekNDayBuilder() BACnetWeekNDayBuilder {
	return &_BACnetWeekNDayBuilder{_BACnetWeekNDay: new(_BACnetWeekNDay)}
}

type _BACnetWeekNDayBuilder struct {
	*_BACnetWeekNDay

	collectedErr []error
}

var _ (BACnetWeekNDayBuilder) = (*_BACnetWeekNDayBuilder)(nil)

func (b *_BACnetWeekNDayBuilder) WithMandatoryFields() BACnetWeekNDayBuilder {
	return b
}

func (b *_BACnetWeekNDayBuilder) Build() (BACnetWeekNDay, error) {
	if err := stdErrors.Join(b.collectedErr...); err != nil {
		return nil, errors.Wrap(err, "error occurred during build")
	}
	return b._BACnetWeekNDay.deepCopy(), nil
}

func (b *_BACnetWeekNDayBuilder) MustBuild() BACnetWeekNDay {
	build, err := b.Build()
	if err != nil {
		panic(err)
	}
	return build
}

func (b *_BACnetWeekNDayBuilder) DeepCopy() any {
	_copy := b.CreateBACnetWeekNDayBuilder().(*_BACnetWeekNDayBuilder)
	if b.collectedErr != nil {
		copy(_copy.collectedErr, b.collectedErr)
	}
	return _copy
}

// CreateBACnetWeekNDayBuilder creates a BACnetWeekNDayBuilder
func (b *_BACnetWeekNDay) CreateBACnetWeekNDayBuilder() BACnetWeekNDayBuilder {
	if b == nil {
		return NewBACnetWeekNDayBuilder()
	}
	return &_BACnetWeekNDayBuilder{_BACnetWeekNDay: b.deepCopy()}
}

///////////////////////
///////////////////////
///////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////

// Deprecated: use the interface for direct cast
func CastBACnetWeekNDay(structType any) BACnetWeekNDay {
	if casted, ok := structType.(BACnetWeekNDay); ok {
		return casted
	}
	if casted, ok := structType.(*BACnetWeekNDay); ok {
		return *casted
	}
	return nil
}

func (m *_BACnetWeekNDay) GetTypeName() string {
	return "BACnetWeekNDay"
}

func (m *_BACnetWeekNDay) GetLengthInBits(ctx context.Context) uint16 {
	lengthInBits := uint16(0)

	return lengthInBits
}

func (m *_BACnetWeekNDay) GetLengthInBytes(ctx context.Context) uint16 {
	return m.GetLengthInBits(ctx) / 8
}

func BACnetWeekNDayParse(ctx context.Context, theBytes []byte) (BACnetWeekNDay, error) {
	return BACnetWeekNDayParseWithBuffer(ctx, utils.NewReadBufferByteBased(theBytes))
}

func BACnetWeekNDayParseWithBufferProducer() func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetWeekNDay, error) {
	return func(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetWeekNDay, error) {
		return BACnetWeekNDayParseWithBuffer(ctx, readBuffer)
	}
}

func BACnetWeekNDayParseWithBuffer(ctx context.Context, readBuffer utils.ReadBuffer) (BACnetWeekNDay, error) {
	v, err := (&_BACnetWeekNDay{}).parse(ctx, readBuffer)
	if err != nil {
		return nil, err
	}
	return v, nil
}

func (m *_BACnetWeekNDay) parse(ctx context.Context, readBuffer utils.ReadBuffer) (__bACnetWeekNDay BACnetWeekNDay, err error) {
	positionAware := readBuffer
	_ = positionAware
	if pullErr := readBuffer.PullContext("BACnetWeekNDay"); pullErr != nil {
		return nil, errors.Wrap(pullErr, "Error pulling for BACnetWeekNDay")
	}
	currentPos := positionAware.GetPos()
	_ = currentPos

	// Validation
	if !(bool((1) == (2))) {
		return nil, errors.WithStack(utils.ParseValidationError{Message: "Unusable type. Exits only for consistency. Use BACnetWeekNDayTagged"})
	}

	if closeErr := readBuffer.CloseContext("BACnetWeekNDay"); closeErr != nil {
		return nil, errors.Wrap(closeErr, "Error closing for BACnetWeekNDay")
	}

	return m, nil
}

func (m *_BACnetWeekNDay) Serialize() ([]byte, error) {
	wb := utils.NewWriteBufferByteBased(utils.WithInitialSizeForByteBasedBuffer(int(m.GetLengthInBytes(context.Background()))))
	if err := m.SerializeWithWriteBuffer(context.Background(), wb); err != nil {
		return nil, err
	}
	return wb.GetBytes(), nil
}

func (m *_BACnetWeekNDay) SerializeWithWriteBuffer(ctx context.Context, writeBuffer utils.WriteBuffer) error {
	positionAware := writeBuffer
	_ = positionAware
	log := zerolog.Ctx(ctx)
	_ = log
	if pushErr := writeBuffer.PushContext("BACnetWeekNDay"); pushErr != nil {
		return errors.Wrap(pushErr, "Error pushing for BACnetWeekNDay")
	}

	if popErr := writeBuffer.PopContext("BACnetWeekNDay"); popErr != nil {
		return errors.Wrap(popErr, "Error popping for BACnetWeekNDay")
	}
	return nil
}

func (m *_BACnetWeekNDay) IsBACnetWeekNDay() {}

func (m *_BACnetWeekNDay) DeepCopy() any {
	return m.deepCopy()
}

func (m *_BACnetWeekNDay) deepCopy() *_BACnetWeekNDay {
	if m == nil {
		return nil
	}
	_BACnetWeekNDayCopy := &_BACnetWeekNDay{}
	return _BACnetWeekNDayCopy
}

func (m *_BACnetWeekNDay) String() string {
	if m == nil {
		return "<nil>"
	}
	wb := utils.NewWriteBufferBoxBased(
		utils.WithWriteBufferBoxBasedMergeSingleBoxes(),
		utils.WithWriteBufferBoxBasedOmitEmptyBoxes(),
		utils.WithWriteBufferBoxBasedPrintPosLengthFooter(),
	)
	if err := wb.WriteSerializable(context.Background(), m); err != nil {
		return err.Error()
	}
	return wb.GetBox().String()
}
