/*
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 *   https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.plc4x.java.opcua.readwrite;

import static org.apache.plc4x.java.spi.codegen.fields.FieldReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.fields.FieldWriterFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataReaderFactory.*;
import static org.apache.plc4x.java.spi.codegen.io.DataWriterFactory.*;
import static org.apache.plc4x.java.spi.generation.StaticHelper.*;

import java.time.*;
import java.util.*;
import org.apache.plc4x.java.api.exceptions.*;
import org.apache.plc4x.java.api.value.*;
import org.apache.plc4x.java.spi.codegen.*;
import org.apache.plc4x.java.spi.codegen.fields.*;
import org.apache.plc4x.java.spi.codegen.io.*;
import org.apache.plc4x.java.spi.generation.*;

// Code generated by code-generation. DO NOT EDIT.

public class ApplicationConfigurationDataType extends ExtensionObjectDefinition implements Message {

  // Accessors for discriminator values.
  public Integer getExtensionId() {
    return (int) 15551;
  }

  // Properties.
  protected final long configurationVersion;
  protected final List<KeyValuePair> configurationProperties;
  protected final ApplicationIdentityDataType applicationIdentity;
  protected final List<CertificateGroupDataType> certificateGroups;
  protected final List<ServerEndpointDataType> serverEndpoints;
  protected final List<EndpointDataType> clientEndpoints;
  protected final List<SecuritySettingsDataType> securitySettings;
  protected final List<UserTokenSettingsDataType> userTokenSettings;
  protected final List<AuthorizationServiceConfigurationDataType> authorizationServices;

  public ApplicationConfigurationDataType(
      long configurationVersion,
      List<KeyValuePair> configurationProperties,
      ApplicationIdentityDataType applicationIdentity,
      List<CertificateGroupDataType> certificateGroups,
      List<ServerEndpointDataType> serverEndpoints,
      List<EndpointDataType> clientEndpoints,
      List<SecuritySettingsDataType> securitySettings,
      List<UserTokenSettingsDataType> userTokenSettings,
      List<AuthorizationServiceConfigurationDataType> authorizationServices) {
    super();
    this.configurationVersion = configurationVersion;
    this.configurationProperties = configurationProperties;
    this.applicationIdentity = applicationIdentity;
    this.certificateGroups = certificateGroups;
    this.serverEndpoints = serverEndpoints;
    this.clientEndpoints = clientEndpoints;
    this.securitySettings = securitySettings;
    this.userTokenSettings = userTokenSettings;
    this.authorizationServices = authorizationServices;
  }

  public long getConfigurationVersion() {
    return configurationVersion;
  }

  public List<KeyValuePair> getConfigurationProperties() {
    return configurationProperties;
  }

  public ApplicationIdentityDataType getApplicationIdentity() {
    return applicationIdentity;
  }

  public List<CertificateGroupDataType> getCertificateGroups() {
    return certificateGroups;
  }

  public List<ServerEndpointDataType> getServerEndpoints() {
    return serverEndpoints;
  }

  public List<EndpointDataType> getClientEndpoints() {
    return clientEndpoints;
  }

  public List<SecuritySettingsDataType> getSecuritySettings() {
    return securitySettings;
  }

  public List<UserTokenSettingsDataType> getUserTokenSettings() {
    return userTokenSettings;
  }

  public List<AuthorizationServiceConfigurationDataType> getAuthorizationServices() {
    return authorizationServices;
  }

  @Override
  protected void serializeExtensionObjectDefinitionChild(WriteBuffer writeBuffer)
      throws SerializationException {
    PositionAware positionAware = writeBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();
    writeBuffer.pushContext("ApplicationConfigurationDataType");

    // Simple Field (configurationVersion)
    writeSimpleField(
        "configurationVersion", configurationVersion, writeUnsignedLong(writeBuffer, 32));

    // Implicit Field (noOfConfigurationProperties) (Used for parsing, but its value is not stored
    // as it's implicitly given by the objects content)
    int noOfConfigurationProperties =
        (int)
            ((((getConfigurationProperties()) == (null))
                ? -(1)
                : COUNT(getConfigurationProperties())));
    writeImplicitField(
        "noOfConfigurationProperties",
        noOfConfigurationProperties,
        writeSignedInt(writeBuffer, 32));

    // Array Field (configurationProperties)
    writeComplexTypeArrayField("configurationProperties", configurationProperties, writeBuffer);

    // Simple Field (applicationIdentity)
    writeSimpleField("applicationIdentity", applicationIdentity, writeComplex(writeBuffer));

    // Implicit Field (noOfCertificateGroups) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfCertificateGroups =
        (int) ((((getCertificateGroups()) == (null)) ? -(1) : COUNT(getCertificateGroups())));
    writeImplicitField(
        "noOfCertificateGroups", noOfCertificateGroups, writeSignedInt(writeBuffer, 32));

    // Array Field (certificateGroups)
    writeComplexTypeArrayField("certificateGroups", certificateGroups, writeBuffer);

    // Implicit Field (noOfServerEndpoints) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfServerEndpoints =
        (int) ((((getServerEndpoints()) == (null)) ? -(1) : COUNT(getServerEndpoints())));
    writeImplicitField("noOfServerEndpoints", noOfServerEndpoints, writeSignedInt(writeBuffer, 32));

    // Array Field (serverEndpoints)
    writeComplexTypeArrayField("serverEndpoints", serverEndpoints, writeBuffer);

    // Implicit Field (noOfClientEndpoints) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfClientEndpoints =
        (int) ((((getClientEndpoints()) == (null)) ? -(1) : COUNT(getClientEndpoints())));
    writeImplicitField("noOfClientEndpoints", noOfClientEndpoints, writeSignedInt(writeBuffer, 32));

    // Array Field (clientEndpoints)
    writeComplexTypeArrayField("clientEndpoints", clientEndpoints, writeBuffer);

    // Implicit Field (noOfSecuritySettings) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfSecuritySettings =
        (int) ((((getSecuritySettings()) == (null)) ? -(1) : COUNT(getSecuritySettings())));
    writeImplicitField(
        "noOfSecuritySettings", noOfSecuritySettings, writeSignedInt(writeBuffer, 32));

    // Array Field (securitySettings)
    writeComplexTypeArrayField("securitySettings", securitySettings, writeBuffer);

    // Implicit Field (noOfUserTokenSettings) (Used for parsing, but its value is not stored as it's
    // implicitly given by the objects content)
    int noOfUserTokenSettings =
        (int) ((((getUserTokenSettings()) == (null)) ? -(1) : COUNT(getUserTokenSettings())));
    writeImplicitField(
        "noOfUserTokenSettings", noOfUserTokenSettings, writeSignedInt(writeBuffer, 32));

    // Array Field (userTokenSettings)
    writeComplexTypeArrayField("userTokenSettings", userTokenSettings, writeBuffer);

    // Implicit Field (noOfAuthorizationServices) (Used for parsing, but its value is not stored as
    // it's implicitly given by the objects content)
    int noOfAuthorizationServices =
        (int)
            ((((getAuthorizationServices()) == (null)) ? -(1) : COUNT(getAuthorizationServices())));
    writeImplicitField(
        "noOfAuthorizationServices", noOfAuthorizationServices, writeSignedInt(writeBuffer, 32));

    // Array Field (authorizationServices)
    writeComplexTypeArrayField("authorizationServices", authorizationServices, writeBuffer);

    writeBuffer.popContext("ApplicationConfigurationDataType");
  }

  @Override
  public int getLengthInBytes() {
    return (int) Math.ceil((float) getLengthInBits() / 8.0);
  }

  @Override
  public int getLengthInBits() {
    int lengthInBits = super.getLengthInBits();
    ApplicationConfigurationDataType _value = this;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    // Simple field (configurationVersion)
    lengthInBits += 32;

    // Implicit Field (noOfConfigurationProperties)
    lengthInBits += 32;

    // Array field
    if (configurationProperties != null) {
      int i = 0;
      for (KeyValuePair element : configurationProperties) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= configurationProperties.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Simple field (applicationIdentity)
    lengthInBits += applicationIdentity.getLengthInBits();

    // Implicit Field (noOfCertificateGroups)
    lengthInBits += 32;

    // Array field
    if (certificateGroups != null) {
      int i = 0;
      for (CertificateGroupDataType element : certificateGroups) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= certificateGroups.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfServerEndpoints)
    lengthInBits += 32;

    // Array field
    if (serverEndpoints != null) {
      int i = 0;
      for (ServerEndpointDataType element : serverEndpoints) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= serverEndpoints.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfClientEndpoints)
    lengthInBits += 32;

    // Array field
    if (clientEndpoints != null) {
      int i = 0;
      for (EndpointDataType element : clientEndpoints) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= clientEndpoints.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfSecuritySettings)
    lengthInBits += 32;

    // Array field
    if (securitySettings != null) {
      int i = 0;
      for (SecuritySettingsDataType element : securitySettings) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= securitySettings.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfUserTokenSettings)
    lengthInBits += 32;

    // Array field
    if (userTokenSettings != null) {
      int i = 0;
      for (UserTokenSettingsDataType element : userTokenSettings) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= userTokenSettings.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    // Implicit Field (noOfAuthorizationServices)
    lengthInBits += 32;

    // Array field
    if (authorizationServices != null) {
      int i = 0;
      for (AuthorizationServiceConfigurationDataType element : authorizationServices) {
        ThreadLocalHelper.lastItemThreadLocal.set(++i >= authorizationServices.size());
        lengthInBits += element.getLengthInBits();
      }
    }

    return lengthInBits;
  }

  public static ExtensionObjectDefinitionBuilder staticParseExtensionObjectDefinitionBuilder(
      ReadBuffer readBuffer, Integer extensionId) throws ParseException {
    readBuffer.pullContext("ApplicationConfigurationDataType");
    PositionAware positionAware = readBuffer;
    boolean _lastItem = ThreadLocalHelper.lastItemThreadLocal.get();

    long configurationVersion =
        readSimpleField("configurationVersion", readUnsignedLong(readBuffer, 32));

    int noOfConfigurationProperties =
        readImplicitField("noOfConfigurationProperties", readSignedInt(readBuffer, 32));

    List<KeyValuePair> configurationProperties =
        readCountArrayField(
            "configurationProperties",
            readComplex(
                () ->
                    (KeyValuePair) ExtensionObjectDefinition.staticParse(readBuffer, (int) (14535)),
                readBuffer),
            noOfConfigurationProperties);

    ApplicationIdentityDataType applicationIdentity =
        readSimpleField(
            "applicationIdentity",
            readComplex(
                () ->
                    (ApplicationIdentityDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15558)),
                readBuffer));

    int noOfCertificateGroups =
        readImplicitField("noOfCertificateGroups", readSignedInt(readBuffer, 32));

    List<CertificateGroupDataType> certificateGroups =
        readCountArrayField(
            "certificateGroups",
            readComplex(
                () ->
                    (CertificateGroupDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15438)),
                readBuffer),
            noOfCertificateGroups);

    int noOfServerEndpoints =
        readImplicitField("noOfServerEndpoints", readSignedInt(readBuffer, 32));

    List<ServerEndpointDataType> serverEndpoints =
        readCountArrayField(
            "serverEndpoints",
            readComplex(
                () ->
                    (ServerEndpointDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15560)),
                readBuffer),
            noOfServerEndpoints);

    int noOfClientEndpoints =
        readImplicitField("noOfClientEndpoints", readSignedInt(readBuffer, 32));

    List<EndpointDataType> clientEndpoints =
        readCountArrayField(
            "clientEndpoints",
            readComplex(
                () ->
                    (EndpointDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15559)),
                readBuffer),
            noOfClientEndpoints);

    int noOfSecuritySettings =
        readImplicitField("noOfSecuritySettings", readSignedInt(readBuffer, 32));

    List<SecuritySettingsDataType> securitySettings =
        readCountArrayField(
            "securitySettings",
            readComplex(
                () ->
                    (SecuritySettingsDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15561)),
                readBuffer),
            noOfSecuritySettings);

    int noOfUserTokenSettings =
        readImplicitField("noOfUserTokenSettings", readSignedInt(readBuffer, 32));

    List<UserTokenSettingsDataType> userTokenSettings =
        readCountArrayField(
            "userTokenSettings",
            readComplex(
                () ->
                    (UserTokenSettingsDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (15562)),
                readBuffer),
            noOfUserTokenSettings);

    int noOfAuthorizationServices =
        readImplicitField("noOfAuthorizationServices", readSignedInt(readBuffer, 32));

    List<AuthorizationServiceConfigurationDataType> authorizationServices =
        readCountArrayField(
            "authorizationServices",
            readComplex(
                () ->
                    (AuthorizationServiceConfigurationDataType)
                        ExtensionObjectDefinition.staticParse(readBuffer, (int) (19447)),
                readBuffer),
            noOfAuthorizationServices);

    readBuffer.closeContext("ApplicationConfigurationDataType");
    // Create the instance
    return new ApplicationConfigurationDataTypeBuilderImpl(
        configurationVersion,
        configurationProperties,
        applicationIdentity,
        certificateGroups,
        serverEndpoints,
        clientEndpoints,
        securitySettings,
        userTokenSettings,
        authorizationServices);
  }

  public static class ApplicationConfigurationDataTypeBuilderImpl
      implements ExtensionObjectDefinition.ExtensionObjectDefinitionBuilder {
    private final long configurationVersion;
    private final List<KeyValuePair> configurationProperties;
    private final ApplicationIdentityDataType applicationIdentity;
    private final List<CertificateGroupDataType> certificateGroups;
    private final List<ServerEndpointDataType> serverEndpoints;
    private final List<EndpointDataType> clientEndpoints;
    private final List<SecuritySettingsDataType> securitySettings;
    private final List<UserTokenSettingsDataType> userTokenSettings;
    private final List<AuthorizationServiceConfigurationDataType> authorizationServices;

    public ApplicationConfigurationDataTypeBuilderImpl(
        long configurationVersion,
        List<KeyValuePair> configurationProperties,
        ApplicationIdentityDataType applicationIdentity,
        List<CertificateGroupDataType> certificateGroups,
        List<ServerEndpointDataType> serverEndpoints,
        List<EndpointDataType> clientEndpoints,
        List<SecuritySettingsDataType> securitySettings,
        List<UserTokenSettingsDataType> userTokenSettings,
        List<AuthorizationServiceConfigurationDataType> authorizationServices) {
      this.configurationVersion = configurationVersion;
      this.configurationProperties = configurationProperties;
      this.applicationIdentity = applicationIdentity;
      this.certificateGroups = certificateGroups;
      this.serverEndpoints = serverEndpoints;
      this.clientEndpoints = clientEndpoints;
      this.securitySettings = securitySettings;
      this.userTokenSettings = userTokenSettings;
      this.authorizationServices = authorizationServices;
    }

    public ApplicationConfigurationDataType build() {
      ApplicationConfigurationDataType applicationConfigurationDataType =
          new ApplicationConfigurationDataType(
              configurationVersion,
              configurationProperties,
              applicationIdentity,
              certificateGroups,
              serverEndpoints,
              clientEndpoints,
              securitySettings,
              userTokenSettings,
              authorizationServices);
      return applicationConfigurationDataType;
    }
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (!(o instanceof ApplicationConfigurationDataType)) {
      return false;
    }
    ApplicationConfigurationDataType that = (ApplicationConfigurationDataType) o;
    return (getConfigurationVersion() == that.getConfigurationVersion())
        && (getConfigurationProperties() == that.getConfigurationProperties())
        && (getApplicationIdentity() == that.getApplicationIdentity())
        && (getCertificateGroups() == that.getCertificateGroups())
        && (getServerEndpoints() == that.getServerEndpoints())
        && (getClientEndpoints() == that.getClientEndpoints())
        && (getSecuritySettings() == that.getSecuritySettings())
        && (getUserTokenSettings() == that.getUserTokenSettings())
        && (getAuthorizationServices() == that.getAuthorizationServices())
        && super.equals(that)
        && true;
  }

  @Override
  public int hashCode() {
    return Objects.hash(
        super.hashCode(),
        getConfigurationVersion(),
        getConfigurationProperties(),
        getApplicationIdentity(),
        getCertificateGroups(),
        getServerEndpoints(),
        getClientEndpoints(),
        getSecuritySettings(),
        getUserTokenSettings(),
        getAuthorizationServices());
  }

  @Override
  public String toString() {
    WriteBufferBoxBased writeBufferBoxBased = new WriteBufferBoxBased(true, true);
    try {
      writeBufferBoxBased.writeSerializable(this);
    } catch (SerializationException e) {
      throw new RuntimeException(e);
    }
    return "\n" + writeBufferBoxBased.getBox().toString() + "\n";
  }
}
