/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli.sh.group;

import java.io.IOException;
import java.net.InetSocketAddress;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.OptionGroup;
import org.apache.commons.cli.Options;
import org.apache.ratis.client.RaftClient;
import org.apache.ratis.protocol.GroupListReply;
import org.apache.ratis.protocol.RaftClientReply;
import org.apache.ratis.protocol.RaftPeerId;
import org.apache.ratis.shell.cli.CliUtils;
import org.apache.ratis.shell.cli.sh.command.AbstractRatisCommand;
import org.apache.ratis.shell.cli.sh.command.Context;

public class GroupListCommand
extends AbstractRatisCommand {
    public static final String SERVER_ADDRESS_OPTION_NAME = "serverAddress";
    public static final String PEER_ID_OPTION_NAME = "peerId";

    public GroupListCommand(Context context) {
        super(context);
    }

    @Override
    public String getCommandName() {
        return "list";
    }

    @Override
    public int run(CommandLine cl) throws IOException {
        String address;
        RaftPeerId peerId;
        super.run(cl);
        if (cl.hasOption(PEER_ID_OPTION_NAME)) {
            peerId = RaftPeerId.getRaftPeerId((String)cl.getOptionValue(PEER_ID_OPTION_NAME));
            address = this.getRaftGroup().getPeer(peerId).getAddress();
        } else if (cl.hasOption(SERVER_ADDRESS_OPTION_NAME)) {
            address = cl.getOptionValue(SERVER_ADDRESS_OPTION_NAME);
            InetSocketAddress serverAddress = CliUtils.parseInetSocketAddress(address);
            peerId = CliUtils.getPeerId(serverAddress);
        } else {
            throw new IllegalArgumentException("Both peerId and serverAddress options are missing.");
        }
        try (RaftClient raftClient = this.newRaftClient();){
            GroupListReply reply = raftClient.getGroupManagementApi(peerId).list();
            this.processReply((RaftClientReply)reply, () -> String.format("Failed to get group information of peerId %s (server %s)", peerId, address));
            this.printf(String.format("The peerId %s (server %s) is in %d groups, and the groupIds is: %s", peerId, address, reply.getGroupIds().size(), reply.getGroupIds()), new Object[0]);
        }
        return 0;
    }

    @Override
    public String getUsage() {
        return String.format("%s -%s <PEER0_HOST:PEER0_PORT,PEER1_HOST:PEER1_PORT,PEER2_HOST:PEER2_PORT> [-%s <RAFT_GROUP_ID>] <[-%s <PEER0_HOST:PEER0_PORT>]|[-%s <peerId>]>", this.getCommandName(), "peers", "groupid", SERVER_ADDRESS_OPTION_NAME, PEER_ID_OPTION_NAME);
    }

    @Override
    public String getDescription() {
        return GroupListCommand.description();
    }

    @Override
    public Options getOptions() {
        OptionGroup group = new OptionGroup();
        group.setRequired(true);
        group.addOption(new Option(null, SERVER_ADDRESS_OPTION_NAME, true, "the server address"));
        group.addOption(new Option(null, PEER_ID_OPTION_NAME, true, "the peer id"));
        return super.getOptions().addOptionGroup(group);
    }

    public static String description() {
        return "Display the group information of a specific raft server";
    }
}

