/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.metrics;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Supplier;
import org.apache.ratis.metrics.LongCounter;
import org.apache.ratis.metrics.Timekeeper;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.metrics.RaftLogMetricsBase;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.UncheckedAutoCloseable;

public class SegmentedRaftLogMetrics
extends RaftLogMetricsBase {
    public static final String RAFT_LOG_FLUSH_TIME = "flushTime";
    public static final String RAFT_LOG_FLUSH_COUNT = "flushCount";
    public static final String RAFT_LOG_SYNC_TIME = "syncTime";
    public static final String RAFT_LOG_DATA_QUEUE_SIZE = "dataQueueSize";
    public static final String RAFT_LOG_WORKER_QUEUE_SIZE = "workerQueueSize";
    public static final String RAFT_LOG_SYNC_BATCH_SIZE = "syncBatchSize";
    public static final String RAFT_LOG_CACHE_MISS_COUNT = "cacheMissCount";
    public static final String RAFT_LOG_CACHE_HIT_COUNT = "cacheHitCount";
    public static final String RAFT_LOG_CACHE_CLOSED_SEGMENTS_NUM = "closedSegmentsNum";
    public static final String RAFT_LOG_CACHE_CLOSED_SEGMENTS_SIZE_IN_BYTES = "closedSegmentsSizeInBytes";
    public static final String RAFT_LOG_CACHE_OPEN_SEGMENT_SIZE_IN_BYTES = "openSegmentSizeInBytes";
    public static final String RAFT_LOG_APPEND_ENTRY_LATENCY = "appendEntryLatency";
    public static final String RAFT_LOG_TASK_QUEUE_TIME = "enqueuedTime";
    public static final String RAFT_LOG_TASK_ENQUEUE_DELAY = "queueingDelay";
    public static final String RAFT_LOG_TASK_EXECUTION_TIME = "%sExecutionTime";
    public static final String RAFT_LOG_APPEND_ENTRY_COUNT = "appendEntryCount";
    public static final String RAFT_LOG_PURGE_METRIC = "purgeLog";
    public static final String RAFT_LOG_STATEMACHINE_DATA_WRITE_TIMEOUT_COUNT = "numStateMachineDataWriteTimeout";
    public static final String RAFT_LOG_STATEMACHINE_DATA_READ_TIMEOUT_COUNT = "numStateMachineDataReadTimeout";
    public static final String RAFT_LOG_READ_ENTRY_LATENCY = "readEntryLatency";
    public static final String RAFT_LOG_LOAD_SEGMENT_LATENCY = "segmentLoadLatency";
    private final Timekeeper flushTimer = this.getRegistry().timer("flushTime");
    private final Timekeeper syncTimer = this.getRegistry().timer("syncTime");
    private final Timekeeper enqueuedTimer = this.getRegistry().timer("enqueuedTime");
    private final Timekeeper queuingDelayTimer = this.getRegistry().timer("queueingDelay");
    private final Timekeeper appendEntryTimer = this.getRegistry().timer("appendEntryLatency");
    private final Timekeeper readEntryTimer = this.getRegistry().timer("readEntryLatency");
    private final Timekeeper loadSegmentTimer = this.getRegistry().timer("segmentLoadLatency");
    private final Timekeeper purgeTimer = this.getRegistry().timer("purgeLog");
    private final LongCounter cacheHitCount = this.getRegistry().counter("cacheHitCount");
    private final LongCounter cacheMissCount = this.getRegistry().counter("cacheMissCount");
    private final LongCounter appendEntryCount = this.getRegistry().counter("appendEntryCount");
    private final LongCounter flushCount = this.getRegistry().counter("flushCount");
    private final LongCounter numStateMachineDataWriteTimeout = this.getRegistry().counter("numStateMachineDataWriteTimeout");
    private final LongCounter numStateMachineDataReadTimeout = this.getRegistry().counter("numStateMachineDataReadTimeout");
    private final Map<Class<?>, Timekeeper> taskClassTimers = new ConcurrentHashMap();

    public SegmentedRaftLogMetrics(RaftGroupMemberId serverId) {
        super(serverId);
    }

    public void addDataQueueSizeGauge(Supplier<Integer> numElements) {
        this.getRegistry().gauge(RAFT_LOG_DATA_QUEUE_SIZE, () -> numElements);
    }

    public void addClosedSegmentsNum(Supplier<Long> cachedSegmentNum) {
        this.getRegistry().gauge(RAFT_LOG_CACHE_CLOSED_SEGMENTS_NUM, () -> cachedSegmentNum);
    }

    public void addClosedSegmentsSizeInBytes(Supplier<Long> closedSegmentsSizeInBytes) {
        this.getRegistry().gauge(RAFT_LOG_CACHE_CLOSED_SEGMENTS_SIZE_IN_BYTES, () -> closedSegmentsSizeInBytes);
    }

    public void addOpenSegmentSizeInBytes(Supplier<Long> openSegmentSizeInBytes) {
        this.getRegistry().gauge(RAFT_LOG_CACHE_OPEN_SEGMENT_SIZE_IN_BYTES, () -> openSegmentSizeInBytes);
    }

    public void addLogWorkerQueueSizeGauge(Supplier<Integer> queueSize) {
        this.getRegistry().gauge(RAFT_LOG_WORKER_QUEUE_SIZE, () -> queueSize);
    }

    public void addFlushBatchSizeGauge(Supplier<Integer> flushBatchSize) {
        this.getRegistry().gauge(RAFT_LOG_SYNC_BATCH_SIZE, () -> flushBatchSize);
    }

    public UncheckedAutoCloseable startFlushTimer() {
        return Timekeeper.start(this.flushTimer);
    }

    public Timekeeper getSyncTimer() {
        return this.syncTimer;
    }

    public void onRaftLogCacheHit() {
        this.cacheHitCount.inc();
    }

    public void onRaftLogCacheMiss() {
        this.cacheMissCount.inc();
    }

    public void onRaftLogFlush() {
        this.flushCount.inc();
    }

    public void onRaftLogAppendEntry() {
        this.appendEntryCount.inc();
    }

    public Timekeeper.Context startAppendEntryTimer() {
        return this.appendEntryTimer.time();
    }

    public Timekeeper getEnqueuedTimer() {
        return this.enqueuedTimer;
    }

    public UncheckedAutoCloseable startQueuingDelayTimer() {
        return Timekeeper.start(this.queuingDelayTimer);
    }

    private Timekeeper newTaskExecutionTimer(Class<?> taskClass) {
        return this.getRegistry().timer(String.format(RAFT_LOG_TASK_EXECUTION_TIME, JavaUtils.getClassSimpleName(taskClass).toLowerCase()));
    }

    public UncheckedAutoCloseable startTaskExecutionTimer(Class<?> taskClass) {
        return Timekeeper.start(this.taskClassTimers.computeIfAbsent(taskClass, this::newTaskExecutionTimer));
    }

    public Timekeeper getReadEntryTimer() {
        return this.readEntryTimer;
    }

    public UncheckedAutoCloseable startLoadSegmentTimer() {
        return Timekeeper.start(this.loadSegmentTimer);
    }

    public UncheckedAutoCloseable startPurgeTimer() {
        return Timekeeper.start(this.purgeTimer);
    }

    @Override
    public void onStateMachineDataWriteTimeout() {
        this.numStateMachineDataWriteTimeout.inc();
    }

    @Override
    public void onStateMachineDataReadTimeout() {
        this.numStateMachineDataReadTimeout.inc();
    }
}

