/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.fxg.dom.fills;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.royale.compiler.fxg.FXGVersion;
import org.apache.royale.compiler.fxg.dom.IFXGNode;
import org.apache.royale.compiler.internal.fxg.dom.DOMParserHelper;
import org.apache.royale.compiler.internal.fxg.dom.fills.AbstractFillNode;
import org.apache.royale.compiler.internal.fxg.dom.transforms.MatrixNode;
import org.apache.royale.compiler.internal.fxg.dom.types.FillMode;
import org.apache.royale.compiler.problems.ICompilerProblem;

public class BitmapFillNode
extends AbstractFillNode {
    public double x = Double.NaN;
    public double y = Double.NaN;
    public boolean repeat = true;
    public double rotation = 0.0;
    public double scaleX = Double.NaN;
    public double scaleY = Double.NaN;
    public String source;
    public FillMode fillMode = FillMode.SCALE;
    public MatrixNode matrix;

    @Override
    public void addChild(IFXGNode child, Collection<ICompilerProblem> problems) {
        if (child instanceof MatrixNode) {
            this.matrix = (MatrixNode)child;
        } else {
            super.addChild(child, problems);
        }
    }

    @Override
    public List<IFXGNode> getChildren() {
        ArrayList<IFXGNode> children = new ArrayList<IFXGNode>();
        children.addAll(super.getChildren());
        children.add(this.matrix);
        return children;
    }

    @Override
    public String getNodeName() {
        return "BitmapFill";
    }

    @Override
    public void setAttribute(String name, String value, Collection<ICompilerProblem> problems) {
        if ("x".equals(name)) {
            this.x = DOMParserHelper.parseDouble(this, value, name, this.x, problems);
        } else if ("y".equals(name)) {
            this.y = DOMParserHelper.parseDouble(this, value, name, this.y, problems);
        } else if (this.getFileVersion().equalTo(FXGVersion.v1_0) && "repeat".equals(name)) {
            this.repeat = DOMParserHelper.parseBoolean(this, value, name, this.repeat, problems);
        } else if ("rotation".equals(name)) {
            this.rotation = DOMParserHelper.parseDouble(this, value, name, this.rotation, problems);
        } else if ("scaleX".equals(name)) {
            this.scaleX = DOMParserHelper.parseDouble(this, value, name, this.scaleX, problems);
        } else if ("scaleY".equals(name)) {
            this.scaleY = DOMParserHelper.parseDouble(this, value, name, this.scaleY, problems);
        } else if ("source".equals(name)) {
            this.source = value;
        } else if (!this.getFileVersion().equalTo(FXGVersion.v1_0) && "fillMode".equals(name)) {
            this.fillMode = DOMParserHelper.parseFillMode(this, value, this.fillMode, problems);
        } else {
            super.setAttribute(name, value, problems);
        }
    }
}

