/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.test.ant.report;

import java.io.File;
import java.io.FileOutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.royale.test.ant.LoggingUtil;
import org.apache.royale.test.ant.report.Suite;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.util.DateUtils;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class Report {
    private static final String FAILURE = "failure";
    private static final String ERROR = "error";
    private static final String IGNORE = "ignore";
    private static final String TEST_SUITE = "testsuite";
    private static final String NAME_ATTRIBUTE_LABEL = "name";
    private static final String FAILURE_ATTRIBUTE_LABEL = "failures";
    private static final String ERROR_ATTRIBUTE_LABEL = "errors";
    private static final String IGNORE_ATTRIBUTE_LABEL = "skipped";
    private static final String TIME_ATTRIBUTE_LABEL = "time";
    private static final String TESTS_ATTRIBUTE_LABEL = "tests";
    private static final String HOSTNAME_ATTRIBUTE_LABEL = "hostname";
    private static final String TIMESTAMP_ATTRIBUTE_LABEL = "timestamp";
    private static final String FILENAME_PREFIX = "TEST-";
    private static final String FILENAME_EXTENSION = ".xml";
    private static final String FAILED_TEST = "RoyaleUnit test {0} in suite {1} failed.";
    private static final String ERRORED_TEST = "RoyaleUnit test {0} in suite {1} had errors.";
    private static final String IGNORED_TEST = "RoyaleUnit test {0} in suite {1} was ignored.";
    private static final String TEST_INFO = "Suite: {0}\nTests run: {1}, Failures: {2}, Errors: {3}, Skipped: {4}, Time elapsed: {5} sec";
    private static final String ERROR_SAVING_REPORT = "Error saving report.";
    private static final String CLASSNAME_ATTRIBUTE = "classname";
    private static final String NAME_ATTRIBUTE = "name";
    private static final String STATUS_ATTRIBUTE = "status";
    private static final String TIME_ATTRIBUTE = "time";
    protected Suite suite;
    private Document document;
    private List<String> recordedRuns = new ArrayList<String>();

    public Report(Suite suite) {
        this.suite = suite;
        this.document = DocumentHelper.createDocument();
        this.document.addElement(TEST_SUITE).addAttribute("name", suite.getName()).addAttribute(TESTS_ATTRIBUTE_LABEL, String.valueOf(suite.getTests())).addAttribute(FAILURE_ATTRIBUTE_LABEL, String.valueOf(suite.getFailures())).addAttribute(ERROR_ATTRIBUTE_LABEL, String.valueOf(suite.getErrors())).addAttribute(IGNORE_ATTRIBUTE_LABEL, String.valueOf(suite.getSkips())).addAttribute("time", String.valueOf(suite.getTime()));
    }

    public void addTest(Document test) {
        Element root = test.getRootElement();
        String testMethod = root.attributeValue("name");
        if (!this.recordedRuns.contains(testMethod) && !testMethod.equals("null")) {
            this.recordedRuns.add(testMethod);
            this.suite.addTest();
        }
        long time = Long.parseLong(root.attributeValue("time"));
        this.suite.addTime(time);
        root.attribute("time").setText(this.formatTime(time));
        if (root.attributeValue("name").equals("null")) {
            root.attribute("name").setText(root.attributeValue(CLASSNAME_ATTRIBUTE));
        }
        this.document.getRootElement().add(root);
        this.checkForStatus(test);
        root.remove(root.attribute(STATUS_ATTRIBUTE));
    }

    private String formatTime(long time) {
        return String.format("%.3f", new Double((double)time / 1000.0));
    }

    private void checkForStatus(Document test) {
        Element root = test.getRootElement();
        String name = root.attributeValue("name");
        String status = root.attributeValue(STATUS_ATTRIBUTE);
        String format = null;
        if (status.equals(FAILURE)) {
            format = FAILED_TEST;
            this.suite.addFailure();
        } else if (status.equals(ERROR)) {
            format = ERRORED_TEST;
            this.suite.addError();
        } else if (status.equals(IGNORE)) {
            format = IGNORED_TEST;
            this.suite.addSkip();
        }
        if (format != null) {
            String message = MessageFormat.format(format, name, this.suite);
            LoggingUtil.log(message);
        }
    }

    public boolean hasFailures() {
        return this.suite.getErrors() > 0 || this.suite.getFailures() > 0;
    }

    public void save(File reportDir) throws BuildException {
        try {
            File file = new File(reportDir, FILENAME_PREFIX + this.suite + FILENAME_EXTENSION);
            Element root = this.document.getRootElement();
            root.addAttribute(FAILURE_ATTRIBUTE_LABEL, String.valueOf(this.suite.getFailures()));
            root.addAttribute(ERROR_ATTRIBUTE_LABEL, String.valueOf(this.suite.getErrors()));
            root.addAttribute(TESTS_ATTRIBUTE_LABEL, String.valueOf(this.suite.getTests()));
            root.addAttribute(IGNORE_ATTRIBUTE_LABEL, String.valueOf(this.suite.getSkips()));
            root.addAttribute("time", String.valueOf(this.formatTime(this.suite.getTime())));
            root.addAttribute(HOSTNAME_ATTRIBUTE_LABEL, this.getHostname());
            String timestamp = DateUtils.format((Date)new Date(), (String)"yyyy-MM-dd'T'HH:mm:ss");
            root.addAttribute(TIMESTAMP_ATTRIBUTE_LABEL, timestamp);
            OutputFormat format = OutputFormat.createPrettyPrint();
            XMLWriter writer = new XMLWriter(new FileOutputStream(file), format);
            writer.write(this.document);
            writer.close();
        }
        catch (Exception e) {
            throw new BuildException(ERROR_SAVING_REPORT, (Throwable)e);
        }
    }

    private String getHostname() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return "localhost";
        }
    }

    public String getSummary() {
        String summary = "";
        try {
            summary = MessageFormat.format(TEST_INFO, new String(this.suite.getName()), new Integer(this.suite.getTests()), new Integer(this.suite.getFailures()), new Integer(this.suite.getErrors()), new Integer(this.suite.getSkips()), this.formatTime(this.suite.getTime()));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return summary;
    }
}

