/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.internal.as.codegen;

import org.apache.royale.abc.instructionlist.InstructionList;
import org.apache.royale.compiler.internal.as.codegen.Binding;
import org.apache.royale.compiler.internal.as.codegen.ControlFlowContextManager;
import org.apache.royale.compiler.internal.as.codegen.LabelScopeControlFlowContext;
import org.apache.royale.compiler.internal.as.codegen.LexicalScope;
import org.apache.royale.compiler.tree.as.IASNode;

class WithContext
extends LabelScopeControlFlowContext {
    LexicalScope currentScope;
    Binding withStorage = null;

    WithContext(IASNode withContents, ControlFlowContextManager mgr) {
        super(withContents);
        this.currentScope = mgr.currentScope;
    }

    Binding getWithStorage() {
        if (!this.hasWithStorage()) {
            this.withStorage = this.currentScope.allocateTemp();
        }
        return this.withStorage;
    }

    boolean hasWithStorage() {
        return this.withStorage != null;
    }

    void finish(InstructionList result) {
        if (this.hasWithStorage()) {
            this.currentScope.releaseTemp(this.withStorage);
        }
    }

    @Override
    InstructionList addExitPath(InstructionList exitBranch) {
        InstructionList with_fixup = new InstructionList();
        with_fixup.addInstruction(29);
        with_fixup.addInstruction(this.getWithStorage().kill());
        with_fixup.addAll(exitBranch);
        return with_fixup;
    }

    @Override
    void addExceptionHandlerEntry(InstructionList exceptionHandler) {
        exceptionHandler.addInstruction(this.getWithStorage().getlocal());
        exceptionHandler.addInstruction(28);
    }
}

