/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.playwright.impl;

import com.microsoft.playwright.impl.ListenerCollection;
import com.microsoft.playwright.impl.Waitable;
import java.util.function.Consumer;
import java.util.function.Predicate;

class WaitableEvent<EventType, T>
implements Waitable<T>,
Consumer<T> {
    final ListenerCollection<EventType> listeners;
    private final EventType type;
    private final Predicate<T> predicate;
    private T eventArg;

    WaitableEvent(ListenerCollection<EventType> listeners, EventType type) {
        this(listeners, type, null);
    }

    WaitableEvent(ListenerCollection<EventType> listeners, EventType type, Predicate<T> predicate) {
        this.listeners = listeners;
        this.type = type;
        this.predicate = predicate;
        listeners.add(type, this);
    }

    @Override
    public void accept(T eventArg) {
        if (this.predicate != null && !this.predicate.test(eventArg)) {
            return;
        }
        this.eventArg = eventArg;
        this.dispose();
    }

    @Override
    public boolean isDone() {
        return this.eventArg != null;
    }

    @Override
    public void dispose() {
        this.listeners.remove(this.type, this);
    }

    @Override
    public T get() {
        return this.eventArg;
    }
}

