/*
 * Decompiled with CFR 0.152.
 */
package flash.swf;

import flash.swf.Action;
import flash.swf.actions.Label;
import flash.swf.actions.Push;
import flash.swf.actions.StoreRegister;
import flash.swf.actions.StrictMode;
import flash.swf.actions.WaitForFrame;
import flash.swf.debug.LineRecord;
import flash.swf.debug.RegisterRecord;
import flash.swf.types.ActionList;
import java.util.ArrayList;
import java.util.List;

public final class ActionFactory {
    public static final Object UNDEFINED;
    public static final Object STACKTOP;
    private static final Action[] actionFlyweights;
    private static final Push[] pushCpoolFlyweights;
    private static final Push[] pushRegisterFlyweights;
    private static final StoreRegister[] storeRegisterFlyweights;
    private static final Push pushTrueFlyweight;
    private static final Push pushFalseFlyweight;
    private static final Push pushUndefinedFlyweight;
    private static final Push pushNullFlyweight;
    private static final Push pushFloat0Flyweight;
    private static final Push pushInteger0Flyweight;
    private static final Push pushDouble0Flyweight;
    private static final Action callFlyweight;
    private static final StrictMode strictTrueFlyweight;
    private static final StrictMode strictFalseFlyweight;
    private final int startOffset;
    private final int startCount;
    private final Action[] actions;
    private final Label[] labels;
    private final LineRecord[] lines;
    private final RegisterRecord[] registers;
    private final int[] actionOffsets;
    private int count;
    private List<SkipEntry> skipRecords;

    public static Action createAction(int code) {
        return actionFlyweights[code];
    }

    public static Push createPushCpool(int index) {
        return index < pushCpoolFlyweights.length ? pushCpoolFlyweights[index] : new Push((Object)((short)index));
    }

    public static Push createPush(String s) {
        return new Push(s);
    }

    public static Push createPush(float fvalue) {
        return fvalue == 0.0f ? pushFloat0Flyweight : new Push(Float.valueOf(fvalue));
    }

    public static Push createPushNull() {
        return pushNullFlyweight;
    }

    public static Push createPushUndefined() {
        return pushUndefinedFlyweight;
    }

    public static Push createPushRegister(int regno) {
        return pushRegisterFlyweights[regno];
    }

    public static Push createPush(boolean b) {
        return b ? pushTrueFlyweight : pushFalseFlyweight;
    }

    public static Push createPush(double dvalue) {
        return dvalue == 0.0 ? pushDouble0Flyweight : new Push(dvalue);
    }

    public static Push createPush(int ivalue) {
        return ivalue == 0 ? pushInteger0Flyweight : new Push((Object)ivalue);
    }

    public static StoreRegister createStoreRegister(int register) {
        return storeRegisterFlyweights[register];
    }

    public static Action createCall() {
        return callFlyweight;
    }

    public static StrictMode createStrictMode(boolean mode) {
        return mode ? strictTrueFlyweight : strictFalseFlyweight;
    }

    public ActionFactory(int length, int startOffset, int startCount) {
        this.startOffset = startOffset;
        this.startCount = startCount;
        this.labels = new Label[length + 1];
        this.lines = new LineRecord[length];
        this.registers = new RegisterRecord[length];
        this.actions = new Action[length];
        this.actionOffsets = new int[length + 1];
        this.skipRecords = new ArrayList<SkipEntry>();
    }

    public void setLine(int offset, LineRecord line) {
        int i = offset - this.startOffset;
        if (this.lines[i] == null) {
            ++this.count;
        }
        this.lines[i] = line;
    }

    public void setRegister(int offset, RegisterRecord record) {
        int i = offset - this.startOffset;
        if (this.registers[i] == null) {
            ++this.count;
        }
        this.registers[i] = record;
    }

    public void setAction(int offset, Action a) {
        int i = offset - this.startOffset;
        if (this.actions[i] == null) {
            ++this.count;
        }
        this.actions[i] = a;
    }

    public Label getLabel(int target) {
        int i = target - this.startOffset;
        Label label = null;
        if (i >= 0 && i < this.labels.length && (label = this.labels[i]) == null) {
            this.labels[i] = label = new Label();
            ++this.count;
        }
        return label;
    }

    public void setActionOffset(int actionCount, int offset) {
        this.actionOffsets[actionCount - this.startCount] = offset;
    }

    public ActionList createActionList(boolean keepOffsets) {
        this.processSkipEntries();
        ActionList list = new ActionList(keepOffsets);
        list.grow(this.count);
        int length = this.actions.length;
        if (keepOffsets) {
            Action a;
            for (int i = 0; i < length; ++i) {
                int offset = this.startOffset + i;
                a = this.actions[i];
                if (a != null) {
                    list.insert(offset, a);
                }
                if ((a = this.lines[i]) != null) {
                    list.insert(offset, a);
                }
                if ((a = this.registers[i]) != null) {
                    list.insert(offset, a);
                }
                if ((a = this.labels[i]) == null) continue;
                list.insert(offset, a);
            }
            a = this.labels[length];
            if (a != null) {
                list.insert(this.startOffset + length, a);
            }
        } else {
            Action a;
            for (int i = 0; i < length; ++i) {
                a = this.labels[i];
                if (a != null) {
                    list.append(a);
                }
                if ((a = this.lines[i]) != null) {
                    list.append(a);
                }
                if ((a = this.registers[i]) != null) {
                    list.append(a);
                }
                if ((a = this.actions[i]) == null) continue;
                list.append(a);
            }
            a = this.labels[length];
            if (a != null) {
                list.append(a);
            }
        }
        return list;
    }

    private void processSkipEntries() {
        for (SkipEntry skipRecord : this.skipRecords) {
            int labelOffset = this.actionOffsets[skipRecord.skipTarget - this.startCount];
            skipRecord.action.skipTarget = this.getLabel(labelOffset);
        }
    }

    public void addSkipEntry(WaitForFrame a, int skipTarget) {
        this.skipRecords.add(new SkipEntry(a, skipTarget));
    }

    static {
        int i;
        UNDEFINED = new Object(){

            public String toString() {
                return "undefined";
            }
        };
        STACKTOP = new Object(){

            public String toString() {
                return "stack";
            }
        };
        actionFlyweights = new Action[128];
        pushCpoolFlyweights = new Push[256];
        pushRegisterFlyweights = new Push[256];
        storeRegisterFlyweights = new StoreRegister[256];
        pushTrueFlyweight = new Push(Boolean.TRUE);
        pushFalseFlyweight = new Push(Boolean.FALSE);
        pushUndefinedFlyweight = new Push(UNDEFINED);
        pushNullFlyweight = new Push(null);
        pushFloat0Flyweight = new Push(Float.valueOf(0.0f));
        pushInteger0Flyweight = new Push((Object)0);
        pushDouble0Flyweight = new Push(0.0);
        callFlyweight = new Action(158);
        strictTrueFlyweight = new StrictMode(true);
        strictFalseFlyweight = new StrictMode(false);
        for (i = 0; i < 128; ++i) {
            ActionFactory.actionFlyweights[i] = new Action(i);
        }
        for (i = 0; i < 256; ++i) {
            ActionFactory.pushRegisterFlyweights[i] = new Push((Object)((byte)i));
            ActionFactory.pushCpoolFlyweights[i] = new Push((Object)((short)i));
            ActionFactory.storeRegisterFlyweights[i] = new StoreRegister(i);
        }
    }

    private static class SkipEntry {
        WaitForFrame action;
        int skipTarget;

        public SkipEntry(WaitForFrame action, int skipTarget) {
            this.action = action;
            this.skipTarget = skipTarget;
        }
    }
}

