/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableList;
import com.google.javascript.jscomp.AbstractCompiler;
import com.google.javascript.jscomp.CompilerOptions;
import com.google.javascript.jscomp.FieldCleanupPass;
import com.google.javascript.jscomp.GlobalVarReferenceMap;
import com.google.javascript.jscomp.HotSwapCompilerPass;
import com.google.javascript.jscomp.NodeUtil;
import com.google.javascript.jscomp.PassConfig;
import com.google.javascript.jscomp.PassFactory;
import com.google.javascript.jscomp.ScopeCreator;
import com.google.javascript.jscomp.TypedScopeCreator;
import com.google.javascript.jscomp.TypedVar;
import com.google.javascript.jscomp.parsing.parser.FeatureSet;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.jstype.FunctionType;
import com.google.javascript.rhino.jstype.JSType;
import java.util.ArrayList;
import java.util.List;

class CleanupPasses
extends PassConfig {
    final PassFactory fieldCleanupPassFactory = new PassFactory.HotSwapPassFactory("FieldCleanupPassFactory"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new FieldCleanupPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    final PassFactory scopeCleanupPassFactory = new PassFactory.HotSwapPassFactory("ScopeCleanupPassFactory"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new MemoizedScopeCleanupPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };
    final PassFactory globalVarRefCleanupPassFactory = new PassFactory.HotSwapPassFactory("GlobalVarRefCleanupPassFactory"){

        @Override
        protected HotSwapCompilerPass create(AbstractCompiler compiler) {
            return new GlobalVarReferenceMap.GlobalVarRefCleanupPass(compiler);
        }

        @Override
        protected FeatureSet featureSet() {
            return FeatureSet.ES5;
        }
    };

    public CleanupPasses(CompilerOptions options) {
        super(options);
    }

    @Override
    protected List<PassFactory> getChecks() {
        ArrayList<PassFactory> checks = new ArrayList<PassFactory>();
        checks.add(this.fieldCleanupPassFactory);
        checks.add(this.scopeCleanupPassFactory);
        checks.add(this.globalVarRefCleanupPassFactory);
        return checks;
    }

    @Override
    protected List<PassFactory> getOptimizations() {
        return ImmutableList.of();
    }

    static class MemoizedScopeCleanupPass
    implements HotSwapCompilerPass {
        private final AbstractCompiler compiler;

        public MemoizedScopeCleanupPass(AbstractCompiler compiler) {
            this.compiler = compiler;
        }

        @Override
        public void hotSwapScript(Node scriptRoot, Node originalRoot) {
            ScopeCreator creator = this.compiler.getTypedScopeCreator();
            if (creator instanceof TypedScopeCreator) {
                TypedScopeCreator scopeCreator = (TypedScopeCreator)creator;
                String newSrc = scriptRoot.getSourceFileName();
                for (TypedVar var : scopeCreator.getAllSymbols()) {
                    FunctionType fnType;
                    JSType type = var.getType();
                    if (type == null || (fnType = type.toMaybeFunctionType()) == null || !newSrc.equals(NodeUtil.getSourceName(fnType.getSource()))) continue;
                    fnType.setSource(null);
                }
                scopeCreator.removeScopesForScript(originalRoot.getSourceFileName());
            }
        }

        @Override
        public void process(Node externs, Node root) {
        }
    }
}

