/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.compiler.utils;

import org.apache.royale.compiler.definitions.IClassDefinition;
import org.apache.royale.compiler.definitions.IDefinition;
import org.apache.royale.compiler.definitions.IInterfaceDefinition;
import org.apache.royale.compiler.internal.definitions.ParameterDefinition;
import org.apache.royale.compiler.internal.scopes.CatchScope;
import org.apache.royale.compiler.projects.ICompilerProject;

public class DefinitionUtils {
    public static final String JSROYALE_SUPPRESS_EXPORT = "JSRoyaleSuppressExport";

    public static boolean hasExportSuppressed(IDefinition def) {
        return def.hasMetaTagByName(JSROYALE_SUPPRESS_EXPORT);
    }

    public static final boolean isMemberDefinition(IDefinition definition) {
        return definition != null && (definition.getParent() instanceof IClassDefinition || definition.getParent() instanceof IInterfaceDefinition);
    }

    public static final int deltaFromObject(IClassDefinition definition, ICompilerProject project) {
        int ret = -1;
        if (definition != null) {
            return definition.resolveAncestry(project).length - 1;
        }
        return ret;
    }

    public static final boolean isRewrittenMultiCatchParam(IDefinition definition) {
        return definition instanceof ParameterDefinition && definition.getContainingScope() instanceof CatchScope && definition.getBaseName().equals("$$royaleMultiCatchErr");
    }
}

