/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.Immutable;
import com.google.javascript.jscomp.VariableMap;

@Immutable
public final class ReplacedStringsDecoder {
    public static final String ARGUMENT_PLACE_HOLDER = "`";
    private final ImmutableMap<String, String> originalToNewNameMap;
    public static final ReplacedStringsDecoder NULL_DECODER = new ReplacedStringsDecoder(VariableMap.fromMap(ImmutableMap.of()));

    public ReplacedStringsDecoder(VariableMap variableMap) {
        this.originalToNewNameMap = ImmutableMap.copyOf(variableMap.getOriginalNameToNewNameMap());
    }

    public String decode(String encodedStr) {
        String[] suppliedBits = encodedStr.split(ARGUMENT_PLACE_HOLDER, -1);
        String originalStr = this.originalToNewNameMap.get(suppliedBits[0]);
        if (originalStr == null) {
            return encodedStr;
        }
        String[] originalBits = originalStr.split(ARGUMENT_PLACE_HOLDER, -1);
        StringBuilder sb = new StringBuilder(originalBits[0]);
        for (int i = 1; i < Math.max(originalBits.length, suppliedBits.length); ++i) {
            sb.append(i < suppliedBits.length ? suppliedBits[i] : "-");
            sb.append(i < originalBits.length ? originalBits[i] : "-");
        }
        return sb.toString();
    }
}

