/*
 * Decompiled with CFR 0.152.
 */
package com.google.javascript.jscomp;

import com.google.javascript.jscomp.NodeTraversal;
import com.google.javascript.rhino.Node;
import com.google.javascript.rhino.Token;

class AnonymousFunctionNamingCallback
extends NodeTraversal.AbstractPostOrderCallback {
    private final FunctionNamer namer;

    AnonymousFunctionNamingCallback(FunctionNamer namer) {
        this.namer = namer;
    }

    @Override
    public void visit(NodeTraversal t, Node n, Node parent) {
        switch (n.getToken()) {
            case FUNCTION: {
                Node functionNameNode = n.getFirstChild();
                String functionName = functionNameNode.getString();
                if (!functionName.isEmpty() || n.isArrowFunction()) break;
                if (parent.isAssign() || parent.isDefaultValue()) {
                    Node lhs = parent.getFirstChild();
                    String name = this.namer.getName(lhs);
                    this.namer.setFunctionName(name, n);
                    break;
                }
                if (!parent.isName()) break;
                String name = this.namer.getName(parent);
                this.namer.setFunctionName(name, n);
                break;
            }
            case ASSIGN: {
                Node lhs = n.getFirstChild();
                Node rhs = lhs.getNext();
                if (!rhs.isObjectLit()) break;
                this.nameObjectLiteralMethods(rhs, this.namer.getName(lhs));
                break;
            }
        }
    }

    private void nameObjectLiteralMethods(Node objectLiteral, String context) {
        for (Node keyNode = objectLiteral.getFirstChild(); keyNode != null; keyNode = keyNode.getNext()) {
            if (!keyNode.isStringKey() && !keyNode.isComputedProp()) continue;
            String name = this.namer.getCombinedName(context, this.namer.getName(keyNode));
            Node valueNode = keyNode.isStringKey() ? keyNode.getOnlyChild() : keyNode.getLastChild();
            Token type = valueNode.getToken();
            if (type == Token.FUNCTION && !valueNode.isArrowFunction()) {
                Node functionNameNode = valueNode.getFirstChild();
                String functionName = functionNameNode.getString();
                if (!functionName.isEmpty()) continue;
                this.namer.setFunctionName(name, valueNode);
                continue;
            }
            if (type != Token.OBJECTLIT) continue;
            this.nameObjectLiteralMethods(valueNode, name);
        }
    }

    static interface FunctionNamer {
        public String getName(Node var1);

        public void setFunctionName(String var1, Node var2);

        public String getCombinedName(String var1, String var2);
    }
}

