/*
 * Decompiled with CFR 0.152.
 */
package flash.swf.types;

import flash.swf.SwfEncoder;
import flash.swf.Tag;
import flash.swf.types.ArrayLists;
import flash.swf.types.FillStyle;
import flash.swf.types.LineStyle;
import flash.swf.types.ShapeRecord;
import java.util.ArrayList;
import java.util.List;

public class StyleChangeRecord
extends ShapeRecord {
    public boolean stateNewStyles;
    public boolean stateLineStyle;
    public boolean stateFillStyle1;
    public boolean stateFillStyle0;
    public boolean stateMoveTo;
    public int moveDeltaX;
    public int moveDeltaY;
    public int fillstyle0;
    public int fillstyle1;
    public int linestyle;
    public ArrayList<FillStyle> fillstyles;
    public ArrayList<LineStyle> linestyles;

    public StyleChangeRecord() {
    }

    public StyleChangeRecord(int moveDeltaX, int moveDeltaY) {
        if (moveDeltaX != 0 || moveDeltaY != 0) {
            this.setMove(moveDeltaX, moveDeltaY);
        }
    }

    public StyleChangeRecord(int linestyle, int fillstyle0, int fillstyle1) {
        if (linestyle > 0) {
            this.setLinestyle(linestyle);
        }
        if (fillstyle0 > 0) {
            this.setFillStyle0(fillstyle0);
        }
        if (fillstyle1 > 0) {
            this.setFillStyle1(fillstyle1);
        }
    }

    public StyleChangeRecord(int moveDeltaX, int moveDeltaY, int linestyle, int fillstyle0, int fillstyle1) {
        this(moveDeltaX, moveDeltaY);
        if (linestyle > 0) {
            this.setLinestyle(linestyle);
        }
        if (fillstyle0 > 0) {
            this.setFillStyle0(fillstyle0);
        }
        if (fillstyle1 > 0) {
            this.setFillStyle1(fillstyle1);
        }
    }

    public String toString() {
        String retVal = "Style: newStyle=" + this.stateNewStyles + " lineStyle=" + this.stateLineStyle + " fillStyle=" + this.stateFillStyle1 + " fileStyle0=" + this.stateFillStyle0 + " moveTo=" + this.stateMoveTo;
        if (this.stateMoveTo) {
            retVal = retVal + " x=" + this.moveDeltaX + " y=" + this.moveDeltaY;
        }
        return retVal;
    }

    @Override
    public boolean equals(Object object) {
        boolean isEqual = false;
        if (super.equals(object) && object instanceof StyleChangeRecord) {
            StyleChangeRecord styleChangeRecord = (StyleChangeRecord)object;
            if (styleChangeRecord.stateNewStyles == this.stateNewStyles && styleChangeRecord.stateLineStyle == this.stateLineStyle && styleChangeRecord.stateFillStyle1 == this.stateFillStyle1 && styleChangeRecord.stateFillStyle0 == this.stateFillStyle0 && styleChangeRecord.stateMoveTo == this.stateMoveTo && styleChangeRecord.moveDeltaX == this.moveDeltaX && styleChangeRecord.moveDeltaY == this.moveDeltaY && styleChangeRecord.fillstyle0 == this.fillstyle0 && styleChangeRecord.fillstyle1 == this.fillstyle1 && styleChangeRecord.linestyle == this.linestyle && (styleChangeRecord.fillstyles == null && this.fillstyles == null || styleChangeRecord.fillstyles != null && this.fillstyles != null && ArrayLists.equals(styleChangeRecord.fillstyles, this.fillstyles)) && (styleChangeRecord.linestyles == null && this.linestyles == null || styleChangeRecord.linestyles != null && this.linestyles != null && ArrayLists.equals(styleChangeRecord.linestyles, this.linestyles))) {
                isEqual = true;
            }
        }
        return isEqual;
    }

    public void setMove(int x, int y) {
        this.stateMoveTo = true;
        this.moveDeltaX = x;
        this.moveDeltaY = y;
    }

    @Override
    public void getReferenceList(List<Tag> list) {
        if (this.fillstyles != null) {
            for (FillStyle style : this.fillstyles) {
                if (!style.hasBitmapId() || style.bitmap == null) continue;
                list.add(style.bitmap);
            }
        }
    }

    public int nMoveBits() {
        return SwfEncoder.minBits(SwfEncoder.maxNum(this.moveDeltaX, this.moveDeltaY, 0, 0), 1);
    }

    public void setFillStyle1(int index) {
        this.stateFillStyle1 = true;
        this.fillstyle1 = index;
    }

    public void setFillStyle0(int index) {
        this.stateFillStyle0 = true;
        this.fillstyle0 = index;
    }

    public void setLinestyle(int index) {
        this.stateLineStyle = true;
        this.linestyle = index;
    }

    @Override
    public void addToDelta(int x, int y) {
        this.moveDeltaX += x;
        this.moveDeltaY += y;
    }
}

