/*
 * Decompiled with CFR 0.152.
 */
package org.apache.royale.formatter.config;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.royale.compiler.exceptions.ConfigurationException;
import org.apache.royale.compiler.internal.config.annotations.Arguments;
import org.apache.royale.compiler.internal.config.annotations.Config;
import org.apache.royale.compiler.internal.config.annotations.InfiniteArguments;
import org.apache.royale.compiler.internal.config.annotations.Mapping;
import org.apache.royale.compiler.problems.DeprecatedConfigurationOptionProblem;
import org.apache.royale.compiler.problems.ICompilerProblem;
import org.apache.royale.compiler.problems.RemovedConfigurationOptionProblem;
import org.apache.royale.formatter.config.ConfigurationBuffer;
import org.apache.royale.formatter.config.ConfigurationInfo;
import org.apache.royale.formatter.config.ConfigurationValue;
import org.apache.royale.formatter.config.Semicolons;

public class Configuration {
    private static Map<String, String> aliases = null;
    private Collection<ICompilerProblem> configurationProblems = new ArrayList<ICompilerProblem>();
    private List<String> files = new ArrayList<String>();
    private boolean writeFiles = false;
    private boolean listFiles = false;
    private boolean insertSpaces = false;
    private boolean insertFinalNewLine = false;
    private boolean placeOpenBraceOnNewLine = true;
    private boolean insertSpaceAfterSemicolonInForStatements = true;
    private boolean insertSpaceAfterKeywordsInControlFlowStatements = true;
    private boolean insertSpaceAfterFunctionKeywordForAnonymousFunctions = false;
    private boolean insertSpaceBeforeAndAfterBinaryOperators = true;
    private boolean insertSpaceAfterCommaDelimiter = true;
    private boolean insertSpaceBetweenMetadataAttributes = true;
    private boolean insertSpaceAtStartOfLineComment = true;
    private boolean collapseEmptyBlocks = false;
    private int tabSize = 4;
    private int maxPreserveNewLines = 2;
    private Semicolons semicolons = Semicolons.INSERT;
    private boolean ignoreParsingProblems = false;
    private boolean mxmlAlignAttributes = false;
    private boolean mxmlInsertNewLineBetweenAttributes = false;

    public static Map<String, String> getAliases() {
        if (aliases == null) {
            aliases = new HashMap<String, String>();
            aliases.put("w", "write-files");
            aliases.put("l", "list-files");
        }
        return aliases;
    }

    public Collection<ICompilerProblem> getConfigurationProblems() {
        return this.configurationProblems;
    }

    public void validate(ConfigurationBuffer configurationBuffer) throws ConfigurationException {
        this.processDeprecatedAndRemovedOptions(configurationBuffer);
    }

    private void processDeprecatedAndRemovedOptions(ConfigurationBuffer configurationBuffer) {
        for (String var : configurationBuffer.getVars()) {
            ConfigurationInfo info = configurationBuffer.getInfo(var);
            List<ConfigurationValue> values = configurationBuffer.getVar(var);
            if (values == null) continue;
            for (ConfigurationValue cv : values) {
                if (info.isRemoved()) {
                    this.addRemovedConfigurationOptionProblem(cv);
                    continue;
                }
                if (!info.isDeprecated() || configurationBuffer.getVar(var) == null) continue;
                String replacement = info.getDeprecatedReplacement();
                String since = info.getDeprecatedSince();
                DeprecatedConfigurationOptionProblem problem = new DeprecatedConfigurationOptionProblem(var, replacement, since, cv.getSource(), cv.getLine());
                this.configurationProblems.add((ICompilerProblem)problem);
            }
        }
    }

    private void addRemovedConfigurationOptionProblem(ConfigurationValue cv) {
        RemovedConfigurationOptionProblem problem = new RemovedConfigurationOptionProblem(cv.getVar(), cv.getSource(), cv.getLine());
        this.configurationProblems.add((ICompilerProblem)problem);
    }

    @Config(displayed=false, greedy=true)
    @Arguments(value={"keyword"})
    @InfiniteArguments
    public void setHelp(ConfigurationValue cv, String[] keywords) {
    }

    @Config
    public void setVersion(ConfigurationValue cv, boolean value) {
    }

    public List<String> getFiles() {
        return this.files;
    }

    @Config(allowMultiple=true, hidden=true)
    @Mapping(value={"files"})
    @Arguments(value={"path-element"})
    @InfiniteArguments
    public void setFiles(ConfigurationValue cv, List<String> args) throws ConfigurationException {
        this.files.addAll(args);
    }

    public boolean getWriteFiles() {
        return this.writeFiles;
    }

    @Config
    @Mapping(value={"write-files"})
    public void setWriteFiles(ConfigurationValue cv, boolean b) {
        this.writeFiles = b;
    }

    public boolean getListFiles() {
        return this.listFiles;
    }

    @Config
    @Mapping(value={"list-files"})
    public void setListFiles(ConfigurationValue cv, boolean b) {
        this.listFiles = b;
    }

    public boolean getInsertSpaces() {
        return this.insertSpaces;
    }

    @Config
    @Mapping(value={"insert-spaces"})
    public void setInsertSpaces(ConfigurationValue cv, boolean b) {
        this.insertSpaces = b;
    }

    public boolean getInsertFinalNewLine() {
        return this.insertFinalNewLine;
    }

    @Config
    @Mapping(value={"insert-final-new-line"})
    public void setInsertFinalNewLine(ConfigurationValue cv, boolean b) {
        this.insertFinalNewLine = b;
    }

    public boolean getPlaceOpenBraceOnNewLine() {
        return this.placeOpenBraceOnNewLine;
    }

    @Config
    @Mapping(value={"open-brace-new-line"})
    public void setPlaceOpenBraceOnNewLine(ConfigurationValue cv, boolean b) {
        this.placeOpenBraceOnNewLine = b;
    }

    public boolean getInsertSpaceAfterSemicolonInForStatements() {
        return this.insertSpaceAfterSemicolonInForStatements;
    }

    @Config
    @Mapping(value={"insert-space-for-loop-semicolon"})
    public void setInsertSpaceAfterSemicolonInForStatements(ConfigurationValue cv, boolean b) {
        this.insertSpaceAfterSemicolonInForStatements = b;
    }

    public boolean getInsertSpaceAfterKeywordsInControlFlowStatements() {
        return this.insertSpaceAfterKeywordsInControlFlowStatements;
    }

    @Config
    @Mapping(value={"insert-space-control-flow-keywords"})
    public void setInsertSpaceAfterKeywordsInControlFlowStatements(ConfigurationValue cv, boolean b) {
        this.insertSpaceAfterKeywordsInControlFlowStatements = b;
    }

    public boolean getInsertSpaceAfterFunctionKeywordForAnonymousFunctions() {
        return this.insertSpaceAfterFunctionKeywordForAnonymousFunctions;
    }

    @Config
    @Mapping(value={"insert-space-anonymous-function-keyword"})
    public void setInsertSpaceAfterFunctionKeywordForAnonymousFunctions(ConfigurationValue cv, boolean b) {
        this.insertSpaceAfterFunctionKeywordForAnonymousFunctions = b;
    }

    public boolean getInsertSpaceBeforeAndAfterBinaryOperators() {
        return this.insertSpaceBeforeAndAfterBinaryOperators;
    }

    @Config
    @Mapping(value={"insert-space-binary-operators"})
    public void setInsertSpaceBeforeAndAfterBinaryOperators(ConfigurationValue cv, boolean b) {
        this.insertSpaceBeforeAndAfterBinaryOperators = b;
    }

    public boolean getInsertSpaceAfterCommaDelimiter() {
        return this.insertSpaceAfterCommaDelimiter;
    }

    @Config
    @Mapping(value={"insert-space-comma-delimiter"})
    public void setInsertSpaceAfterCommaDelimiter(ConfigurationValue cv, boolean b) {
        this.insertSpaceAfterCommaDelimiter = b;
    }

    public boolean getInsertSpaceBetweenMetadataAttributes() {
        return this.insertSpaceBetweenMetadataAttributes;
    }

    @Config
    @Mapping(value={"insert-space-meta-attributes"})
    public void setInsertSpaceBetweenMetadataAttributes(ConfigurationValue cv, boolean b) {
        this.insertSpaceBetweenMetadataAttributes = b;
    }

    public boolean getInsertSpaceAtStartOfLineComment() {
        return this.insertSpaceAtStartOfLineComment;
    }

    @Config
    @Mapping(value={"insert-space-line-comment"})
    public void setInsertSpaceAtStartOfLineComment(ConfigurationValue cv, boolean b) {
        this.insertSpaceAtStartOfLineComment = b;
    }

    public boolean getCollapseEmptyBlocks() {
        return this.collapseEmptyBlocks;
    }

    @Config
    @Mapping(value={"collapse-empty-blocks"})
    public void setCollapseEmptyBlocks(ConfigurationValue cv, boolean b) {
        this.collapseEmptyBlocks = b;
    }

    public int getTabSize() {
        return this.tabSize;
    }

    @Config
    @Mapping(value={"tab-size"})
    public void setTabSize(ConfigurationValue cv, int b) {
        this.tabSize = b;
    }

    public int getMaxPreserveNewLines() {
        return this.maxPreserveNewLines;
    }

    @Config
    @Mapping(value={"max-preserve-new-lines"})
    public void setMaxPreserveNewLines(ConfigurationValue cv, int b) {
        this.maxPreserveNewLines = b;
    }

    public String getSemicolons() {
        return this.semicolons.value;
    }

    @Config
    @Mapping(value={"semicolons"})
    public void setSemicolons(ConfigurationValue cv, String b) {
        this.semicolons = Semicolons.valueOf(b.toUpperCase());
    }

    public boolean getIgnoreParsingProblems() {
        return this.ignoreParsingProblems;
    }

    @Config(advanced=true)
    @Mapping(value={"ignore-parsing-problems"})
    public void setIgnoreParsingProblems(ConfigurationValue cv, boolean b) {
        this.ignoreParsingProblems = b;
    }

    public boolean getMxmlAlignAttributes() {
        return this.mxmlAlignAttributes;
    }

    @Config(advanced=true)
    @Mapping(value={"mxml-align-attributes"})
    public void setMxmlAlignAttributes(ConfigurationValue cv, boolean b) {
        this.mxmlAlignAttributes = b;
    }

    public boolean getMxmlInsertNewLineBetweenAttributes() {
        return this.mxmlInsertNewLineBetweenAttributes;
    }

    @Config(advanced=true)
    @Mapping(value={"mxml-insert-new-line-attributes"})
    public void setMxmlInsertNewLineBetweenAttributes(ConfigurationValue cv, boolean b) {
        this.mxmlInsertNewLineBetweenAttributes = b;
    }
}

