/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.assertion.sink;

import com.google.auto.service.AutoService;
import java.io.Serializable;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.flink.api.common.functions.MapFunction;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.types.Row;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.flink.BaseFlinkSink;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.assertion.AssertExecutor;
import org.apache.seatunnel.flink.assertion.rule.AssertFieldRule;
import org.apache.seatunnel.flink.assertion.rule.AssertRuleParser;
import org.apache.seatunnel.flink.batch.FlinkBatchSink;
import org.apache.seatunnel.flink.stream.FlinkStreamSink;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={BaseFlinkSink.class})
public class AssertSink
implements FlinkBatchSink,
FlinkStreamSink {
    private static final AssertExecutor ASSERT_EXECUTOR = new AssertExecutor();
    private List<AssertFieldRule> assertFieldRules;
    private static final String RULES = "rules";
    private Config config;
    private List<? extends Config> configList;

    public void outputBatch(FlinkEnvironment env, DataSet<Row> inDataSet) {
        try {
            inDataSet.collect().forEach(row -> ASSERT_EXECUTOR.fail((Row)row, this.assertFieldRules).ifPresent(failRule -> {
                throw new IllegalStateException("row :" + row + " fail rule: " + failRule);
            }));
        }
        catch (Exception ex) {
            throw new RuntimeException("AssertSink execute failed", ex);
        }
    }

    public void outputStream(FlinkEnvironment env, DataStream<Row> dataStream) {
        dataStream.map((MapFunction & Serializable)row -> {
            ASSERT_EXECUTOR.fail((Row)row, this.assertFieldRules).ifPresent(failRule -> {
                throw new IllegalStateException("row :" + row + "field name of the fail rule: " + failRule.getFieldName());
            });
            return null;
        });
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public Config getConfig() {
        return this.config;
    }

    public CheckResult checkConfig() {
        if (this.config.hasPath(RULES)) {
            this.configList = this.config.getConfigList(RULES);
            if (CollectionUtils.isNotEmpty(this.configList)) {
                return CheckResult.success();
            }
        }
        return CheckResult.error((String)"There is no assert-rule defined in AssertSink plugin");
    }

    public void prepare(FlinkEnvironment env) {
        AssertRuleParser assertRuleParser = new AssertRuleParser();
        this.assertFieldRules = assertRuleParser.parseRules(this.configList);
    }

    public void close() {
    }

    public String getPluginName() {
        return "AssertSink";
    }
}

