/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.mr;

import java.util.Map;
import org.apache.hadoop.io.AbstractMapWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.MD5Hash;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.elasticsearch.hadoop.mr.WritableCompatUtil;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.serialization.builder.FilteringValueWriter;
import org.elasticsearch.hadoop.serialization.builder.ValueWriter;

public class WritableValueWriter
extends FilteringValueWriter<Writable> {
    private final boolean writeUnknownTypes;

    public WritableValueWriter() {
        this.writeUnknownTypes = false;
    }

    public WritableValueWriter(boolean writeUnknownTypes) {
        this.writeUnknownTypes = writeUnknownTypes;
    }

    @Override
    public ValueWriter.Result write(Writable writable, Generator generator) {
        if (writable == null || writable instanceof NullWritable) {
            generator.writeNull();
        } else if (writable instanceof Text) {
            Text text = (Text)writable;
            generator.writeUTF8String(text.getBytes(), 0, text.getLength());
        } else if (writable instanceof UTF8) {
            UTF8 utf8 = (UTF8)writable;
            generator.writeUTF8String(utf8.getBytes(), 0, utf8.getLength());
        } else if (WritableCompatUtil.isShortWritable(writable)) {
            generator.writeNumber(WritableCompatUtil.unwrap(writable));
        } else if (writable instanceof IntWritable) {
            generator.writeNumber(((IntWritable)writable).get());
        } else if (writable instanceof LongWritable) {
            generator.writeNumber(((LongWritable)writable).get());
        } else if (writable instanceof VLongWritable) {
            generator.writeNumber(((VLongWritable)writable).get());
        } else if (writable instanceof VIntWritable) {
            generator.writeNumber(((VIntWritable)writable).get());
        } else if (writable instanceof ByteWritable) {
            generator.writeNumber(((ByteWritable)writable).get());
        } else if (writable instanceof DoubleWritable) {
            generator.writeNumber(((DoubleWritable)writable).get());
        } else if (writable instanceof FloatWritable) {
            generator.writeNumber(((FloatWritable)writable).get());
        } else if (writable instanceof BooleanWritable) {
            generator.writeBoolean(((BooleanWritable)writable).get());
        } else if (writable instanceof BytesWritable) {
            BytesWritable bw = (BytesWritable)writable;
            generator.writeBinary(bw.getBytes(), 0, bw.getLength());
        } else if (writable instanceof MD5Hash) {
            generator.writeString(writable.toString());
        } else if (writable instanceof ArrayWritable) {
            generator.writeBeginArray();
            for (Writable wrt : ((ArrayWritable)writable).get()) {
                ValueWriter.Result result2 = this.write(wrt, generator);
                if (result2.isSuccesful()) continue;
                return result2;
            }
            generator.writeEndArray();
        } else if (writable instanceof AbstractMapWritable) {
            Map map2 = (Map)writable;
            generator.writeBeginObject();
            for (Map.Entry entry : map2.entrySet()) {
                String fieldName = ((Writable)entry.getKey()).toString();
                if (!this.shouldKeep(generator.getParentPath(), fieldName)) continue;
                generator.writeFieldName(fieldName);
                ValueWriter.Result result3 = this.write((Writable)entry.getValue(), generator);
                if (result3.isSuccesful()) continue;
                return result3;
            }
            generator.writeEndObject();
        } else {
            if (this.writeUnknownTypes) {
                return this.handleUnknown(writable, generator);
            }
            return ValueWriter.Result.FAILED(writable);
        }
        return ValueWriter.Result.SUCCESFUL();
    }

    protected ValueWriter.Result handleUnknown(Writable value, Generator generator) {
        generator.writeBinary(WritableUtils.toByteArray((Writable[])new Writable[]{value}));
        return ValueWriter.Result.SUCCESFUL();
    }
}

