/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.elasticsearch.hadoop.EsHadoopException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.handler.EsHadoopAbortHandlerException;
import org.elasticsearch.hadoop.handler.HandlerResult;
import org.elasticsearch.hadoop.serialization.EsHadoopSerializationException;
import org.elasticsearch.hadoop.serialization.bulk.BulkCommand;
import org.elasticsearch.hadoop.serialization.handler.SerdeErrorCollector;
import org.elasticsearch.hadoop.serialization.handler.write.ISerializationErrorHandler;
import org.elasticsearch.hadoop.serialization.handler.write.SerializationFailure;
import org.elasticsearch.hadoop.serialization.handler.write.impl.SerializationHandlerLoader;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.BytesRef;

public class BulkEntryWriter {
    private static final Log LOG = LogFactory.getLog(BulkEntryWriter.class);
    private final BulkCommand bulkCommand;
    private final List<ISerializationErrorHandler> serializationErrorHandlers;

    public BulkEntryWriter(Settings settings, BulkCommand bulkCommand) {
        this.bulkCommand = bulkCommand;
        SerializationHandlerLoader loader = new SerializationHandlerLoader();
        loader.setSettings(settings);
        this.serializationErrorHandlers = loader.loadHandlers();
    }

    public BytesRef writeBulkEntry(Object object) {
        Object toRead = object;
        BytesRef writeResult = null;
        boolean retryWrite = false;
        boolean skip = false;
        int attempts = 0;
        do {
            try {
                retryWrite = false;
                writeResult = this.bulkCommand.write(toRead);
            }
            catch (Exception serializationException) {
                ArrayList<String> passReasons = new ArrayList<String>();
                SerializationFailure entry = new SerializationFailure(serializationException, object, passReasons);
                SerdeErrorCollector errorCollector = new SerdeErrorCollector();
                Exception abortException = serializationException;
                block11: for (ISerializationErrorHandler serializationErrorHandler : this.serializationErrorHandlers) {
                    HandlerResult result2;
                    try {
                        result2 = serializationErrorHandler.onError(entry, errorCollector);
                    }
                    catch (EsHadoopAbortHandlerException ahe) {
                        result2 = HandlerResult.ABORT;
                        abortException = new EsHadoopSerializationException(ahe.getMessage(), ahe.getCause());
                    }
                    catch (Exception e) {
                        LOG.error((Object)"Could not handle serialization error event due to an exception in error handler. Serialization exception:", (Throwable)serializationException);
                        throw new EsHadoopException("Encountered unexpected exception during error handler execution.", e);
                    }
                    switch (result2) {
                        case HANDLED: {
                            Assert.isTrue(errorCollector.getAndClearMessage() == null, "Found pass message with Handled response. Be sure to return the value returned from the pass(String) call.");
                            if (errorCollector.receivedRetries()) {
                                Object retryObject = errorCollector.getAndClearRetryValue();
                                if (retryObject != null) {
                                    toRead = retryObject;
                                }
                                if (attempts >= 50) {
                                    throw new EsHadoopException("Maximum retry attempts (50) reached for serialization errors.");
                                }
                                retryWrite = true;
                                ++attempts;
                                break block11;
                            }
                            if (LOG.isDebugEnabled()) {
                                LOG.debug((Object)("Skipping a record that resulted in error while reading: [" + object.toString() + "]"));
                            } else {
                                LOG.info((Object)"Skipping a record that resulted in error while reading. (DEBUG for more info).");
                            }
                            skip = true;
                            break block11;
                        }
                        case PASS: {
                            String reason = errorCollector.getAndClearMessage();
                            if (reason == null) continue block11;
                            passReasons.add(reason);
                            continue block11;
                        }
                        case ABORT: {
                            errorCollector.getAndClearMessage();
                            if (abortException instanceof EsHadoopSerializationException) {
                                throw (EsHadoopSerializationException)abortException;
                            }
                            throw new EsHadoopSerializationException(abortException);
                        }
                        default: {
                            continue block11;
                        }
                    }
                }
            }
        } while (retryWrite);
        if (writeResult == null && !skip) {
            throw new EsHadoopSerializationException("Could not write record to bulk request.");
        }
        return writeResult;
    }

    public void close() {
        for (ISerializationErrorHandler errorHandler : this.serializationErrorHandlers) {
            errorHandler.close();
        }
    }
}

