/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.bulk;

import java.util.EnumMap;
import org.elasticsearch.hadoop.EsHadoopUnsupportedOperationException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.bulk.MetadataExtractor;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.util.EsMajorVersion;

public abstract class PerEntityPoolingMetadataExtractor
implements MetadataExtractor,
SettingsAware {
    protected EsMajorVersion version;
    protected Object entity;
    protected Settings settings;
    private final EnumMap<MetadataExtractor.Metadata, FieldExtractor> pool = new EnumMap(MetadataExtractor.Metadata.class);

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
        this.version = settings.getInternalVersionOrThrow();
    }

    public void reset() {
        this.entity = null;
    }

    @Override
    public FieldExtractor get(MetadataExtractor.Metadata metadata) {
        FieldExtractor fieldExtractor = this.pool.get((Object)metadata);
        if (fieldExtractor == null || fieldExtractor instanceof StaticFieldExtractor && ((StaticFieldExtractor)fieldExtractor).needsInit()) {
            Object value = this.getValue(metadata);
            if (value == null) {
                return null;
            }
            if (fieldExtractor == null) {
                fieldExtractor = this._createExtractorFor(metadata);
            }
            if (fieldExtractor instanceof StaticFieldExtractor && ((StaticFieldExtractor)fieldExtractor).needsInit()) {
                ((StaticFieldExtractor)fieldExtractor).setField(value);
            }
            this.pool.put(metadata, fieldExtractor);
        }
        return fieldExtractor;
    }

    private FieldExtractor _createExtractorFor(MetadataExtractor.Metadata metadata) {
        if (this.version.onOrAfter(EsMajorVersion.V_6_X)) {
            switch (metadata) {
                case TTL: 
                case TIMESTAMP: {
                    return new UnsupportedMetadataFieldExtractor(metadata, this.version);
                }
            }
        }
        return this.createExtractorFor(metadata);
    }

    protected FieldExtractor createExtractorFor(MetadataExtractor.Metadata metadata) {
        return new StaticFieldExtractor();
    }

    public abstract Object getValue(MetadataExtractor.Metadata var1);

    @Override
    public void setObject(Object entity) {
        this.entity = entity;
    }

    private static class UnsupportedMetadataFieldExtractor
    extends StaticFieldExtractor {
        private MetadataExtractor.Metadata unsupportedMetadata;
        private EsMajorVersion version;

        public UnsupportedMetadataFieldExtractor(MetadataExtractor.Metadata unsupportedMetadata, EsMajorVersion version) {
            this.unsupportedMetadata = unsupportedMetadata;
            this.version = version;
        }

        @Override
        public Object field(Object target) {
            throw new EsHadoopUnsupportedOperationException("Unsupported metadata tag [" + this.unsupportedMetadata.getName() + "] for Elasticsearch version [" + this.version.toString() + "]. Bailing out...");
        }
    }

    public static class StaticFieldExtractor
    implements FieldExtractor {
        private Object field;
        private boolean needsInit = true;

        @Override
        public Object field(Object target) {
            return this.field;
        }

        protected Object field() {
            return this.field;
        }

        public void setField(Object field2) {
            this.field = field2;
            this.needsInit = true;
        }

        public boolean needsInit() {
            return this.needsInit;
        }
    }
}

