/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto;

import java.io.Serializable;
import java.util.Map;

public class ShardInfo
implements Comparable<ShardInfo>,
Serializable {
    private final State state;
    private final boolean primary;
    private final String node;
    private final String relocatingNode;
    private final Integer id;
    private final String index;

    public ShardInfo(Map<String, Object> data) {
        this.state = State.valueOf((String)data.get("state"));
        this.id = (Integer)data.get("shard");
        this.index = (String)data.get("index");
        this.relocatingNode = (String)data.get("relocating_node");
        this.node = (String)data.get("node");
        this.primary = Boolean.TRUE.equals(data.get("primary"));
    }

    public int hashCode() {
        int prime = 31;
        int result2 = 1;
        result2 = 31 * result2 + (this.index == null ? 0 : this.index.hashCode());
        result2 = 31 * result2 + (this.id == null ? 0 : this.id.hashCode());
        result2 = 31 * result2 + (this.node == null ? 0 : this.node.hashCode());
        return result2;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ShardInfo other = (ShardInfo)obj;
        if (this.index == null ? other.index != null : !this.index.equals(other.index)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        return !(this.node == null ? other.node != null : !this.node.equals(other.node));
    }

    public State getState() {
        return this.state;
    }

    public boolean isPrimary() {
        return this.primary;
    }

    public String getNode() {
        return this.node;
    }

    public String getRelocatingNode() {
        return this.relocatingNode;
    }

    public Integer getName() {
        return this.id;
    }

    public String getIndex() {
        return this.index;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Shard[state=").append((Object)this.state).append(", primary=").append(this.primary).append(", node=").append(this.node).append(", name=").append(this.id).append(", index=").append(this.index).append("]");
        return builder.toString();
    }

    @Override
    public int compareTo(ShardInfo o) {
        return this.id - o.id;
    }

    public static enum State {
        UNASSIGNED,
        INITIALIZING,
        STARTED,
        RELOCATING;


        public boolean isStarted() {
            return STARTED == this;
        }
    }
}

