/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.field.FieldFilter;

public class Mapping
implements Serializable {
    private final String name;
    private final Field[] fields;

    public Mapping(String name, Collection<Field> fields) {
        this(name, fields != null ? fields.toArray(new Field[fields.size()]) : Field.NO_FIELDS);
    }

    Mapping(String name, Field[] fields) {
        this.name = name;
        this.fields = fields;
    }

    public String getName() {
        return this.name;
    }

    public Field[] getFields() {
        return this.fields;
    }

    public Mapping filter(Collection<String> includes, Collection<String> excludes) {
        if (includes.isEmpty() && excludes.isEmpty()) {
            return this;
        }
        ArrayList<Field> filtered2 = new ArrayList<Field>();
        List<FieldFilter.NumberedInclude> convertedIncludes = FieldFilter.toNumberedFilter(includes);
        boolean intact = true;
        for (Field fl : this.getFields()) {
            intact &= Mapping.filterField(fl, null, filtered2, convertedIncludes, excludes);
        }
        return intact ? this : new Mapping(this.getName(), filtered2);
    }

    private static boolean filterField(Field field2, String parentName, List<Field> filtered2, Collection<FieldFilter.NumberedInclude> includes, Collection<String> excludes) {
        String fieldName = parentName != null ? parentName + "." + field2.name() : field2.name();
        boolean intact = true;
        if (FieldFilter.filter((String)fieldName, includes, excludes).matched) {
            if (FieldType.isCompound(field2.type())) {
                ArrayList<Field> nested = new ArrayList<Field>();
                for (Field nestedField : field2.properties()) {
                    intact &= Mapping.filterField(nestedField, fieldName, nested, includes, excludes);
                }
                filtered2.add(new Field(field2.name(), field2.type(), nested));
            } else {
                filtered2.add(field2);
            }
        } else {
            intact = false;
        }
        return intact;
    }

    public Map<String, FieldType> flatten() {
        if (this.fields == null || this.fields.length == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, FieldType> map2 = new LinkedHashMap<String, FieldType>();
        for (Field nestedField : this.fields) {
            Mapping.addSubFieldToMap(map2, nestedField, null);
        }
        return map2;
    }

    private static void addSubFieldToMap(Map<String, FieldType> fields, Field field2, String parentName) {
        String fieldName = parentName != null ? parentName + "." + field2.name() : field2.name();
        fields.put(fieldName, field2.type());
        if (FieldType.isCompound(field2.type())) {
            for (Field nestedField : field2.properties()) {
                Mapping.addSubFieldToMap(fields, nestedField, fieldName);
            }
        }
    }

    public String toString() {
        return String.format("%s=%s", this.name, Arrays.toString(this.fields));
    }
}

