/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.dto.mapping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.serialization.FieldType;
import org.elasticsearch.hadoop.serialization.dto.mapping.Field;
import org.elasticsearch.hadoop.serialization.dto.mapping.Mapping;

public class MappingSet
implements Serializable {
    private static final String RESOLVED_MAPPING_NAME = "*";
    private final boolean empty;
    private final Map<String, Map<String, Mapping>> indexTypeMap = new HashMap<String, Map<String, Mapping>>();
    private final Mapping resolvedSchema;

    public MappingSet(List<Field> fields) {
        if (fields.isEmpty()) {
            this.empty = true;
            this.resolvedSchema = new Mapping(RESOLVED_MAPPING_NAME, Field.NO_FIELDS);
        } else {
            this.empty = false;
            for (Field field2 : fields) {
                String indexName = field2.name();
                Field[] mappings = field2.properties();
                HashMap<String, Mapping> mappingsToSchema = new HashMap<String, Mapping>();
                this.indexTypeMap.put(indexName, mappingsToSchema);
                for (Field mappingHeader : mappings) {
                    for (Field mapping : mappingHeader.properties()) {
                        mappingsToSchema.put(mapping.name(), new Mapping(mapping.name(), mapping.properties()));
                    }
                }
            }
            this.resolvedSchema = MappingSet.mergeMappings(fields);
        }
    }

    private static Mapping mergeMappings(List<Field> fields) {
        LinkedHashMap<String, Object[]> fieldMap = new LinkedHashMap<String, Object[]>();
        for (Field rootField : fields) {
            Field[] mappings;
            Field[] props = rootField.properties();
            if (props.length <= 0 || props[0] == null || !"mappings".equals(props[0].name()) || !FieldType.OBJECT.equals((Object)props[0].type())) continue;
            for (Field mapping : mappings = props[0].properties()) {
                for (Field field2 : mapping.properties()) {
                    MappingSet.addToFieldTable(field2, "", fieldMap);
                }
            }
        }
        Field[] collapsed = MappingSet.collapseFields(fieldMap);
        return new Mapping(RESOLVED_MAPPING_NAME, collapsed);
    }

    private static void addToFieldTable(Field field2, String parent, Map<String, Object[]> fieldTable) {
        String fullName = parent + field2.name();
        Object[] entry = fieldTable.get(fullName);
        if (entry == null) {
            if (FieldType.isCompound(field2.type())) {
                LinkedHashMap<String, Object[]> subTable = new LinkedHashMap<String, Object[]>();
                entry = new Object[]{field2, subTable};
                String prefix = fullName + ".";
                for (Field subField : field2.properties()) {
                    MappingSet.addToFieldTable(subField, prefix, subTable);
                }
            } else {
                entry = new Object[]{field2};
            }
            fieldTable.put(fullName, entry);
        } else {
            Field previousField = (Field)entry[0];
            if (!previousField.type().equals((Object)field2.type())) {
                FieldType resolvedType = MappingSet.resolveTypeConflict(fullName, previousField.type(), field2.type());
                if (!previousField.type().equals((Object)resolvedType)) {
                    previousField = new Field(previousField.name(), resolvedType, previousField.properties());
                    entry[0] = previousField;
                }
            }
            if (FieldType.isCompound(field2.type())) {
                Map subTable = (Map)entry[1];
                String prefix = fullName + ".";
                for (Field subField : field2.properties()) {
                    MappingSet.addToFieldTable(subField, prefix, subTable);
                }
            }
        }
    }

    private static FieldType resolveTypeConflict(String fullName, FieldType existing, FieldType incoming) {
        LinkedHashSet<FieldType> incomingSuperTypes = incoming.getCastingTypes();
        if (incomingSuperTypes.contains((Object)existing)) {
            return existing;
        }
        LinkedHashSet<FieldType> existingSuperTypes = existing.getCastingTypes();
        if (existingSuperTypes.contains((Object)incoming)) {
            return incoming;
        }
        if (incomingSuperTypes.size() > 0 && existingSuperTypes.size() > 0) {
            LinkedHashSet<FieldType> combined = new LinkedHashSet<FieldType>(incomingSuperTypes);
            combined.retainAll(existingSuperTypes);
            if (combined.size() > 0) {
                return (FieldType)((Object)combined.iterator().next());
            }
        }
        throw new EsHadoopIllegalArgumentException("Incompatible types found in multi-mapping: Field [" + fullName + "] has conflicting types of [" + (Object)((Object)existing) + "] and [" + (Object)((Object)incoming) + "].");
    }

    private static Field[] collapseFields(Map<String, Object[]> fieldTable) {
        ArrayList<Field> fields = new ArrayList<Field>();
        for (Map.Entry<String, Object[]> fieldInfo : fieldTable.entrySet()) {
            Field currentField = (Field)fieldInfo.getValue()[0];
            if (FieldType.isCompound(currentField.type())) {
                Map subTable = (Map)fieldInfo.getValue()[1];
                Field[] children = MappingSet.collapseFields(subTable);
                fields.add(new Field(currentField.name(), currentField.type(), children));
                continue;
            }
            fields.add(currentField);
        }
        return fields.size() == 0 ? Field.NO_FIELDS : fields.toArray(new Field[fields.size()]);
    }

    public Mapping getMapping(String index, String type) {
        Mapping mapping = null;
        Map<String, Mapping> mappings = this.indexTypeMap.get(index);
        if (mappings != null) {
            mapping = mappings.get(type);
        }
        return mapping;
    }

    public boolean isEmpty() {
        return this.empty;
    }

    public Mapping getResolvedView() {
        return this.resolvedSchema;
    }

    public String toString() {
        return "MappingSet{indexTypeMap=" + this.indexTypeMap + ", resolvedSchema=" + this.resolvedSchema + '}';
    }
}

