/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.field;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.serialization.SettingsAware;
import org.elasticsearch.hadoop.serialization.bulk.RawJson;
import org.elasticsearch.hadoop.serialization.field.FieldExtractor;
import org.elasticsearch.hadoop.serialization.field.IndexExtractor;
import org.elasticsearch.hadoop.serialization.field.IndexFormatter;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.hadoop.util.ObjectUtils;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class AbstractIndexExtractor
implements IndexExtractor,
SettingsAware {
    private static final String FORMAT_SEPARATOR = "|";
    protected Settings settings;
    protected String pattern;
    protected boolean hasPattern = false;
    protected List<Object> index;
    protected List<Object> type;

    @Override
    public void setSettings(Settings settings) {
        this.settings = settings;
    }

    @Override
    public void compile(String pattern) {
        this.pattern = pattern;
        Object[] split2 = pattern.split("/");
        Assert.isTrue(!ObjectUtils.isEmpty(split2), "invalid pattern given " + pattern);
        Assert.isTrue(split2.length == 2, "invalid pattern given " + pattern);
        this.hasPattern = pattern.contains("{") && pattern.contains("}");
        this.index = this.parse(((String)split2[0]).trim());
        this.type = this.parse(((String)split2[1]).trim());
    }

    protected List<Object> parse(String string2) {
        ArrayList<Object> template = new ArrayList<Object>();
        while (string2.contains("{")) {
            int startPattern = string2.indexOf("{");
            template.add(string2.substring(0, startPattern));
            int endPattern = string2.indexOf("}");
            Assert.isTrue(endPattern > startPattern + 1, "Invalid pattern given " + string2);
            String nestedString = string2.substring(startPattern + 1, endPattern);
            int separator = nestedString.indexOf(FORMAT_SEPARATOR);
            if (separator > 0) {
                Assert.isTrue(nestedString.length() > separator + 1, "Invalid format given " + nestedString);
                String format2 = nestedString.substring(separator + 1);
                nestedString = nestedString.substring(0, separator);
                template.add(this.wrapWithFormatter(format2, this.createFieldExtractor(nestedString)));
            } else {
                template.add(this.createFieldExtractor(nestedString));
            }
            string2 = string2.substring(endPattern + 1).trim();
        }
        if (StringUtils.hasText(string2)) {
            template.add(string2);
        }
        return template;
    }

    private Object wrapWithFormatter(String format2, final FieldExtractor createFieldExtractor) {
        final IndexFormatter iformatter = (IndexFormatter)ObjectUtils.instantiate(this.settings.getMappingIndexFormatterClassName(), this.settings);
        iformatter.configure(format2);
        return new FieldExtractor(){

            @Override
            public Object field(Object target) {
                String string2 = createFieldExtractor.field(target).toString();
                if (string2.startsWith("\"")) {
                    string2 = string2.substring(1);
                }
                if (string2.endsWith("\"")) {
                    string2 = string2.substring(0, string2.length() - 1);
                }
                return iformatter.format(string2);
            }
        };
    }

    private void append(StringBuilder sb, List<Object> list, Object target) {
        for (Object object : list) {
            if (object instanceof FieldExtractor) {
                Object field2 = ((FieldExtractor)object).field(target);
                if (field2 == null) {
                    throw new EsHadoopIllegalArgumentException(String.format("Found null value for pattern element in %s", this.pattern));
                }
                if (field2 == NOT_FOUND) {
                    throw new EsHadoopIllegalArgumentException(String.format("Cannot find match for %s", this.pattern));
                }
                sb.append(StringUtils.jsonEncoding(field2.toString()));
                continue;
            }
            sb.append(StringUtils.jsonEncoding(object.toString()));
        }
    }

    @Override
    public Object field(Object target) {
        StringBuilder sb = new StringBuilder();
        sb.append("\"_index\":\"");
        this.append(sb, this.index, target);
        sb.append("\",");
        sb.append("\"_type\":\"");
        this.append(sb, this.type, target);
        sb.append("\"");
        return new RawJson(sb.toString());
    }

    @Override
    public boolean hasPattern() {
        return this.hasPattern;
    }

    protected abstract FieldExtractor createFieldExtractor(String var1);
}

