/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.serialization.json;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.util.Deque;
import java.util.LinkedList;
import org.apache.commons.logging.LogFactory;
import org.codehaus.jackson.JsonEncoding;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.elasticsearch.hadoop.serialization.EsHadoopSerializationException;
import org.elasticsearch.hadoop.serialization.Generator;
import org.elasticsearch.hadoop.util.StringUtils;

public class JacksonJsonGenerator
implements Generator {
    private static final boolean HAS_UTF_8;
    private static final JsonFactory JSON_FACTORY;
    private final JsonGenerator generator;
    private final OutputStream out;
    private Deque<String> currentPath = new LinkedList<String>();
    private String currentPathCached;
    private String currentName;

    public JacksonJsonGenerator(OutputStream out) {
        try {
            this.out = out;
            this.generator = JSON_FACTORY.createJsonGenerator(out, JsonEncoding.UTF8);
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    public void usePrettyPrint() {
        this.generator.useDefaultPrettyPrinter();
    }

    @Override
    public Generator writeBeginArray() {
        try {
            this.generator.writeStartArray();
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeEndArray() {
        try {
            this.generator.writeEndArray();
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeBeginObject() {
        try {
            this.generator.writeStartObject();
            if (this.currentName != null) {
                this.currentPath.addLast(this.currentName);
                this.currentName = null;
                this.currentPathCached = null;
            }
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeEndObject() {
        try {
            this.generator.writeEndObject();
            this.currentName = this.currentPath.pollLast();
            this.currentPathCached = null;
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeFieldName(String name) {
        try {
            this.generator.writeFieldName(name);
            this.currentName = name;
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeString(String text) {
        try {
            this.generator.writeString(text);
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeUTF8String(byte[] text, int offset, int len) {
        try {
            if (HAS_UTF_8) {
                this.generator.writeUTF8String(text, offset, len);
            } else {
                this.generator.writeString(new String(text, offset, len, StringUtils.UTF_8));
            }
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeUTF8String(byte[] text) {
        return this.writeUTF8String(text, 0, text.length);
    }

    @Override
    public Generator writeBinary(byte[] data, int offset, int len) {
        try {
            this.generator.writeBinary(data, offset, len);
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeBinary(byte[] data) {
        return this.writeBinary(data, 0, data.length);
    }

    @Override
    public Generator writeNumber(short s2) {
        return this.writeNumber((int)s2);
    }

    @Override
    public Generator writeNumber(byte b) {
        return this.writeNumber((int)b);
    }

    @Override
    public Generator writeNumber(int i) {
        try {
            this.generator.writeNumber(i);
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeNumber(long l) {
        try {
            this.generator.writeNumber(l);
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeNumber(double d) {
        try {
            this.generator.writeNumber(d);
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeNumber(float f) {
        try {
            this.generator.writeNumber(f);
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeBoolean(boolean b) {
        try {
            this.generator.writeBoolean(b);
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeNull() {
        try {
            this.generator.writeNull();
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Generator writeRaw(String value) {
        try {
            this.generator.writeRaw(value);
            return this;
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public void flush() {
        try {
            this.generator.flush();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public void close() {
        try {
            this.generator.close();
        }
        catch (IOException ex) {
            throw new EsHadoopSerializationException(ex);
        }
    }

    @Override
    public Object getOutputTarget() {
        return this.out;
    }

    @Override
    public String getParentPath() {
        if (this.currentPathCached == null) {
            if (this.currentPath.isEmpty()) {
                this.currentPathCached = "";
            } else {
                StringBuilder sb = new StringBuilder();
                for (String level : this.currentPath) {
                    sb.append(level);
                    sb.append(".");
                }
                sb.setLength(sb.length() - 1);
                this.currentPathCached = sb.toString();
            }
        }
        return this.currentPathCached;
    }

    static {
        boolean hasMethod = false;
        try {
            Method m = JsonGenerator.class.getMethod("writeUTF8String", byte[].class, Integer.TYPE, Integer.TYPE);
            hasMethod = true;
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        HAS_UTF_8 = hasMethod;
        if (!HAS_UTF_8) {
            LogFactory.getLog(JacksonJsonGenerator.class).warn((Object)"Old Jackson version (pre-1.7) detected; consider upgrading to improve performance");
        }
        JSON_FACTORY = new JsonFactory();
        JSON_FACTORY.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, true);
    }
}

