/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.Serializable;
import org.elasticsearch.hadoop.util.ClusterName;
import org.elasticsearch.hadoop.util.EsMajorVersion;

public class ClusterInfo
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final ClusterName clusterName;
    private final EsMajorVersion majorVersion;

    public static ClusterInfo unnamedLatest() {
        return new ClusterInfo(new ClusterName("!UNNAMED!", null), EsMajorVersion.LATEST);
    }

    public static ClusterInfo unnamedClusterWithVersion(EsMajorVersion version) {
        return new ClusterInfo(new ClusterName("!UNNAMED!", null), version);
    }

    public ClusterInfo(ClusterName clusterName, EsMajorVersion majorVersion) {
        this.clusterName = clusterName;
        this.majorVersion = majorVersion;
    }

    public ClusterName getClusterName() {
        return this.clusterName;
    }

    public EsMajorVersion getMajorVersion() {
        return this.majorVersion;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ClusterInfo that = (ClusterInfo)o;
        if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) {
            return false;
        }
        return this.majorVersion != null ? this.majorVersion.equals(that.majorVersion) : that.majorVersion == null;
    }

    public int hashCode() {
        int result2 = this.clusterName != null ? this.clusterName.hashCode() : 0;
        result2 = 31 * result2 + (this.majorVersion != null ? this.majorVersion.hashCode() : 0);
        return result2;
    }

    public String toString() {
        return "ClusterInfo{clusterName=" + this.clusterName + ", majorVersion=" + this.majorVersion + '}';
    }
}

