/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.io.InputStream;
import org.elasticsearch.hadoop.util.BytesArray;

public class FastByteArrayInputStream
extends InputStream {
    protected BytesArray data;
    protected int offset;
    protected int pos;
    protected int mark = 0;
    protected int count;

    public FastByteArrayInputStream(byte[] data) {
        this(new BytesArray(data));
    }

    public FastByteArrayInputStream(BytesArray data) {
        this.data = data;
        this.pos = data.offset;
        this.offset = data.offset;
        this.count = data.offset + data.size;
    }

    @Override
    public int read() {
        return this.pos < this.count ? this.data.bytes[this.pos++] & 0xFF : -1;
    }

    @Override
    public int read(byte[] b, int off, int len) {
        if (b == null) {
            throw new NullPointerException();
        }
        if (off < 0 || len < 0 || len > b.length - off) {
            throw new IndexOutOfBoundsException();
        }
        if (this.pos >= this.count) {
            return -1;
        }
        if (this.pos + len > this.count) {
            len = this.count - this.pos;
        }
        if (len <= 0) {
            return 0;
        }
        System.arraycopy(this.data.bytes, this.pos, b, off, len);
        this.pos += len;
        return len;
    }

    @Override
    public long skip(long n) {
        if ((long)this.pos + n > (long)this.count) {
            n = this.count - this.pos;
        }
        if (n < 0L) {
            return 0L;
        }
        this.pos = (int)((long)this.pos + n);
        return n;
    }

    @Override
    public int available() {
        return this.count - this.pos;
    }

    public int position() {
        return this.pos - this.offset;
    }

    @Override
    public boolean markSupported() {
        return true;
    }

    @Override
    public void mark(int readAheadLimit) {
        this.mark = this.pos;
    }

    @Override
    public void reset() {
        this.pos = this.mark;
    }

    @Override
    public void close() {
    }

    public BytesArray bytes() {
        return this.data;
    }

    public void setBytes(byte[] data, int size2) {
        this.data.bytes(data, size2);
    }
}

