/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.StringTokenizer;
import org.codehaus.jackson.io.JsonStringEncoder;
import org.elasticsearch.hadoop.EsHadoopIllegalStateException;
import org.elasticsearch.hadoop.serialization.json.BackportedJsonStringEncoder;
import org.elasticsearch.hadoop.util.ObjectUtils;

public abstract class StringUtils {
    public static final Charset UTF_8 = Charset.forName("UTF-8");
    public static final String EMPTY = "";
    public static final String DEFAULT_DELIMITER = ",";
    public static final String SLASH = "/";
    public static final String PATH_TOP = "..";
    public static final String PATH_CURRENT = ".";
    public static final String SOURCE_FIELD_NAME = "_source.";
    public static final String FIELD_FIELD_NAME = "fields.";
    public static final String SOURCE_ROOT = "hits.hits._source.";
    public static final String FIELDS_ROOT = "hits.hits.fields.";
    public static final String[] EMPTY_ARRAY = new String[0];
    private static final boolean HAS_JACKSON_CLASS = ObjectUtils.isClassPresent("org.codehaus.jackson.io.JsonStringEncoder", StringUtils.class.getClassLoader());
    private static final char[] SINGLE_INDEX_ILLEGAL_START_CHARACTERS = new char[]{'_', '+', '-'};
    private static final char[] SINGLE_INDEX_ILLEGAL_CHARACTERS = new char[]{' ', '\"', '*', '\\', '<', '|', ',', '>', '/', '?'};

    public static boolean hasLength(CharSequence sequence2) {
        return sequence2 != null && sequence2.length() > 0;
    }

    public static boolean hasText(CharSequence sequence2) {
        if (!StringUtils.hasLength(sequence2)) {
            return false;
        }
        int length = sequence2.length();
        for (int i = 0; i < length; ++i) {
            if (Character.isWhitespace(sequence2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static boolean hasWhitespace(CharSequence sequence2) {
        if (!StringUtils.hasLength(sequence2)) {
            return false;
        }
        int length = sequence2.length();
        for (int i = 0; i < length; ++i) {
            if (!Character.isWhitespace(sequence2.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public static int countOccurrences(String string2, String substring) {
        int index;
        if (string2 == null || substring == null || string2.length() == 0 || substring.length() == 0) {
            return 0;
        }
        int count2 = 0;
        int currentPosition = 0;
        while ((index = string2.indexOf(substring, currentPosition)) != -1) {
            ++count2;
            currentPosition = index + substring.length();
        }
        return count2;
    }

    public static List<String> tokenize(String string2) {
        return StringUtils.tokenize(string2, DEFAULT_DELIMITER);
    }

    public static List<String> tokenize(String string2, String delimiters) {
        return StringUtils.tokenize(string2, delimiters, true, true);
    }

    public static List<String> tokenize(String string2, String delimiters, boolean trimTokens, boolean ignoreEmptyTokens) {
        if (!StringUtils.hasText(string2)) {
            return Collections.emptyList();
        }
        StringTokenizer st = new StringTokenizer(string2, delimiters);
        ArrayList<String> tokens = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            if (trimTokens) {
                token = token.trim();
            }
            if (ignoreEmptyTokens && token.length() <= 0) continue;
            tokens.add(token);
        }
        return tokens;
    }

    public static String concatenate(Collection<?> list) {
        return StringUtils.concatenate(list, DEFAULT_DELIMITER);
    }

    public static String concatenate(Collection<?> list, String delimiter) {
        if (list == null || list.isEmpty()) {
            return EMPTY;
        }
        if (delimiter == null) {
            delimiter = EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (Object object : list) {
            sb.append(object.toString());
            sb.append(delimiter);
        }
        sb.setLength(sb.length() - delimiter.length());
        return sb.toString();
    }

    public static String concatenate(Object[] array, String delimiter) {
        if (array == null || array.length == 0) {
            return EMPTY;
        }
        if (delimiter == null) {
            delimiter = EMPTY;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < array.length; ++i) {
            if (i > 0) {
                sb.append(delimiter);
            }
            sb.append(array[i]);
        }
        return sb.toString();
    }

    public static String deleteWhitespace(CharSequence sequence2) {
        if (!StringUtils.hasLength(sequence2)) {
            return EMPTY;
        }
        StringBuilder sb = new StringBuilder(sequence2.length());
        for (int i = 0; i < sequence2.length(); ++i) {
            char currentChar = sequence2.charAt(i);
            if (Character.isWhitespace(currentChar)) continue;
            sb.append(currentChar);
        }
        return sb.length() == sequence2.length() ? sequence2.toString() : sb.toString();
    }

    public static String trimWhitespace(String string2) {
        if (!StringUtils.hasLength(string2)) {
            return string2;
        }
        StringBuilder sb = new StringBuilder(string2);
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(0))) {
            sb.deleteCharAt(0);
        }
        while (sb.length() > 0 && Character.isWhitespace(sb.charAt(sb.length() - 1))) {
            sb.deleteCharAt(sb.length() - 1);
        }
        return sb.length() == string2.length() ? string2 : sb.toString();
    }

    public static String asUTFString(byte[] content) {
        return StringUtils.asUTFString(content, 0, content.length);
    }

    public static String asUTFString(byte[] content, int offset, int length) {
        return content == null || length == 0 ? EMPTY : new String(content, offset, length, UTF_8);
    }

    public static byte[] toUTF(String string2) {
        return string2.getBytes(UTF_8);
    }

    public static int levenshteinDistance(CharSequence one, CharSequence another, int threshold) {
        int n = one.length();
        int m = another.length();
        if (n == 0) {
            return m <= threshold ? m : -1;
        }
        if (m == 0) {
            return n <= threshold ? n : -1;
        }
        if (n > m) {
            CharSequence tmp = one;
            one = another;
            another = tmp;
            n = m;
            m = another.length();
        }
        int[] p = new int[n + 1];
        int[] d = new int[n + 1];
        int boundary = Math.min(n, threshold) + 1;
        for (int i = 0; i < boundary; ++i) {
            p[i] = i;
        }
        Arrays.fill(p, boundary, p.length, Integer.MAX_VALUE);
        Arrays.fill(d, Integer.MAX_VALUE);
        for (int j = 1; j <= m; ++j) {
            int max2;
            char t_j = another.charAt(j - 1);
            d[0] = j;
            int min2 = Math.max(1, j - threshold);
            int n2 = max2 = j > Integer.MAX_VALUE - threshold ? n : Math.min(n, j + threshold);
            if (min2 > max2) {
                return -1;
            }
            if (min2 > 1) {
                d[min2 - 1] = Integer.MAX_VALUE;
            }
            for (int i = min2; i <= max2; ++i) {
                d[i] = one.charAt(i - 1) == t_j ? p[i - 1] : 1 + Math.min(Math.min(d[i - 1], p[i]), p[i - 1]);
            }
            int[] _d = p;
            p = d;
            d = _d;
        }
        if (p[n] <= threshold) {
            return p[n];
        }
        return -1;
    }

    public static List<String> findSimiliar(CharSequence match, Collection<String> potential) {
        ArrayList<String> list = new ArrayList<String>(3);
        int maxDistance = 2;
        for (String string2 : potential) {
            int dist = StringUtils.levenshteinDistance(match, string2, maxDistance);
            if (dist < 0) continue;
            if (dist < maxDistance) {
                maxDistance = dist;
                list.clear();
                list.add(string2);
                continue;
            }
            if (dist != maxDistance) continue;
            list.add(string2);
        }
        return list;
    }

    public static String sanitizeResource(String resource) {
        String res = resource.trim();
        if (res.startsWith(SLASH)) {
            res = res.substring(1);
        }
        if (res.endsWith(SLASH)) {
            res = res.substring(0, res.length() - 1);
        }
        return res;
    }

    public static boolean isValidSingularIndexName(String singleIndexName) {
        boolean firstRun = true;
        char[] chars = singleIndexName.toCharArray();
        for (int idx = 0; idx < chars.length; ++idx) {
            char lo;
            char hi;
            int codePoint;
            char c = chars[idx];
            if (firstRun) {
                for (char illegalStartCharacter : SINGLE_INDEX_ILLEGAL_START_CHARACTERS) {
                    if (c != illegalStartCharacter) continue;
                    return false;
                }
                firstRun = false;
            }
            for (char illegalCharacter : SINGLE_INDEX_ILLEGAL_CHARACTERS) {
                if (c != illegalCharacter) continue;
                return false;
            }
            if (!(Character.isHighSurrogate(c) ? Character.isUpperCase(codePoint = ((hi = c) - 55296) * 1024 + ((lo = chars[++idx]) - 56320) + 65536) : Character.isUpperCase(c))) continue;
            return false;
        }
        return true;
    }

    public static boolean isLowerCase(CharSequence string2) {
        for (int index = 0; index < string2.length(); ++index) {
            if (!Character.isUpperCase(string2.charAt(index))) continue;
            return false;
        }
        return true;
    }

    public static boolean hasLetter(CharSequence string2) {
        for (int index = 0; index < string2.length(); ++index) {
            if (!Character.isLetter(string2.charAt(index))) continue;
            return true;
        }
        return false;
    }

    public static String jsonEncoding(String rawString) {
        return new String(HAS_JACKSON_CLASS ? JacksonStringEncoder.jsonEncoding(rawString) : BackportedJsonStringEncoder.getInstance().quoteAsString(rawString));
    }

    public static String toJsonString(Object value) {
        if (value == null) {
            return "null";
        }
        if (value.getClass().equals(String.class)) {
            return "\"" + StringUtils.jsonEncoding(value.toString()) + "\"";
        }
        return value.toString();
    }

    public static IpAndPort parseIpAddress(String httpAddr) {
        int portIndex;
        if (httpAddr.contains(SLASH)) {
            int startIp = httpAddr.indexOf(SLASH) + 1;
            int endIp = httpAddr.indexOf("]");
            if (endIp < 0) {
                endIp = httpAddr.length();
            }
            if (startIp < 0) {
                throw new EsHadoopIllegalStateException("Cannot parse http address " + httpAddr);
            }
            httpAddr = httpAddr.substring(startIp, endIp);
        }
        if ((portIndex = httpAddr.lastIndexOf(":")) > 0) {
            String ip = httpAddr.substring(0, portIndex);
            int port = Integer.valueOf(httpAddr.substring(portIndex + 1));
            return new IpAndPort(ip, port);
        }
        return new IpAndPort(httpAddr);
    }

    public static String stripFieldNameSourcePrefix(String fieldName) {
        if (fieldName != null) {
            if (fieldName.startsWith(SOURCE_FIELD_NAME)) {
                return fieldName.substring(SOURCE_FIELD_NAME.length());
            }
            if (fieldName.startsWith(SOURCE_ROOT)) {
                return fieldName.substring(SOURCE_ROOT.length());
            }
            if (fieldName.startsWith(FIELD_FIELD_NAME)) {
                return fieldName.substring(FIELD_FIELD_NAME.length());
            }
            if (fieldName.startsWith(FIELDS_ROOT)) {
                return fieldName.substring(FIELDS_ROOT.length());
            }
        }
        return fieldName;
    }

    private static class JacksonStringEncoder {
        private JacksonStringEncoder() {
        }

        public static char[] jsonEncoding(String rawString) {
            return JsonStringEncoder.getInstance().quoteAsString(rawString);
        }
    }

    public static class IpAndPort {
        public final String ip;
        public final int port;

        IpAndPort(String ip, int port) {
            this.ip = ip;
            this.port = port;
        }

        IpAndPort(String ip) {
            this.ip = ip;
            this.port = 0;
        }

        public String toString() {
            return this.port > 0 ? this.ip + ":" + this.port : this.ip;
        }
    }
}

