/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import org.apache.hadoop.io.AbstractMapWritable;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.BooleanWritable;
import org.apache.hadoop.io.ByteWritable;
import org.apache.hadoop.io.BytesWritable;
import org.apache.hadoop.io.DoubleWritable;
import org.apache.hadoop.io.FloatWritable;
import org.apache.hadoop.io.IntWritable;
import org.apache.hadoop.io.MapWritable;
import org.apache.hadoop.io.NullWritable;
import org.apache.hadoop.io.SortedMapWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.io.VIntWritable;
import org.apache.hadoop.io.VLongWritable;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableComparable;
import org.elasticsearch.hadoop.mr.WritableCompatUtil;
import org.elasticsearch.hadoop.util.StringUtils;

public abstract class WritableUtils {
    public static Writable toWritable(Object object) {
        if (object instanceof Writable) {
            return (Writable)object;
        }
        if (object == null) {
            return NullWritable.get();
        }
        if (object instanceof String) {
            return new Text((String)object);
        }
        if (object instanceof Long) {
            return new VLongWritable(((Long)object).longValue());
        }
        if (object instanceof Integer) {
            return new VIntWritable(((Integer)object).intValue());
        }
        if (object instanceof Byte) {
            return new ByteWritable(((Byte)object).byteValue());
        }
        if (object instanceof Short) {
            return WritableCompatUtil.availableShortWritable((Short)object);
        }
        if (object instanceof Double) {
            return new DoubleWritable(((Double)object).doubleValue());
        }
        if (object instanceof Float) {
            return new FloatWritable(((Float)object).floatValue());
        }
        if (object instanceof Boolean) {
            return new BooleanWritable(((Boolean)object).booleanValue());
        }
        if (object instanceof byte[]) {
            return new BytesWritable((byte[])object);
        }
        if (object instanceof List) {
            List list = (List)object;
            if (!list.isEmpty()) {
                Object first = list.get(0);
                Writable[] content = new Writable[list.size()];
                for (int i = 0; i < content.length; ++i) {
                    content[i] = WritableUtils.toWritable(list.get(i));
                }
                return new ArrayWritable(WritableUtils.toWritable(first).getClass(), content);
            }
            return new ArrayWritable(NullWritable.class, new Writable[0]);
        }
        if (object instanceof SortedSet) {
            SortedMapWritable smap = new SortedMapWritable();
            SortedSet set = (SortedSet)object;
            for (Object obj : set) {
                smap.put((WritableComparable)WritableUtils.toWritable(obj), (Writable)NullWritable.get());
            }
            return smap;
        }
        if (object instanceof Set) {
            MapWritable map2 = new MapWritable();
            Set set = (Set)object;
            for (Object obj : set) {
                map2.put(WritableUtils.toWritable(obj), (Writable)NullWritable.get());
            }
            return map2;
        }
        if (object instanceof SortedMap) {
            SortedMapWritable smap = new SortedMapWritable();
            Map map3 = (Map)object;
            for (Map.Entry entry : map3.entrySet()) {
                smap.put((WritableComparable)WritableUtils.toWritable(entry.getKey()), WritableUtils.toWritable(entry.getValue()));
            }
            return smap;
        }
        if (object instanceof Map) {
            MapWritable result2 = new MapWritable();
            Map map4 = (Map)object;
            for (Map.Entry entry : map4.entrySet()) {
                result2.put(WritableUtils.toWritable(entry.getKey()), WritableUtils.toWritable(entry.getValue()));
            }
            return result2;
        }
        return new BytesWritable(object.toString().getBytes(StringUtils.UTF_8));
    }

    public static Object fromWritable(Writable writable) {
        if (writable == null) {
            return null;
        }
        if (writable instanceof NullWritable) {
            return null;
        }
        if (writable instanceof Text) {
            return ((Text)writable).toString();
        }
        if (WritableCompatUtil.isShortWritable(writable)) {
            return WritableCompatUtil.unwrap(writable);
        }
        if (writable instanceof IntWritable) {
            return ((IntWritable)writable).get();
        }
        if (writable instanceof VLongWritable) {
            return ((VLongWritable)writable).get();
        }
        if (writable instanceof VIntWritable) {
            return ((VIntWritable)writable).get();
        }
        if (writable instanceof ByteWritable) {
            return ((ByteWritable)writable).get();
        }
        if (writable instanceof DoubleWritable) {
            return ((DoubleWritable)writable).get();
        }
        if (writable instanceof FloatWritable) {
            return Float.valueOf(((FloatWritable)writable).get());
        }
        if (writable instanceof BooleanWritable) {
            return ((BooleanWritable)writable).get();
        }
        if (writable instanceof BytesWritable) {
            return ((BytesWritable)writable).getBytes();
        }
        if (writable instanceof ArrayWritable) {
            Writable[] writables = ((ArrayWritable)writable).get();
            ArrayList<Object> list = new ArrayList<Object>(writables.length);
            for (Writable wrt : writables) {
                list.add(WritableUtils.fromWritable(wrt));
            }
            return list;
        }
        if (writable instanceof AbstractMapWritable) {
            Map smap = (Map)writable;
            Set wkeys = smap.keySet();
            AbstractMap map2 = writable instanceof SortedMapWritable ? new TreeMap() : new LinkedHashMap(wkeys.size());
            boolean isSet = true;
            for (Writable wKey : wkeys) {
                Writable wValue = (Writable)smap.get(wKey);
                if (!(wValue instanceof NullWritable)) {
                    isSet = false;
                }
                map2.put(WritableUtils.fromWritable(wKey), WritableUtils.fromWritable(wValue));
            }
            if (isSet) {
                return map2.keySet();
            }
            return map2;
        }
        return org.apache.hadoop.io.WritableUtils.toByteArray((Writable[])new Writable[]{writable});
    }
}

