/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.hadoop.util.unit;

import java.util.concurrent.TimeUnit;
import org.elasticsearch.hadoop.EsHadoopIllegalArgumentException;
import org.elasticsearch.hadoop.util.StringUtils;
import org.elasticsearch.hadoop.util.unit.Strings;

public class TimeValue {
    private long duration;
    private TimeUnit timeUnit;
    static final long C0 = 1L;
    static final long C1 = 1000L;
    static final long C2 = 1000000L;
    static final long C3 = 1000000000L;
    static final long C4 = 60000000000L;
    static final long C5 = 3600000000000L;
    static final long C6 = 86400000000000L;

    public static TimeValue timeValueNanos(long nanos) {
        return new TimeValue(nanos, TimeUnit.NANOSECONDS);
    }

    public static TimeValue timeValueMillis(long millis) {
        return new TimeValue(millis, TimeUnit.MILLISECONDS);
    }

    public static TimeValue timeValueSeconds(long seconds) {
        return new TimeValue(seconds, TimeUnit.SECONDS);
    }

    public static TimeValue timeValueMinutes(long minutes) {
        return new TimeValue(minutes, TimeUnit.MINUTES);
    }

    public static TimeValue timeValueHours(long hours) {
        return new TimeValue(hours, TimeUnit.HOURS);
    }

    public TimeValue(long millis) {
        this(millis, TimeUnit.MILLISECONDS);
    }

    public TimeValue(long duration, TimeUnit timeUnit) {
        this.duration = duration;
        this.timeUnit = timeUnit;
    }

    public long nanos() {
        return this.timeUnit.toNanos(this.duration);
    }

    public long getNanos() {
        return this.nanos();
    }

    public long micros() {
        return this.timeUnit.toMicros(this.duration);
    }

    public long getMicros() {
        return this.micros();
    }

    public long millis() {
        return this.timeUnit.toMillis(this.duration);
    }

    public long getMillis() {
        return this.millis();
    }

    public long seconds() {
        return this.timeUnit.toSeconds(this.duration);
    }

    public long getSeconds() {
        return this.seconds();
    }

    public long minutes() {
        return this.timeUnit.toMinutes(this.duration);
    }

    public long getMinutes() {
        return this.minutes();
    }

    public long hours() {
        return this.timeUnit.toHours(this.duration);
    }

    public long getHours() {
        return this.hours();
    }

    public long days() {
        return this.timeUnit.toDays(this.duration);
    }

    public long getDays() {
        return this.days();
    }

    public double microsFrac() {
        return (double)this.nanos() / 1000.0;
    }

    public double getMicrosFrac() {
        return this.microsFrac();
    }

    public double millisFrac() {
        return (double)this.nanos() / 1000000.0;
    }

    public double getMillisFrac() {
        return this.millisFrac();
    }

    public double secondsFrac() {
        return (double)this.nanos() / 1.0E9;
    }

    public double getSecondsFrac() {
        return this.secondsFrac();
    }

    public double minutesFrac() {
        return (double)this.nanos() / 6.0E10;
    }

    public double getMinutesFrac() {
        return this.minutesFrac();
    }

    public double hoursFrac() {
        return (double)this.nanos() / 3.6E12;
    }

    public double getHoursFrac() {
        return this.hoursFrac();
    }

    public double daysFrac() {
        return (double)this.nanos() / 8.64E13;
    }

    public double getDaysFrac() {
        return this.daysFrac();
    }

    public String toString() {
        if (this.duration < 0L) {
            return Long.toString(this.duration);
        }
        long nanos = this.nanos();
        if (nanos == 0L) {
            return "0s";
        }
        double value = nanos;
        String suffix = "nanos";
        if (nanos >= 86400000000000L) {
            value = this.daysFrac();
            suffix = "d";
        } else if (nanos >= 3600000000000L) {
            value = this.hoursFrac();
            suffix = "h";
        } else if (nanos >= 60000000000L) {
            value = this.minutesFrac();
            suffix = "m";
        } else if (nanos >= 1000000000L) {
            value = this.secondsFrac();
            suffix = "s";
        } else if (nanos >= 1000000L) {
            value = this.millisFrac();
            suffix = "ms";
        } else if (nanos >= 1000L) {
            value = this.microsFrac();
            suffix = "micros";
        }
        return Strings.format1Decimals(value, suffix);
    }

    public static TimeValue parseTimeValue(String sValue) {
        try {
            sValue = StringUtils.deleteWhitespace(sValue);
            long millis = sValue.endsWith("S") ? Long.parseLong(sValue.substring(0, sValue.length() - 1)) : (sValue.endsWith("ms") ? (long)Double.parseDouble(sValue.substring(0, sValue.length() - "ms".length())) : (sValue.endsWith("s") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 1000.0) : (sValue.endsWith("m") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 60.0 * 1000.0) : (sValue.endsWith("H") || sValue.endsWith("h") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 60.0 * 60.0 * 1000.0) : (sValue.endsWith("d") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 24.0 * 60.0 * 60.0 * 1000.0) : (sValue.endsWith("w") ? (long)(Double.parseDouble(sValue.substring(0, sValue.length() - 1)) * 7.0 * 24.0 * 60.0 * 60.0 * 1000.0) : Long.parseLong(sValue)))))));
            return new TimeValue(millis, TimeUnit.MILLISECONDS);
        }
        catch (NumberFormatException e) {
            throw new EsHadoopIllegalArgumentException("Failed to parse [" + sValue + "]", e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeValue timeValue = (TimeValue)o;
        if (this.duration != timeValue.duration) {
            return false;
        }
        return this.timeUnit == timeValue.timeUnit;
    }

    public int hashCode() {
        int result2 = (int)(this.duration ^ this.duration >>> 32);
        result2 = 31 * result2 + (this.timeUnit != null ? this.timeUnit.hashCode() : 0);
        return result2;
    }
}

