/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.deploy.yarn.security;

import java.security.PrivilegedExceptionAction;
import java.util.Arrays;
import java.util.UUID;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.Credentials;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.Token;
import org.apache.spark.SparkConf;
import org.apache.spark.deploy.yarn.security.ServiceCredentialProvider;
import org.elasticsearch.hadoop.cfg.CompositeSettings;
import org.elasticsearch.hadoop.cfg.HadoopSettingsManager;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.EsTokenIdentifier;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.hadoop.rest.RestClient;
import org.elasticsearch.hadoop.security.AuthenticationMethod;
import org.elasticsearch.hadoop.security.EsToken;
import org.elasticsearch.hadoop.security.User;
import org.elasticsearch.hadoop.security.UserProvider;
import org.elasticsearch.spark.cfg.SparkSettingsManager;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u00114A!\u0001\u0002\u0001\u001f\tYRi]*feZL7-Z\"sK\u0012,g\u000e^5bYB\u0013xN^5eKJT!a\u0001\u0003\u0002\u0011M,7-\u001e:jifT!!\u0002\u0004\u0002\te\f'O\u001c\u0006\u0003\u000f!\ta\u0001Z3qY>L(BA\u0005\u000b\u0003\u0015\u0019\b/\u0019:l\u0015\tYA\"A\u0007fY\u0006\u001cH/[2tK\u0006\u00148\r\u001b\u0006\u0002\u001b\u0005\u0019qN]4\u0004\u0001M\u0019\u0001\u0001\u0005\f\u0011\u0005E!R\"\u0001\n\u000b\u0003M\tQa]2bY\u0006L!!\u0006\n\u0003\r\u0005s\u0017PU3g!\t9b$D\u0001\u0019\u0015\t\u0019\u0011D\u0003\u0002\u00065)\u0011qa\u0007\u0006\u0003\u0013qQ!!\b\u0007\u0002\r\u0005\u0004\u0018m\u00195f\u0013\ty\u0002DA\rTKJ4\u0018nY3De\u0016$WM\u001c;jC2\u0004&o\u001c<jI\u0016\u0014\b\"B\u0011\u0001\t\u0003\u0011\u0013A\u0002\u001fj]&$h\bF\u0001$!\t!\u0003!D\u0001\u0003\u0011\u00191\u0003\u0001)A\u0005O\u0005\u0019AjT$\u0011\u0005!jS\"A\u0015\u000b\u0005)Z\u0013a\u00027pO\u001eLgn\u001a\u0006\u0003Yq\tqaY8n[>t7/\u0003\u0002/S\t\u0019Aj\\4\t\u000bA\u0002A\u0011I\u0019\u0002\u0017M,'O^5dK:\u000bW.Z\u000b\u0002eA\u00111G\u000e\b\u0003#QJ!!\u000e\n\u0002\rA\u0013X\rZ3g\u0013\t9\u0004H\u0001\u0004TiJLgn\u001a\u0006\u0003kIAQA\u000f\u0001\u0005Bm\n1c\u0019:fI\u0016tG/[1mgJ+\u0017/^5sK\u0012$\"\u0001P \u0011\u0005Ei\u0014B\u0001 \u0013\u0005\u001d\u0011un\u001c7fC:DQ\u0001Q\u001dA\u0002\u0005\u000b!\u0002[1e_>\u00048i\u001c8g!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003d_:4'B\u0001$\u001d\u0003\u0019A\u0017\rZ8pa&\u0011\u0001j\u0011\u0002\u000e\u0007>tg-[4ve\u0006$\u0018n\u001c8\t\u000bi\u0002A\u0011\u0001&\u0015\u0007qZ\u0015\u000bC\u0003M\u0013\u0002\u0007Q*A\u0005ta\u0006\u00148nQ8oMB\u0011ajT\u0007\u00027%\u0011\u0001k\u0007\u0002\n'B\f'o[\"p]\u001aDQ\u0001Q%A\u0002\u0005CQa\u0015\u0001\u0005BQ\u000b\u0011c\u001c2uC&t7I]3eK:$\u0018.\u00197t)\u0011)6\fX/\u0011\u0007E1\u0006,\u0003\u0002X%\t1q\n\u001d;j_:\u0004\"!E-\n\u0005i\u0013\"\u0001\u0002'p]\u001eDQ\u0001\u0011*A\u0002\u0005CQ\u0001\u0014*A\u00025CQA\u0018*A\u0002}\u000bQa\u0019:fIN\u0004\"\u0001\u00192\u000e\u0003\u0005T!aA#\n\u0005\r\f'aC\"sK\u0012,g\u000e^5bYN\u0004")
public class EsServiceCredentialProvider
implements ServiceCredentialProvider {
    private final Log LOG;

    public String serviceName() {
        return "elasticsearch";
    }

    public boolean credentialsRequired(Configuration hadoopConf) {
        return this.credentialsRequired(null, hadoopConf);
    }

    public boolean credentialsRequired(SparkConf sparkConf, Configuration hadoopConf) {
        Settings settings = sparkConf == null ? HadoopSettingsManager.loadFrom(hadoopConf) : new CompositeSettings(Arrays.asList((Object[])new Settings[]{new SparkSettingsManager().load(sparkConf), new HadoopSettingsManager().load(hadoopConf)}));
        boolean isSecurityEnabled = UserGroupInformation.isSecurityEnabled();
        AuthenticationMethod esAuthMethod = settings.getSecurityAuthenticationMethod();
        boolean required = isSecurityEnabled && AuthenticationMethod.KERBEROS.equals((Object)esAuthMethod);
        this.LOG.info((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Hadoop Security Enabled = [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(isSecurityEnabled)})));
        this.LOG.info((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ES Auth Method = [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{esAuthMethod})));
        this.LOG.info((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Are creds required = [", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToBoolean(required)})));
        return required;
    }

    /*
     * WARNING - void declaration
     */
    public Option<Object> obtainCredentials(Configuration hadoopConf, SparkConf sparkConf, Credentials creds) {
        Some<Object> some;
        CompositeSettings settings = new CompositeSettings(Arrays.asList((Object[])new Settings[]{new SparkSettingsManager().load(sparkConf), new HadoopSettingsManager().load(hadoopConf)}));
        InitializationUtils.setUserProviderIfNotSet(settings, HadoopUserProvider.class, LogFactory.getLog(EsServiceCredentialProvider.class));
        UserProvider userProvider = UserProvider.create(settings);
        RestClient client = new RestClient(settings);
        try {
            User user = userProvider.getUser();
            EsToken esToken = user.doAs(new PrivilegedExceptionAction<EsToken>(this, client){
                private final RestClient client$1;

                public EsToken run() {
                    return this.client$1.createNewApiToken(new StringBuilder().append((Object)"ESHADOOP_").append((Object)UUID.randomUUID().toString()).toString());
                }
                {
                    this.client$1 = client$1;
                }
            });
            if (this.LOG.isInfoEnabled()) {
                this.LOG.info((Object)new StringBuilder().append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"getting token for: Elasticsearch[tokenName=", ", "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{esToken.getName()}))).append((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"clusterName=", ", user=", "]"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{esToken.getClusterName(), user}))).toString());
            }
            long expiration = esToken.getExpirationTime();
            Token<EsTokenIdentifier> token = EsTokenIdentifier.createTokenFrom(esToken);
            creds.addToken(token.getService(), token);
            some = new Some<Object>(BoxesRunTime.boxToLong(expiration));
            client.close();
        }
        catch (Throwable throwable) {
            void var6_6;
            var6_6.close();
            throw throwable;
        }
        return some;
    }

    public EsServiceCredentialProvider() {
        ServiceCredentialProvider.class.$init$((ServiceCredentialProvider)this);
        this.LOG = LogFactory.getLog(EsServiceCredentialProvider.class);
        this.LOG.info((Object)"Loaded EsServiceCredentialProvider");
    }
}

