/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.rdd;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.SparkContext;
import org.apache.spark.TaskContext;
import org.apache.spark.rdd.RDD;
import org.elasticsearch.hadoop.cfg.PropertiesSettings;
import org.elasticsearch.hadoop.cfg.Settings;
import org.elasticsearch.hadoop.mr.security.HadoopUserProvider;
import org.elasticsearch.hadoop.rest.InitializationUtils;
import org.elasticsearch.spark.cfg.SparkSettings;
import org.elasticsearch.spark.cfg.SparkSettingsManager;
import org.elasticsearch.spark.rdd.CompatUtils;
import org.elasticsearch.spark.rdd.EsRDDWriter;
import org.elasticsearch.spark.rdd.ScalaEsRDD;
import org.elasticsearch.spark.rdd.ScalaEsRDD$;
import scala.Function2;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.generic.Growable;
import scala.collection.mutable.MapLike;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;

public final class EsSpark$ {
    public static final EsSpark$ MODULE$;
    private final transient Log LOG;

    static {
        new EsSpark$();
    }

    public RDD<Tuple2<String, Map<String, Object>>> esRDD(SparkContext sc) {
        return new ScalaEsRDD<Map<String, Object>>(sc, ScalaEsRDD$.MODULE$.$lessinit$greater$default$2());
    }

    public RDD<Tuple2<String, Map<String, Object>>> esRDD(SparkContext sc, Map<String, String> cfg) {
        return new ScalaEsRDD<Map<String, Object>>(sc, cfg);
    }

    public RDD<Tuple2<String, Map<String, Object>>> esRDD(SparkContext sc, String resource) {
        return new ScalaEsRDD<Map<String, Object>>(sc, (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.read"), resource)})));
    }

    public RDD<Tuple2<String, Map<String, Object>>> esRDD(SparkContext sc, String resource, String query) {
        return new ScalaEsRDD<Map<String, Object>>(sc, (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.read"), resource), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.query"), query)})));
    }

    public RDD<Tuple2<String, Map<String, Object>>> esRDD(SparkContext sc, String resource, Map<String, String> cfg) {
        return new ScalaEsRDD<Map<String, Object>>(sc, (Map)((Object)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.read"), resource))));
    }

    public RDD<Tuple2<String, Map<String, Object>>> esRDD(SparkContext sc, String resource, String query, Map<String, String> cfg) {
        return new ScalaEsRDD<Map<String, Object>>(sc, (Map)((Object)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.read"), resource), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.query"), query), Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
    }

    public RDD<Tuple2<String, String>> esJsonRDD(SparkContext sc) {
        return new ScalaEsRDD<String>(sc, (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.output.json"), ((Object)BoxesRunTime.boxToBoolean(true)).toString())})));
    }

    public RDD<Tuple2<String, String>> esJsonRDD(SparkContext sc, Map<String, String> cfg) {
        return new ScalaEsRDD<String>(sc, (Map)((Object)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.output.json"), ((Object)BoxesRunTime.boxToBoolean(true)).toString()))));
    }

    public RDD<Tuple2<String, String>> esJsonRDD(SparkContext sc, String resource) {
        return new ScalaEsRDD<String>(sc, (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.read"), resource), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.output.json"), ((Object)BoxesRunTime.boxToBoolean(true)).toString())})));
    }

    public RDD<Tuple2<String, String>> esJsonRDD(SparkContext sc, String resource, String query) {
        return new ScalaEsRDD<String>(sc, (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.read"), resource), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.query"), query), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.output.json"), ((Object)BoxesRunTime.boxToBoolean(true)).toString())})));
    }

    public RDD<Tuple2<String, String>> esJsonRDD(SparkContext sc, String resource, Map<String, String> cfg) {
        return new ScalaEsRDD<String>(sc, (Map)((Object)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.read"), resource), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.output.json"), ((Object)BoxesRunTime.boxToBoolean(true)).toString()), Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[0]))));
    }

    public RDD<Tuple2<String, String>> esJsonRDD(SparkContext sc, String resource, String query, Map<String, String> cfg) {
        return new ScalaEsRDD<String>(sc, (Map)((Object)((Growable)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.read"), resource), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.query"), query), Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.output.json"), ((Object)BoxesRunTime.boxToBoolean(true)).toString())}))));
    }

    public void saveToEs(RDD<?> rdd, String resource) {
        this.saveToEs(rdd, (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.write"), resource)})));
    }

    public void saveToEs(RDD<?> rdd, String resource, Map<String, String> cfg) {
        this.saveToEs(rdd, (Map)((Object)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.write"), resource))));
    }

    public void saveToEs(RDD<?> rdd, Map<String, String> cfg) {
        this.doSaveToEs(rdd, cfg, false);
    }

    public <K, V> void saveToEsWithMeta(RDD<Tuple2<K, V>> rdd, String resource) {
        this.saveToEsWithMeta(rdd, (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.write"), resource)})));
    }

    public <K, V> void saveToEsWithMeta(RDD<Tuple2<K, V>> rdd, String resource, Map<String, String> cfg) {
        this.saveToEsWithMeta(rdd, (Map)((Object)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.resource.write"), resource))));
    }

    public <K, V> void saveToEsWithMeta(RDD<Tuple2<K, V>> rdd, Map<String, String> cfg) {
        this.doSaveToEs(rdd, cfg, true);
    }

    public void doSaveToEs(RDD<?> rdd, Map<String, String> cfg, boolean hasMeta) {
        CompatUtils.warnSchemaRDD(rdd, LogFactory.getLog((String)"org.elasticsearch.spark.rdd.EsSpark"));
        if (rdd == null || rdd.partitions().length == 0) {
            return;
        }
        SparkSettings sparkCfg = new SparkSettingsManager().load(rdd.sparkContext().getConf());
        Settings config = new PropertiesSettings().load(sparkCfg.save());
        config.merge(JavaConverters$.MODULE$.mapAsJavaMapConverter(cfg).asJava());
        InitializationUtils.setUserProviderIfNotSet(config, HadoopUserProvider.class, this.LOG);
        InitializationUtils.discoverClusterInfo(config, this.LOG);
        InitializationUtils.checkIdForOperation(config);
        InitializationUtils.checkIndexExistence(config);
        EsRDDWriter<Object> esRDDWriter = new EsRDDWriter<Object>(config.save(), hasMeta, ClassTag$.MODULE$.Any());
        rdd.sparkContext().runJob(rdd, (Function2)((Object)new Serializable(esRDDWriter){
            public static final long serialVersionUID = 0L;
            private final EsRDDWriter eta$0$1$1;

            public final void apply(TaskContext taskContext, Iterator<Object> data) {
                this.eta$0$1$1.write(taskContext, data);
            }
            {
                this.eta$0$1$1 = eta$0$1$1;
            }
        }), ClassTag$.MODULE$.Unit());
    }

    public void saveJsonToEs(RDD<?> rdd, String resource) {
        this.saveToEs(rdd, resource, (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.input.json"), ((Object)BoxesRunTime.boxToBoolean(true)).toString())})));
    }

    public void saveJsonToEs(RDD<?> rdd, String resource, Map<String, String> cfg) {
        this.saveToEs(rdd, resource, (Map)((Object)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.input.json"), ((Object)BoxesRunTime.boxToBoolean(true)).toString()))));
    }

    public void saveJsonToEs(RDD<?> rdd, Map<String, String> cfg) {
        this.saveToEs(rdd, (Map)((Object)((MapLike)scala.collection.mutable.Map$.MODULE$.apply(cfg.toSeq())).$plus$eq(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc("es.input.json"), ((Object)BoxesRunTime.boxToBoolean(true)).toString()))));
    }

    private EsSpark$() {
        MODULE$ = this;
        this.LOG = LogFactory.getLog(this.getClass());
    }
}

