/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.spark.sql.streaming;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.spark.sql.execution.streaming.MetadataLog;
import org.elasticsearch.hadoop.util.Assert;
import org.elasticsearch.spark.sql.streaming.EsSinkStatus;
import org.elasticsearch.spark.sql.streaming.JobState;
import org.elasticsearch.spark.sql.streaming.TaskCommit;
import org.elasticsearch.spark.sql.streaming.TaskState;
import scala.None$;
import scala.Option$;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005\u001db\u0001B\u0001\u0003\u00015\u0011\u0001#R:D_6l\u0017\u000e\u001e)s_R|7m\u001c7\u000b\u0005\r!\u0011!C:ue\u0016\fW.\u001b8h\u0015\t)a!A\u0002tc2T!a\u0002\u0005\u0002\u000bM\u0004\u0018M]6\u000b\u0005%Q\u0011!D3mCN$\u0018nY:fCJ\u001c\u0007NC\u0001\f\u0003\ry'oZ\u0002\u0001'\r\u0001a\u0002\u0006\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\u0011\u0005=)\u0012B\u0001\f\u0011\u00051\u0019VM]5bY&T\u0018M\u00197f\u0011!A\u0002A!b\u0001\n\u0003I\u0012!C2p[6LG\u000fT8h+\u0005Q\u0002cA\u000e$K5\tAD\u0003\u0002\u0004;)\u0011adH\u0001\nKb,7-\u001e;j_:T!!\u0002\u0011\u000b\u0005\u001d\t#B\u0001\u0012\u000b\u0003\u0019\t\u0007/Y2iK&\u0011A\u0005\b\u0002\f\u001b\u0016$\u0018\rZ1uC2{w\rE\u0002\u0010M!J!a\n\t\u0003\u000b\u0005\u0013(/Y=\u0011\u0005%RS\"\u0001\u0002\n\u0005-\u0012!\u0001D#t'&t7n\u0015;biV\u001c\b\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\u0002\u0015\r|W.\\5u\u0019><\u0007\u0005\u000b\u0002-_A\u0011q\u0002M\u0005\u0003cA\u0011\u0011\u0002\u001e:b]NLWM\u001c;\t\u000bM\u0002A\u0011\u0001\u001b\u0002\rqJg.\u001b;?)\t)d\u0007\u0005\u0002*\u0001!)\u0001D\ra\u00015!A\u0001\b\u0001EC\u0002\u0013\u0005\u0011(\u0001\u0004m_\u001e<WM]\u000b\u0002uA\u00111\bQ\u0007\u0002y)\u0011QHP\u0001\bY><w-\u001b8h\u0015\ty\u0014%A\u0004d_6lwN\\:\n\u0005\u0005c$a\u0001'pO\"A1\t\u0001E\u0001B\u0003&!(A\u0004m_\u001e<WM\u001d\u0011)\u0005\t{\u0003\"\u0002$\u0001\t\u00039\u0015aB5oSRTuN\u0019\u000b\u0003\u0011.\u0003\"aD%\n\u0005)\u0003\"\u0001B+oSRDQ\u0001T#A\u00025\u000b\u0001B[8c'R\fG/\u001a\t\u0003S9K!a\u0014\u0002\u0003\u0011){'m\u0015;bi\u0016DQ!\u0015\u0001\u0005\u0002I\u000b\u0011bY8n[&$(j\u001c2\u0015\u0007!\u001bF\u000bC\u0003M!\u0002\u0007Q\nC\u0003V!\u0002\u0007a+A\u0006uCN\\7i\\7nSR\u001c\bcA,`E:\u0011\u0001,\u0018\b\u00033rk\u0011A\u0017\u0006\u000372\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005y\u0003\u0012a\u00029bG.\fw-Z\u0005\u0003A\u0006\u00141aU3r\u0015\tq\u0006\u0003\u0005\u0002*G&\u0011AM\u0001\u0002\u000b)\u0006\u001c8nQ8n[&$\b\"\u00024\u0001\t\u00039\u0017\u0001C1c_J$(j\u001c2\u0015\u0005!C\u0007\"\u0002'f\u0001\u0004i\u0005\"\u00036\u0001\u0001\u0004\u0005\r\u0011\"\u0001l\u00039\u0011XmY8sIN<&/\u001b;uK:,\u0012\u0001\u001c\t\u0003\u001f5L!A\u001c\t\u0003\t1{gn\u001a\u0005\na\u0002\u0001\r\u00111A\u0005\u0002E\f!C]3d_J$7o\u0016:jiR,gn\u0018\u0013fcR\u0011\u0001J\u001d\u0005\bg>\f\t\u00111\u0001m\u0003\rAH%\r\u0005\u0007k\u0002\u0001\u000b\u0015\u00027\u0002\u001fI,7m\u001c:eg^\u0013\u0018\u000e\u001e;f]\u0002B#\u0001^\u0018\t\u0013a\u0004\u0001\u0019!a\u0001\n\u0003Y\u0017AD3yK\u000e,H/[8o'R\f'\u000f\u001e\u0005\nu\u0002\u0001\r\u00111A\u0005\u0002m\f!#\u001a=fGV$\u0018n\u001c8Ti\u0006\u0014Ho\u0018\u0013fcR\u0011\u0001\n \u0005\bgf\f\t\u00111\u0001m\u0011\u0019q\b\u0001)Q\u0005Y\u0006yQ\r_3dkRLwN\\*uCJ$\b\u0005\u000b\u0002~_!9\u00111\u0001\u0001\u0005\u0002\u0005\u0015\u0011\u0001C5oSR$\u0016m]6\u0015\u0007!\u000b9\u0001\u0003\u0005\u0002\n\u0005\u0005\u0001\u0019AA\u0006\u0003%!\u0018m]6Ti\u0006$X\rE\u0002*\u0003\u001bI1!a\u0004\u0003\u0005%!\u0016m]6Ti\u0006$X\rC\u0004\u0002\u0014\u0001!\t!!\u0006\u0002\u0015I,7m\u001c:e'\u0016,g\u000eF\u0001I\u0011\u001d\tI\u0002\u0001C\u0001\u00037\t!bY8n[&$H+Y:l)\r\u0011\u0017Q\u0004\u0005\t\u0003\u0013\t9\u00021\u0001\u0002\f!9\u0011\u0011\u0005\u0001\u0005\u0002\u0005\r\u0012!C1c_J$H+Y:l)\rA\u0015Q\u0005\u0005\t\u0003\u0013\ty\u00021\u0001\u0002\f\u0001")
public class EsCommitProtocol
implements Serializable {
    private final transient MetadataLog<EsSinkStatus[]> commitLog;
    private transient Log logger;
    private transient long recordsWritten;
    private transient long executionStart;
    private volatile transient boolean bitmap$trans$0;

    private Log logger$lzycompute() {
        EsCommitProtocol esCommitProtocol = this;
        synchronized (esCommitProtocol) {
            if (!this.bitmap$trans$0) {
                this.logger = LogFactory.getLog(EsCommitProtocol.class);
                this.bitmap$trans$0 = true;
            }
            return this.logger;
        }
    }

    public MetadataLog<EsSinkStatus[]> commitLog() {
        return this.commitLog;
    }

    public Log logger() {
        return this.bitmap$trans$0 ? this.logger : this.logger$lzycompute();
    }

    public void initJob(JobState jobState) {
        Assert.notNull(this.commitLog(), "commitLog cannot be null");
    }

    public void commitJob(JobState jobState, Seq<TaskCommit> taskCommits) {
        EsSinkStatus[] commits = (EsSinkStatus[])((TraversableOnce)taskCommits.flatMap(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final Iterable<EsSinkStatus> apply(TaskCommit x$1) {
                return Option$.MODULE$.option2Iterable(x$1.statuses());
            }
        }, Seq$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(EsSinkStatus.class));
        if (this.commitLog().add(jobState.batchId(), (Object)commits)) {
            this.logger().debug((Object)new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committed batch ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(jobState.batchId())})));
            return;
        }
        throw new IllegalStateException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch Id [", "] is already committed"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToLong(jobState.batchId())})));
    }

    public void abortJob(JobState jobState) {
    }

    public long recordsWritten() {
        return this.recordsWritten;
    }

    public void recordsWritten_$eq(long x$1) {
        this.recordsWritten = x$1;
    }

    public long executionStart() {
        return this.executionStart;
    }

    public void executionStart_$eq(long x$1) {
        this.executionStart = x$1;
    }

    public void initTask(TaskState taskState) {
        this.recordsWritten_$eq(0L);
        this.executionStart_$eq(System.currentTimeMillis());
    }

    public void recordSeen() {
        this.recordsWritten_$eq(this.recordsWritten() + 1L);
    }

    public TaskCommit commitTask(TaskState taskState) {
        return this.recordsWritten() > 0L ? new TaskCommit(new Some<EsSinkStatus>(new EsSinkStatus(taskState.taskId(), this.executionStart(), taskState.resource(), this.recordsWritten()))) : new TaskCommit(None$.MODULE$);
    }

    public void abortTask(TaskState taskState) {
    }

    public EsCommitProtocol(MetadataLog<EsSinkStatus[]> commitLog) {
        this.commitLog = commitLog;
    }
}

