/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Condition;
import org.neo4j.cypherdsl.core.DefaultStatementBuilder;
import org.neo4j.cypherdsl.core.ExposesLogicalOperators;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Expressions;
import org.neo4j.cypherdsl.core.ListExpression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.NamedPath;
import org.neo4j.cypherdsl.core.Operator;
import org.neo4j.cypherdsl.core.PatternElement;
import org.neo4j.cypherdsl.core.RelationshipPattern;
import org.neo4j.cypherdsl.core.RelationshipPatternCondition;
import org.neo4j.cypherdsl.core.Where;
import org.neo4j.cypherdsl.core.support.Visitable;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class PatternComprehension
implements Expression {
    private final PatternElement pattern;
    private final Where where;
    private final Expression listDefinition;

    static OngoingDefinitionWithPattern basedOn(RelationshipPattern pattern) {
        Assertions.notNull(pattern, "A pattern is required");
        return new Builder(pattern);
    }

    static OngoingDefinitionWithPattern basedOn(NamedPath pattern) {
        Assertions.notNull(pattern, "A pattern is required");
        return new Builder(pattern);
    }

    private PatternComprehension(PatternElement pattern, Where where, Expression listDefinition) {
        this.pattern = pattern;
        this.where = where;
        this.listDefinition = listDefinition;
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.pattern.accept(visitor);
        Visitable.visitIfNotNull(this.where, visitor);
        Operator.PIPE.accept(visitor);
        this.listDefinition.accept(visitor);
        visitor.leave(this);
    }

    private static class Builder
    implements OngoingDefinitionWithPattern,
    OngoingDefinitionWithPatternAndWhere {
        private final PatternElement pattern;
        private final DefaultStatementBuilder.ConditionBuilder conditionBuilder = new DefaultStatementBuilder.ConditionBuilder();

        private Builder(PatternElement pattern) {
            this.pattern = pattern;
        }

        @Override
        public OngoingDefinitionWithPatternAndWhere where(Condition condition) {
            this.conditionBuilder.where(condition);
            return this;
        }

        @Override
        public OngoingDefinitionWithPatternAndWhere and(Condition condition) {
            this.conditionBuilder.and(condition);
            return this;
        }

        @Override
        public OngoingDefinitionWithPatternAndWhere or(Condition condition) {
            this.conditionBuilder.or(condition);
            return this;
        }

        @Override
        public PatternComprehension returning(Expression ... expressions) {
            Where where = this.conditionBuilder.buildCondition().map(Where::new).orElse(null);
            return new PatternComprehension(this.pattern, where, ListExpression.listOrSingleExpression(expressions));
        }
    }

    public static interface OngoingDefinitionWithPatternAndWhere
    extends OngoingDefinitionWithoutReturn,
    ExposesLogicalOperators<OngoingDefinitionWithPatternAndWhere> {
    }

    public static interface OngoingDefinitionWithPattern
    extends OngoingDefinitionWithoutReturn {
        public OngoingDefinitionWithPatternAndWhere where(Condition var1);

        default public OngoingDefinitionWithPatternAndWhere where(RelationshipPattern pathPattern) {
            Assertions.notNull(pathPattern, "The path pattern must not be null.");
            return this.where(new RelationshipPatternCondition(pathPattern));
        }
    }

    public static interface OngoingDefinitionWithoutReturn {
        default public PatternComprehension returning(Named ... variables) {
            return this.returning(Expressions.createSymbolicNames(variables));
        }

        public PatternComprehension returning(Expression ... var1);
    }
}

