/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypherdsl.core;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apiguardian.api.API;
import org.neo4j.cypherdsl.core.Expression;
import org.neo4j.cypherdsl.core.Named;
import org.neo4j.cypherdsl.core.Operation;
import org.neo4j.cypherdsl.core.Operations;
import org.neo4j.cypherdsl.core.PropertyLookup;
import org.neo4j.cypherdsl.core.SymbolicName;
import org.neo4j.cypherdsl.core.support.Visitor;
import org.neo4j.cypherdsl.core.utils.Assertions;

@API(status=API.Status.EXPERIMENTAL, since="1.0")
public final class Property
implements Expression {
    private final Expression container;
    private final List<PropertyLookup> names;

    static Property create(Named parentContainer, String ... names) {
        SymbolicName requiredSymbolicName;
        try {
            requiredSymbolicName = parentContainer.getRequiredSymbolicName();
        }
        catch (IllegalStateException e) {
            throw new IllegalArgumentException("A property derived from a node or a relationship needs a parent with a symbolic name.");
        }
        return new Property(requiredSymbolicName, Property.createListOfChainedNames(names));
    }

    static Property create(Expression container, String ... names) {
        Assertions.notNull(container, "The property container is required.");
        return new Property(container, Property.createListOfChainedNames(names));
    }

    private static List<PropertyLookup> createListOfChainedNames(String ... names) {
        Assertions.notEmpty(names, "The properties name is required.");
        if (names.length == 1) {
            return Collections.singletonList(new PropertyLookup(names[0]));
        }
        return Arrays.stream(names).map(PropertyLookup::new).collect(Collectors.collectingAndThen(Collectors.toList(), Collections::unmodifiableList));
    }

    Property(Expression container, List<PropertyLookup> names) {
        this.container = container;
        this.names = names;
    }

    @API(status=API.Status.INTERNAL)
    public List<PropertyLookup> getNames() {
        return this.names;
    }

    public Operation to(Expression expression) {
        return Operations.set(this, expression);
    }

    @Override
    public void accept(Visitor visitor) {
        visitor.enter(this);
        this.container.accept(visitor);
        this.names.forEach(name -> name.accept(visitor));
        visitor.leave(this);
    }
}

