/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver;

import java.util.HashMap;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.Values;
import org.neo4j.driver.internal.util.Iterables;
import org.neo4j.driver.internal.util.Preconditions;
import org.neo4j.driver.internal.value.MapValue;
import org.neo4j.driver.util.Immutable;

@Immutable
public class Query {
    private final String text;
    private final Value parameters;

    public Query(String text, Value parameters) {
        this.text = Query.validateQueryText(text);
        if (parameters == null) {
            this.parameters = Values.EmptyMap;
        } else if (parameters instanceof MapValue) {
            this.parameters = parameters;
        } else {
            throw new IllegalArgumentException("The parameters should be provided as Map type. Unsupported parameters type: " + parameters.type().name());
        }
    }

    public Query(String text, Map<String, Object> parameters) {
        this(text, Values.value(parameters));
    }

    public Query(String text) {
        this(text, Values.EmptyMap);
    }

    public String text() {
        return this.text;
    }

    public Value parameters() {
        return this.parameters;
    }

    public Query withText(String newText) {
        return new Query(newText, this.parameters);
    }

    public Query withParameters(Value newParameters) {
        return new Query(this.text, newParameters);
    }

    public Query withParameters(Map<String, Object> newParameters) {
        return new Query(this.text, newParameters);
    }

    public Query withUpdatedParameters(Value updates) {
        if (updates == null || updates.isEmpty()) {
            return this;
        }
        HashMap<String, Value> newParameters = Iterables.newHashMapWithSize(Math.max(this.parameters.size(), updates.size()));
        newParameters.putAll(this.parameters.asMap(Values.ofValue()));
        for (Map.Entry<String, Value> entry : updates.asMap(Values.ofValue()).entrySet()) {
            Value value2 = entry.getValue();
            if (value2.isNull()) {
                newParameters.remove(entry.getKey());
                continue;
            }
            newParameters.put(entry.getKey(), value2);
        }
        return this.withParameters(Values.value(newParameters));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Query query2 = (Query)o;
        return this.text.equals(query2.text) && this.parameters.equals(query2.parameters);
    }

    public int hashCode() {
        int result = this.text.hashCode();
        result = 31 * result + this.parameters.hashCode();
        return result;
    }

    public String toString() {
        return String.format("Query{text='%s', parameters=%s}", this.text, this.parameters);
    }

    private static String validateQueryText(String query2) {
        Preconditions.checkArgument(query2 != null, "Cypher query text should not be null");
        Preconditions.checkArgument(!query2.isEmpty(), "Cypher query text should not be an empty string");
        return query2;
    }
}

