/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal;

import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.internal.util.Iterables;

public final class InternalBookmark
implements Bookmark {
    private static final InternalBookmark EMPTY = new InternalBookmark(Collections.emptySet());
    private final Set<String> values;

    private InternalBookmark(Set<String> values2) {
        Objects.requireNonNull(values2);
        this.values = values2;
    }

    public static Bookmark empty() {
        return EMPTY;
    }

    public static Bookmark from(Iterable<Bookmark> bookmarks) {
        if (bookmarks == null) {
            return InternalBookmark.empty();
        }
        int size = Iterables.count(bookmarks);
        if (size == 0) {
            return InternalBookmark.empty();
        }
        if (size == 1) {
            return InternalBookmark.from(bookmarks.iterator().next());
        }
        HashSet<String> newValues = new HashSet<String>();
        for (Bookmark value2 : bookmarks) {
            if (value2 == null) continue;
            newValues.addAll(value2.values());
        }
        return new InternalBookmark(newValues);
    }

    private static Bookmark from(Bookmark bookmark) {
        if (bookmark == null) {
            return InternalBookmark.empty();
        }
        return bookmark;
    }

    public static Bookmark parse(String value2) {
        if (value2 == null) {
            return InternalBookmark.empty();
        }
        return new InternalBookmark(Collections.singleton(value2));
    }

    public static Bookmark parse(Set<String> values2) {
        if (values2 == null) {
            return InternalBookmark.empty();
        }
        return new InternalBookmark(values2);
    }

    @Override
    public boolean isEmpty() {
        return this.values.isEmpty();
    }

    @Override
    public Set<String> values() {
        return Collections.unmodifiableSet(this.values);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InternalBookmark bookmark = (InternalBookmark)o;
        return Objects.equals(this.values, bookmark.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return "Bookmark{values=" + this.values + "}";
    }
}

