/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.async;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicBoolean;
import org.neo4j.driver.AccessMode;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Logger;
import org.neo4j.driver.Logging;
import org.neo4j.driver.Query;
import org.neo4j.driver.TransactionConfig;
import org.neo4j.driver.async.ResultCursor;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.TransactionNestingException;
import org.neo4j.driver.internal.BookmarkHolder;
import org.neo4j.driver.internal.DatabaseName;
import org.neo4j.driver.internal.FailableCursor;
import org.neo4j.driver.internal.async.ConnectionContext;
import org.neo4j.driver.internal.async.UnmanagedTransaction;
import org.neo4j.driver.internal.cursor.AsyncResultCursor;
import org.neo4j.driver.internal.cursor.ResultCursorFactory;
import org.neo4j.driver.internal.cursor.RxResultCursor;
import org.neo4j.driver.internal.logging.PrefixedLogger;
import org.neo4j.driver.internal.retry.RetryLogic;
import org.neo4j.driver.internal.spi.Connection;
import org.neo4j.driver.internal.spi.ConnectionProvider;
import org.neo4j.driver.internal.util.Futures;

public class NetworkSession {
    private static final String LOG_NAME = "Session";
    private final ConnectionProvider connectionProvider;
    private final NetworkSessionConnectionContext connectionContext;
    private final AccessMode mode;
    private final RetryLogic retryLogic;
    protected final Logger logger;
    private final BookmarkHolder bookmarkHolder;
    private final long fetchSize;
    private volatile CompletionStage<UnmanagedTransaction> transactionStage = Futures.completedWithNull();
    private volatile CompletionStage<Connection> connectionStage = Futures.completedWithNull();
    private volatile CompletionStage<? extends FailableCursor> resultCursorStage = Futures.completedWithNull();
    private final AtomicBoolean open = new AtomicBoolean(true);

    public NetworkSession(ConnectionProvider connectionProvider, RetryLogic retryLogic, DatabaseName databaseName, AccessMode mode, BookmarkHolder bookmarkHolder, long fetchSize, Logging logging) {
        this.connectionProvider = connectionProvider;
        this.mode = mode;
        this.retryLogic = retryLogic;
        this.logger = new PrefixedLogger("[" + this.hashCode() + "]", logging.getLog(LOG_NAME));
        this.bookmarkHolder = bookmarkHolder;
        this.connectionContext = new NetworkSessionConnectionContext(databaseName, bookmarkHolder.getBookmark());
        this.fetchSize = fetchSize;
    }

    public CompletionStage<ResultCursor> runAsync(Query query2, TransactionConfig config) {
        CompletionStage newResultCursorStage = this.buildResultCursorFactory(query2, config).thenCompose(ResultCursorFactory::asyncResult);
        this.resultCursorStage = newResultCursorStage.exceptionally(error -> null);
        return newResultCursorStage.thenCompose(AsyncResultCursor::mapSuccessfulRunCompletionAsync).thenApply(cursor -> cursor);
    }

    public CompletionStage<RxResultCursor> runRx(Query query2, TransactionConfig config) {
        CompletionStage<RxResultCursor> newResultCursorStage = this.buildResultCursorFactory(query2, config).thenCompose(ResultCursorFactory::rxResult);
        this.resultCursorStage = newResultCursorStage.exceptionally(error -> null);
        return newResultCursorStage;
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(TransactionConfig config) {
        return this.beginTransactionAsync(this.mode, config);
    }

    public CompletionStage<UnmanagedTransaction> beginTransactionAsync(AccessMode mode, TransactionConfig config) {
        this.ensureSessionIsOpen();
        CompletionStage<UnmanagedTransaction> newTransactionStage = this.ensureNoOpenTxBeforeStartingTx().thenCompose(ignore -> this.acquireConnection(mode)).thenCompose(connection -> {
            UnmanagedTransaction tx = new UnmanagedTransaction((Connection)connection, this.bookmarkHolder, this.fetchSize);
            return tx.beginAsync(this.bookmarkHolder.getBookmark(), config);
        });
        CompletionStage<UnmanagedTransaction> currentTransactionStage = this.transactionStage;
        this.transactionStage = newTransactionStage.exceptionally(error -> null).thenCompose(tx -> {
            if (tx == null) {
                return currentTransactionStage;
            }
            return CompletableFuture.completedFuture(tx);
        });
        return newTransactionStage;
    }

    public CompletionStage<Void> resetAsync() {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                tx.markTerminated(null);
            }
        }).thenCompose(ignore -> this.connectionStage).thenCompose(connection -> {
            if (connection != null) {
                return connection.reset();
            }
            return Futures.completedWithNull();
        });
    }

    public RetryLogic retryLogic() {
        return this.retryLogic;
    }

    public Bookmark lastBookmark() {
        return this.bookmarkHolder.getBookmark();
    }

    public CompletionStage<Void> releaseConnectionAsync() {
        return this.connectionStage.thenCompose(connection -> {
            if (connection != null) {
                return connection.release();
            }
            return Futures.completedWithNull();
        });
    }

    public CompletionStage<Connection> connectionAsync() {
        return this.connectionStage;
    }

    public boolean isOpen() {
        return this.open.get();
    }

    public CompletionStage<Void> closeAsync() {
        if (this.open.compareAndSet(true, false)) {
            return this.resultCursorStage.thenCompose(cursor -> {
                if (cursor != null) {
                    return cursor.discardAllFailureAsync();
                }
                return Futures.completedWithNull();
            }).thenCompose(cursorError -> this.closeTransactionAndReleaseConnection().thenApply(txCloseError -> {
                CompletionException combinedError = Futures.combineErrors(cursorError, txCloseError);
                if (combinedError != null) {
                    throw combinedError;
                }
                return null;
            }));
        }
        return Futures.completedWithNull();
    }

    protected CompletionStage<Boolean> currentConnectionIsOpen() {
        return this.connectionStage.handle((connection, error) -> error == null && connection != null && connection.isOpen());
    }

    private CompletionStage<ResultCursorFactory> buildResultCursorFactory(Query query2, TransactionConfig config) {
        this.ensureSessionIsOpen();
        return this.ensureNoOpenTxBeforeRunningQuery().thenCompose(ignore -> this.acquireConnection(this.mode)).thenCompose(connection -> {
            try {
                ResultCursorFactory factory = connection.protocol().runInAutoCommitTransaction((Connection)connection, query2, this.bookmarkHolder, config, this.fetchSize);
                return CompletableFuture.completedFuture(factory);
            }
            catch (Throwable e) {
                return Futures.failedFuture(e);
            }
        });
    }

    private CompletionStage<Connection> acquireConnection(AccessMode mode) {
        CompletionStage<Connection> currentConnectionStage = this.connectionStage;
        CompletionStage<Connection> newConnectionStage = this.resultCursorStage.thenCompose(cursor -> {
            if (cursor == null) {
                return Futures.completedWithNull();
            }
            return cursor.pullAllFailureAsync();
        }).thenCompose(error -> {
            if (error == null) {
                return currentConnectionStage.exceptionally(ignore -> null);
            }
            throw new CompletionException((Throwable)error);
        }).thenCompose(existingConnection -> {
            if (existingConnection != null && existingConnection.isOpen()) {
                throw new IllegalStateException("Existing open connection detected");
            }
            return this.connectionProvider.acquireConnection(this.connectionContext.contextWithMode(mode));
        });
        this.connectionStage = newConnectionStage.exceptionally(error -> null);
        return newConnectionStage;
    }

    private CompletionStage<Throwable> closeTransactionAndReleaseConnection() {
        return this.existingTransactionOrNull().thenCompose(tx -> {
            if (tx != null) {
                return tx.closeAsync().thenApply(ignore -> null).exceptionally(error -> error);
            }
            return Futures.completedWithNull();
        }).thenCompose(txCloseError -> this.releaseConnectionAsync().thenApply(ignore -> txCloseError));
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeRunningQuery() {
        return this.ensureNoOpenTx("Queries cannot be run directly on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTxBeforeStartingTx() {
        return this.ensureNoOpenTx("You cannot begin a transaction on a session with an open transaction; either run from within the transaction or use a different session.");
    }

    private CompletionStage<Void> ensureNoOpenTx(String errorMessage) {
        return this.existingTransactionOrNull().thenAccept(tx -> {
            if (tx != null) {
                throw new TransactionNestingException(errorMessage);
            }
        });
    }

    private CompletionStage<UnmanagedTransaction> existingTransactionOrNull() {
        return this.transactionStage.exceptionally(error -> null).thenApply(tx -> tx != null && tx.isOpen() ? tx : null);
    }

    private void ensureSessionIsOpen() {
        if (!this.open.get()) {
            throw new ClientException("No more interaction with this session are allowed as the current session is already closed. ");
        }
    }

    private static class NetworkSessionConnectionContext
    implements ConnectionContext {
        private final DatabaseName databaseName;
        private AccessMode mode;
        private final Bookmark rediscoveryBookmark;

        private NetworkSessionConnectionContext(DatabaseName databaseName, Bookmark bookmark) {
            this.databaseName = databaseName;
            this.rediscoveryBookmark = bookmark;
        }

        private ConnectionContext contextWithMode(AccessMode mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public DatabaseName databaseName() {
            return this.databaseName;
        }

        @Override
        public AccessMode mode() {
            return this.mode;
        }

        @Override
        public Bookmark rediscoveryBookmark() {
            return this.rediscoveryBookmark;
        }
    }
}

