/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.driver.internal.messaging.request;

import java.util.Collections;
import java.util.Map;
import org.neo4j.driver.Value;
import org.neo4j.driver.internal.messaging.Message;

public class RunMessage
implements Message {
    public static final byte SIGNATURE = 16;
    private final String query;
    private final Map<String, Value> parameters;

    public RunMessage(String query2) {
        this(query2, Collections.emptyMap());
    }

    public RunMessage(String query2, Map<String, Value> parameters) {
        this.query = query2;
        this.parameters = parameters;
    }

    public String query() {
        return this.query;
    }

    public Map<String, Value> parameters() {
        return this.parameters;
    }

    @Override
    public byte signature() {
        return 16;
    }

    public String toString() {
        return String.format("RUN \"%s\" %s", this.query, this.parameters);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RunMessage that = (RunMessage)o;
        return !(this.parameters == null ? that.parameters != null : !this.parameters.equals(that.parameters)) && !(this.query == null ? that.query != null : !this.query.equals(that.query));
    }

    public int hashCode() {
        int result = this.query != null ? this.query.hashCode() : 0;
        result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
        return result;
    }
}

