/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.spark.writer;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.locks.LockSupport;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.StructType;
import org.neo4j.driver.Bookmark;
import org.neo4j.driver.Result;
import org.neo4j.driver.Session;
import org.neo4j.driver.Transaction;
import org.neo4j.driver.Values;
import org.neo4j.driver.exceptions.ClientException;
import org.neo4j.driver.exceptions.Neo4jException;
import org.neo4j.driver.exceptions.ServiceUnavailableException;
import org.neo4j.driver.summary.ResultSummary;
import org.neo4j.driver.summary.SummaryCounters;
import org.neo4j.spark.service.MappingService;
import org.neo4j.spark.service.Neo4jQueryService;
import org.neo4j.spark.service.Neo4jQueryStrategy$;
import org.neo4j.spark.service.Neo4jQueryWriteStrategy;
import org.neo4j.spark.service.Neo4jWriteMappingStrategy;
import org.neo4j.spark.util.DriverCache;
import org.neo4j.spark.util.Neo4jOptions;
import org.neo4j.spark.util.Neo4jUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.LinkedHashSet;
import scala.collection.mutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.Null$;

@ScalaSignature(bytes="\u0006\u0001\u0005=g!B\u0001\u0003\u0003\u0003Y!A\u0004\"bg\u0016$\u0015\r^1Xe&$XM\u001d\u0006\u0003\u0007\u0011\taa\u001e:ji\u0016\u0014(BA\u0003\u0007\u0003\u0015\u0019\b/\u0019:l\u0015\t9\u0001\"A\u0003oK>$$NC\u0001\n\u0003\ry'oZ\u0002\u0001'\r\u0001AB\u0005\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\u0011\u0005MIR\"\u0001\u000b\u000b\u0005U1\u0012\u0001C5oi\u0016\u0014h.\u00197\u000b\u0005\u00159\"B\u0001\r\t\u0003\u0019\t\u0007/Y2iK&\u0011!\u0004\u0006\u0002\b\u0019><w-\u001b8h\u0011!a\u0002A!A!\u0002\u0013i\u0012!\u00026pE&#\u0007C\u0001\u0010\"\u001d\tiq$\u0003\u0002!\u001d\u00051\u0001K]3eK\u001aL!AI\u0012\u0003\rM#(/\u001b8h\u0015\t\u0001c\u0002\u0003\u0005&\u0001\t\u0005\t\u0015!\u0003'\u0003-\u0001\u0018M\u001d;ji&|g.\u00133\u0011\u000559\u0013B\u0001\u0015\u000f\u0005\rIe\u000e\u001e\u0005\tU\u0001\u0011\t\u0011)A\u0005W\u0005Q1\u000f\u001e:vGR$\u0016\u0010]3\u0011\u00051\nT\"A\u0017\u000b\u00059z\u0013!\u0002;za\u0016\u001c(B\u0001\u0019\u0017\u0003\r\u0019\u0018\u000f\\\u0005\u0003e5\u0012!b\u0015;sk\u000e$H+\u001f9f\u0011!!\u0004A!A!\u0002\u0013)\u0014\u0001C:bm\u0016lu\u000eZ3\u0011\u0005Y:T\"A\u0018\n\u0005az#\u0001C*bm\u0016lu\u000eZ3\t\u0011i\u0002!\u0011!Q\u0001\nm\nqa\u001c9uS>t7\u000f\u0005\u0002=\u007f5\tQH\u0003\u0002?\t\u0005!Q\u000f^5m\u0013\t\u0001UH\u0001\u0007OK>$$n\u00149uS>t7\u000f\u0003\u0005C\u0001\t\u0005\t\u0015!\u0003D\u00031\u00198M]5qiJ+7/\u001e7u!\r!\u0005JS\u0007\u0002\u000b*\u0011aH\u0012\u0006\u0002\u000f\u0006!!.\u0019<b\u0013\tIUI\u0001\u0003MSN$\b\u0003\u0002#L;1I!\u0001T#\u0003\u00075\u000b\u0007\u000fC\u0003O\u0001\u0011\u0005q*\u0001\u0004=S:LGO\u0010\u000b\b!J\u001bF+\u0016,X!\t\t\u0006!D\u0001\u0003\u0011\u0015aR\n1\u0001\u001e\u0011\u0015)S\n1\u0001'\u0011\u0015QS\n1\u0001,\u0011\u0015!T\n1\u00016\u0011\u0015QT\n1\u0001<\u0011\u0015\u0011U\n1\u0001D\u0011\u001dI\u0006A1A\u0005\ni\u000b\u0001e\u0015+P!B+Ei\u0018+I%\u0016\u000bEiX#Y\u0007\u0016\u0003F+S(O?6+5kU!H\u000bV\t1\f\u0005\u0002]?6\tQL\u0003\u0002_\r\u0006!A.\u00198h\u0013\t\u0011S\f\u0003\u0004b\u0001\u0001\u0006IaW\u0001\"'R{\u0005\u000bU#E?RC%+R!E?\u0016C6)\u0012)U\u0013>su,T#T'\u0006;U\t\t\u0005\bG\u0002\u0011\r\u0011\"\u0003e\u0003-!'/\u001b<fe\u000e\u000b7\r[3\u0016\u0003\u0015\u0004\"\u0001\u00104\n\u0005\u001dl$a\u0003#sSZ,'oQ1dQ\u0016Da!\u001b\u0001!\u0002\u0013)\u0017\u0001\u00043sSZ,'oQ1dQ\u0016\u0004\u0003\"C6\u0001\u0001\u0004\u0005\r\u0011\"\u0003m\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u0016\u00035\u0004\"A\\9\u000e\u0003=T!\u0001\u001d\u0004\u0002\r\u0011\u0014\u0018N^3s\u0013\t\u0011xNA\u0006Ue\u0006t7/Y2uS>t\u0007\"\u0003;\u0001\u0001\u0004\u0005\r\u0011\"\u0003v\u0003=!(/\u00198tC\u000e$\u0018n\u001c8`I\u0015\fHC\u0001<z!\tiq/\u0003\u0002y\u001d\t!QK\\5u\u0011\u001dQ8/!AA\u00025\f1\u0001\u001f\u00132\u0011\u0019a\b\u0001)Q\u0005[\u0006aAO]1og\u0006\u001cG/[8oA!Ia\u0010\u0001a\u0001\u0002\u0004%Ia`\u0001\bg\u0016\u001c8/[8o+\t\t\t\u0001E\u0002o\u0003\u0007I1!!\u0002p\u0005\u001d\u0019Vm]:j_:D1\"!\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\f\u0005Y1/Z:tS>tw\fJ3r)\r1\u0018Q\u0002\u0005\nu\u0006\u001d\u0011\u0011!a\u0001\u0003\u0003A\u0001\"!\u0005\u0001A\u0003&\u0011\u0011A\u0001\tg\u0016\u001c8/[8oA!I\u0011Q\u0003\u0001C\u0002\u0013%\u0011qC\u0001\u000f[\u0006\u0004\b/\u001b8h'\u0016\u0014h/[2f+\t\tI\u0002E\u0004\u0002\u001c\u0005\u0005\u0012Q\u0005&\u000e\u0005\u0005u!bAA\u0010\t\u000591/\u001a:wS\u000e,\u0017\u0002BA\u0012\u0003;\u0011a\"T1qa&twmU3sm&\u001cW\r\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tYcL\u0001\tG\u0006$\u0018\r\\=ti&!\u0011qFA\u0015\u0005-Ie\u000e^3s]\u0006d'k\\<\t\u0011\u0005M\u0002\u0001)A\u0005\u00033\tq\"\\1qa&twmU3sm&\u001cW\r\t\u0005\n\u0003o\u0001!\u0019!C\u0005\u0003s\tQAY1uG\",\"!a\u000f\u0011\t\u0011C\u0015Q\b\t\u0006\t.k\u0012q\b\t\u00049\u0006\u0005\u0013bAA\";\n1qJ\u00196fGRD\u0001\"a\u0012\u0001A\u0003%\u00111H\u0001\u0007E\u0006$8\r\u001b\u0011\t\u0013\u0005-\u0003A1A\u0005\n\u00055\u0013a\u0002:fiJLWm]\u000b\u0003\u0003\u001f\u0002B!!\u0015\u0002X5\u0011\u00111\u000b\u0006\u0004\u0003+*\u0015AC2p]\u000e,(O]3oi&!\u0011\u0011LA*\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"D\u0001\"!\u0018\u0001A\u0003%\u0011qJ\u0001\te\u0016$(/[3tA!I\u0011\u0011\r\u0001C\u0002\u0013%\u00111M\u0001\u0006cV,'/_\u000b\u0002;!9\u0011q\r\u0001!\u0002\u0013i\u0012AB9vKJL\b\u0005C\u0005\u0002l\u0001\u0011\r\u0011\"\u0003\u0002n\u0005I!m\\8l[\u0006\u00148n]\u000b\u0003\u0003_\u0002b!!\u001d\u0002|\u0005}TBAA:\u0015\u0011\t)(a\u001e\u0002\u000f5,H/\u00192mK*\u0019\u0011\u0011\u0010\b\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0003\u0002~\u0005M$aA*fiB\u0019a.!!\n\u0007\u0005\ruN\u0001\u0005C_>\\W.\u0019:l\u0011!\t9\t\u0001Q\u0001\n\u0005=\u0014A\u00032p_.l\u0017M]6tA!9\u00111\u0012\u0001\u0005\u0002\u00055\u0015!B<sSR,Gc\u0001<\u0002\u0010\"A\u0011\u0011SAE\u0001\u0004\t)#\u0001\u0004sK\u000e|'\u000f\u001a\u0005\b\u0003+\u0003A\u0011BAL\u0003)9(/\u001b;f\u0005\u0006$8\r\u001b\u000b\u0002m\"9\u00111\u0014\u0001\u0005\n\u0005u\u0015\u0001\u00067pO\u0006sG\r\u00165s_^,\u0005pY3qi&|g\u000eF\u0002w\u0003?C\u0001\"!)\u0002\u001a\u0002\u0007\u00111U\u0001\u0002KB!\u0011QUA[\u001d\u0011\t9+!-\u000f\t\u0005%\u0016qV\u0007\u0003\u0003WS1!!,\u000b\u0003\u0019a$o\\8u}%\tq\"C\u0002\u00024:\tq\u0001]1dW\u0006<W-\u0003\u0003\u00028\u0006e&!C#yG\u0016\u0004H/[8o\u0015\r\t\u0019L\u0004\u0005\b\u0003{\u0003A\u0011AA`\u0003\u0019\u0019w.\\7jiR\u0011\u0011\u0011\u0019\t\u0004\u001b\u0005\r\u0017bAAc\u001d\t!a*\u001e7m\u0011\u001d\tI\r\u0001C\u0001\u0003/\u000bQ!\u00192peRDq!!4\u0001\t#\t9*A\u0003dY>\u001cX\r")
public abstract class BaseDataWriter
implements Logging {
    private final String jobId;
    private final int partitionId;
    private final StructType structType;
    private final Neo4jOptions options;
    private final List<java.util.Map<String, Object>> scriptResult;
    private final String STOPPED_THREAD_EXCEPTION_MESSAGE;
    private final DriverCache driverCache;
    private Transaction transaction;
    private Session session;
    private final MappingService<InternalRow, java.util.Map<String, Object>> mappingService;
    private final List<java.util.Map<String, Object>> batch;
    private final CountDownLatch retries;
    private final String query;
    private final Set<Bookmark> bookmarks;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String logName() {
        return Logging.class.logName((Logging)this);
    }

    public Logger log() {
        return Logging.class.log((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.class.logInfo((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.class.logDebug((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.class.logTrace((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.class.logWarning((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.class.logError((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.class.logInfo((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.class.logDebug((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.class.logTrace((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.class.logWarning((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.class.logError((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.class.isTraceEnabled((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.class.initializeLogIfNecessary((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.class.initializeLogIfNecessary$default$2((Logging)this);
    }

    private String STOPPED_THREAD_EXCEPTION_MESSAGE() {
        return this.STOPPED_THREAD_EXCEPTION_MESSAGE;
    }

    private DriverCache driverCache() {
        return this.driverCache;
    }

    private Transaction transaction() {
        return this.transaction;
    }

    private void transaction_$eq(Transaction x$1) {
        this.transaction = x$1;
    }

    private Session session() {
        return this.session;
    }

    private void session_$eq(Session x$1) {
        this.session = x$1;
    }

    private MappingService<InternalRow, java.util.Map<String, Object>> mappingService() {
        return this.mappingService;
    }

    private List<java.util.Map<String, Object>> batch() {
        return this.batch;
    }

    private CountDownLatch retries() {
        return this.retries;
    }

    private String query() {
        return this.query;
    }

    private Set<Bookmark> bookmarks() {
        return this.bookmarks;
    }

    public void write(InternalRow record) {
        this.batch().add(this.mappingService().convert(record, this.structType));
        if (this.batch().size() == this.options.transactionMetadata().batchSize()) {
            this.writeBatch();
        }
    }

    private void writeBatch() {
        block7: {
            try {
                if (this.session() == null || !this.session().isOpen()) {
                    this.session_$eq(this.driverCache().getOrCreate().session(this.options.session().toNeo4jSession((Seq<Bookmark>)this.bookmarks().toSeq())));
                }
                if (this.transaction() == null || !this.transaction().isOpen()) {
                    this.transaction_$eq(this.session().beginTransaction());
                }
                this.log().info(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Writing a batch of ", " elements to Neo4j,\n           |for jobId=", " and partitionId=", "\n           |with query: ", "\n           |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.batch().size()), this.jobId, BoxesRunTime.boxToInteger((int)this.partitionId), this.query()})))).stripMargin());
                Result result = this.transaction().run(this.query(), Values.value((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Neo4jQueryStrategy$.MODULE$.VARIABLE_EVENTS()), this.batch()), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)Neo4jQueryStrategy$.MODULE$.VARIABLE_SCRIPT_RESULT()), this.scriptResult)}))).asJava()));
                if (this.log().isDebugEnabled()) {
                    ResultSummary summary = result.consume();
                    SummaryCounters counters = summary.counters();
                    this.log().debug(new StringOps(Predef$.MODULE$.augmentString(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Batch saved into Neo4j data with:\n             | - nodes created: ", "\n             | - nodes deleted: ", "\n             | - relationships created: ", "\n             | - relationships deleted: ", "\n             | - properties set: ", "\n             | - labels added: ", "\n             | - labels removed: ", "\n             |"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)counters.nodesCreated()), BoxesRunTime.boxToInteger((int)counters.nodesDeleted()), BoxesRunTime.boxToInteger((int)counters.relationshipsCreated()), BoxesRunTime.boxToInteger((int)counters.relationshipsDeleted()), BoxesRunTime.boxToInteger((int)counters.propertiesSet()), BoxesRunTime.boxToInteger((int)counters.labelsAdded()), BoxesRunTime.boxToInteger((int)counters.labelsRemoved())})))).stripMargin());
                }
                this.transaction().commit();
                this.bookmarks().add((Object)this.session().lastBookmark());
                Neo4jUtil$.MODULE$.closeSafety(this.transaction(), Neo4jUtil$.MODULE$.closeSafety$default$2());
                this.batch().clear();
            }
            catch (Exception exception) {
                this.logAndThrowException(exception);
            }
            catch (Neo4jException neo4jException) {
                String code = neo4jException.code();
                if (Neo4jUtil$.MODULE$.isRetryableException(neo4jException) && !this.options.transactionMetadata().failOnTransactionCodes().contains((Object)code) && this.retries().getCount() > 0L) {
                    this.retries().countDown();
                    this.log().info(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Matched Neo4j transient exception next retry is ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToLong((long)((long)this.options.transactionMetadata().retries() - this.retries().getCount()))})));
                    this.close();
                    LockSupport.parkNanos(Duration.ofMillis(this.options.transactionMetadata().retryTimeout()).toNanos());
                    this.writeBatch();
                    break block7;
                }
                this.logAndThrowException(neo4jException);
            }
        }
    }

    private void logAndThrowException(Exception e) {
        if (e instanceof ServiceUnavailableException) {
            String string = e.getMessage();
            String string2 = this.STOPPED_THREAD_EXCEPTION_MESSAGE();
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                this.logWarning((Function0<String>)new Serializable(this, e){
                    public static final long serialVersionUID = 0L;
                    private final Exception e$1;

                    public final String apply() {
                        return this.e$1.getMessage();
                    }
                    {
                        this.e$1 = e$1;
                    }
                });
                return;
            }
        }
        if (e instanceof ClientException) {
            this.log().error(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Cannot commit the transaction because: ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{e.getMessage()})));
        } else {
            this.log().error("Cannot commit the transaction because the following exception", (Throwable)e);
        }
        throw e;
    }

    public Null$ commit() {
        this.writeBatch();
        this.close();
        return null;
    }

    public void abort() {
        if (this.transaction() != null && this.transaction().isOpen()) {
            try {
                this.transaction().rollback();
            }
            catch (Throwable throwable) {
                this.log().warn("Cannot rollback the transaction because of the following exception", throwable);
            }
        }
        this.close();
    }

    public void close() {
        Neo4jUtil$.MODULE$.closeSafety(this.transaction(), this.log());
        Neo4jUtil$.MODULE$.closeSafety(this.session(), this.log());
    }

    public BaseDataWriter(String jobId, int partitionId, StructType structType, SaveMode saveMode, Neo4jOptions options, List<java.util.Map<String, Object>> scriptResult) {
        this.jobId = jobId;
        this.partitionId = partitionId;
        this.structType = structType;
        this.options = options;
        this.scriptResult = scriptResult;
        Logging.class.$init$((Logging)this);
        this.STOPPED_THREAD_EXCEPTION_MESSAGE = "Connection to the database terminated. Thread interrupted while committing the transaction";
        this.driverCache = new DriverCache(options.connection(), jobId);
        this.mappingService = new MappingService<InternalRow, java.util.Map<String, Object>>(new Neo4jWriteMappingStrategy(options), options);
        this.batch = new ArrayList<java.util.Map<String, Object>>();
        this.retries = new CountDownLatch(options.transactionMetadata().retries());
        this.query = new Neo4jQueryService(options, new Neo4jQueryWriteStrategy(saveMode)).createQuery();
        this.bookmarks = new LinkedHashSet();
    }
}

