/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.spark.writer;

import java.util.List;
import java.util.Map;
import org.apache.spark.sql.SaveMode;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.sources.v2.DataSourceOptions;
import org.apache.spark.sql.sources.v2.writer.DataSourceWriter;
import org.apache.spark.sql.sources.v2.writer.DataWriterFactory;
import org.apache.spark.sql.sources.v2.writer.WriterCommitMessage;
import org.apache.spark.sql.types.StructType;
import org.neo4j.driver.AccessMode;
import org.neo4j.spark.service.SchemaService;
import org.neo4j.spark.service.SchemaService$;
import org.neo4j.spark.util.DriverCache;
import org.neo4j.spark.util.Neo4jOptions;
import org.neo4j.spark.util.Neo4jOptions$;
import org.neo4j.spark.util.ValidateWrite;
import org.neo4j.spark.util.ValidateWrite$;
import org.neo4j.spark.util.Validation;
import org.neo4j.spark.util.Validations$;
import org.neo4j.spark.writer.Neo4jDataWriterFactory;
import scala.Predef$;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005Ea\u0001B\u0001\u0003\u0001-\u0011QCT3pi)$\u0015\r^1T_V\u00148-Z,sSR,'O\u0003\u0002\u0004\t\u00051qO]5uKJT!!\u0002\u0004\u0002\u000bM\u0004\u0018M]6\u000b\u0005\u001dA\u0011!\u00028f_RR'\"A\u0005\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001aA\u0003\u0005\u0002\u000e%5\taB\u0003\u0002\u0010!\u0005!A.\u00198h\u0015\u0005\t\u0012\u0001\u00026bm\u0006L!a\u0005\b\u0003\r=\u0013'.Z2u!\t)\u0002%D\u0001\u0017\u0015\t\u0019qC\u0003\u0002\u00193\u0005\u0011aO\r\u0006\u00035m\tqa]8ve\u000e,7O\u0003\u0002\u001d;\u0005\u00191/\u001d7\u000b\u0005\u0015q\"BA\u0010\t\u0003\u0019\t\u0007/Y2iK&\u0011\u0011E\u0006\u0002\u0011\t\u0006$\u0018mU8ve\u000e,wK]5uKJD\u0001b\t\u0001\u0003\u0002\u0003\u0006I\u0001J\u0001\u0006U>\u0014\u0017\n\u001a\t\u0003K-r!AJ\u0015\u000e\u0003\u001dR\u0011\u0001K\u0001\u0006g\u000e\fG.Y\u0005\u0003U\u001d\na\u0001\u0015:fI\u00164\u0017B\u0001\u0017.\u0005\u0019\u0019FO]5oO*\u0011!f\n\u0005\t_\u0001\u0011\t\u0011)A\u0005a\u0005Q1\u000f\u001e:vGR$\u0016\u0010]3\u0011\u0005E\"T\"\u0001\u001a\u000b\u0005MZ\u0012!\u0002;za\u0016\u001c\u0018BA\u001b3\u0005)\u0019FO];diRK\b/\u001a\u0005\to\u0001\u0011\t\u0011)A\u0005q\u0005A1/\u0019<f\u001b>$W\r\u0005\u0002:u5\t1$\u0003\u0002<7\tA1+\u0019<f\u001b>$W\r\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0003\u001dy\u0007\u000f^5p]N\u0004\"a\u0010!\u000e\u0003]I!!Q\f\u0003#\u0011\u000bG/Y*pkJ\u001cWm\u00149uS>t7\u000fC\u0003D\u0001\u0011\u0005A)\u0001\u0004=S:LGO\u0010\u000b\u0006\u000b\u001eC\u0015J\u0013\t\u0003\r\u0002i\u0011A\u0001\u0005\u0006G\t\u0003\r\u0001\n\u0005\u0006_\t\u0003\r\u0001\r\u0005\u0006o\t\u0003\r\u0001\u000f\u0005\u0006{\t\u0003\rA\u0010\u0005\b\u0019\u0002\u0011\r\u0011\"\u0003N\u0003)y\u0007\u000f^5p]Nl\u0015\r]\u000b\u0002\u001dB!qJ\u0015+U\u001b\u0005\u0001&BA)\u0011\u0003\u0011)H/\u001b7\n\u0005M\u0003&aA'baB\u0011Q\"V\u0005\u0003Y9Aaa\u0016\u0001!\u0002\u0013q\u0015aC8qi&|gn]'ba\u0002Bq!\u0017\u0001C\u0002\u0013%!,\u0001\u0007oK>$$n\u00149uS>t7/F\u0001\\!\taf,D\u0001^\u0015\t\tF!\u0003\u0002`;\naa*Z85U>\u0003H/[8og\"1\u0011\r\u0001Q\u0001\nm\u000bQB\\3pi)|\u0005\u000f^5p]N\u0004\u0003bB2\u0001\u0005\u0004%I\u0001Z\u0001\fIJLg/\u001a:DC\u000eDW-F\u0001f!\taf-\u0003\u0002h;\nYAI]5wKJ\u001c\u0015m\u00195f\u0011\u0019I\u0007\u0001)A\u0005K\u0006aAM]5wKJ\u001c\u0015m\u00195fA!)1\u000e\u0001C!Y\u0006\u00192M]3bi\u0016<&/\u001b;fe\u001a\u000b7\r^8ssR\tQ\u000eE\u0002\u0016]BL!a\u001c\f\u0003#\u0011\u000bG/Y,sSR,'OR1di>\u0014\u0018\u0010\u0005\u0002ri6\t!O\u0003\u0002t7\u0005A1-\u0019;bYf\u001cH/\u0003\u0002ve\nY\u0011J\u001c;fe:\fGNU8x\u0011\u00159\b\u0001\"\u0011y\u0003\u0019\u0019w.\\7jiR\u0011\u0011\u0010 \t\u0003MiL!a_\u0014\u0003\tUs\u0017\u000e\u001e\u0005\u0006{Z\u0004\rA`\u0001\t[\u0016\u001c8/Y4fgB!ae`A\u0002\u0013\r\t\ta\n\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0004+\u0005\u0015\u0011bAA\u0004-\t\u0019rK]5uKJ\u001cu.\\7ji6+7o]1hK\"9\u00111\u0002\u0001\u0005B\u00055\u0011!B1c_J$HcA=\u0002\u0010!1Q0!\u0003A\u0002y\u0004")
public class Neo4jDataSourceWriter
implements DataSourceWriter {
    private final String jobId;
    private final StructType structType;
    private final SaveMode saveMode;
    private final Map<String, String> optionsMap;
    private final Neo4jOptions neo4jOptions;
    private final DriverCache driverCache;

    private Map<String, String> optionsMap() {
        return this.optionsMap;
    }

    private Neo4jOptions neo4jOptions() {
        return this.neo4jOptions;
    }

    private DriverCache driverCache() {
        return this.driverCache;
    }

    public DataWriterFactory<InternalRow> createWriterFactory() {
        SchemaService schemaService = new SchemaService(this.neo4jOptions(), this.driverCache(), SchemaService$.MODULE$.$lessinit$greater$default$3());
        schemaService.createOptimizations();
        List<Map<String, Object>> scriptResult = schemaService.execute((Seq<String>)Predef$.MODULE$.wrapRefArray((Object[])this.neo4jOptions().script()));
        schemaService.close();
        return new Neo4jDataWriterFactory(this.jobId, this.structType, this.saveMode, this.neo4jOptions(), scriptResult);
    }

    public void commit(WriterCommitMessage[] messages) {
        this.driverCache().close();
    }

    public void abort(WriterCommitMessage[] messages) {
        this.driverCache().close();
    }

    public Neo4jDataSourceWriter(String jobId, StructType structType, SaveMode saveMode, DataSourceOptions options) {
        this.jobId = jobId;
        this.structType = structType;
        this.saveMode = saveMode;
        this.optionsMap = options.asMap();
        this.optionsMap().put(Neo4jOptions$.MODULE$.ACCESS_MODE(), AccessMode.WRITE.toString());
        this.neo4jOptions = new Neo4jOptions(this.optionsMap());
        Validations$.MODULE$.validate((Seq<Validation>)Predef$.MODULE$.wrapRefArray((Object[])new Validation[]{new ValidateWrite(this.neo4jOptions(), jobId, saveMode, ValidateWrite$.MODULE$.apply$default$4())}));
        this.driverCache = new DriverCache(this.neo4jOptions().connection(), jobId);
    }
}

