/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.spark.clickhouse.sink;

import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.sql.ResultSet;
import java.text.SimpleDateFormat;
import java.util.LinkedHashMap;
import java.util.Properties;
import java.util.TreeMap;
import java.util.concurrent.ThreadLocalRandom;
import net.jpountz.xxhash.XXHash64;
import org.apache.commons.lang3.StringUtils;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.spark.clickhouse.sink.Clickhouse;
import org.apache.spark.sql.Row;
import ru.yandex.clickhouse.BalancedClickhouseDataSource;
import ru.yandex.clickhouse.ClickHouseConnectionImpl;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.JavaConversions$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Stream$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.matching.Regex;

public final class Clickhouse$
implements Serializable {
    public static final Clickhouse$ MODULE$;
    private final Regex arrayPattern;
    private final Regex nullablePattern;
    private final Regex lowCardinalityPattern;
    private final Regex intPattern;
    private final Regex uintPattern;
    private final Regex floatPattern;
    private final Regex decimalPattern;
    private final Regex datetime64Pattern;
    private final String distributedEngine;

    static {
        new Clickhouse$();
    }

    public Regex arrayPattern() {
        return this.arrayPattern;
    }

    public Regex nullablePattern() {
        return this.nullablePattern;
    }

    public Regex lowCardinalityPattern() {
        return this.lowCardinalityPattern;
    }

    public Regex intPattern() {
        return this.intPattern;
    }

    public Regex uintPattern() {
        return this.uintPattern;
    }

    public Regex floatPattern() {
        return this.floatPattern;
    }

    public Regex decimalPattern() {
        return this.decimalPattern;
    }

    public Regex datetime64Pattern() {
        return this.datetime64Pattern;
    }

    public String distributedEngine() {
        return this.distributedEngine;
    }

    public boolean supportOrNot(String dataType) {
        boolean bl;
        String string = dataType;
        boolean bl2 = "Date".equals(string) ? true : ("DateTime".equals(string) ? true : "String".equals(string));
        if (bl2) {
            bl = true;
        } else {
            Option option;
            Option option2;
            Option option3;
            Option option4;
            Option option5;
            Option option6;
            Option option7;
            Option option8 = this.nullablePattern().unapplySeq((CharSequence)string);
            boolean bl3 = !option8.isEmpty() && option8.get() != null && ((LinearSeqOptimized)option8.get()).lengthCompare(1) == 0 ? true : (!(option7 = this.floatPattern().unapplySeq((CharSequence)string)).isEmpty() && option7.get() != null && ((LinearSeqOptimized)option7.get()).lengthCompare(1) == 0 ? true : (!(option6 = this.intPattern().unapplySeq((CharSequence)string)).isEmpty() && option6.get() != null && ((LinearSeqOptimized)option6.get()).lengthCompare(1) == 0 ? true : (!(option5 = this.uintPattern().unapplySeq((CharSequence)string)).isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(1) == 0 ? true : !(option4 = this.datetime64Pattern().unapplySeq((CharSequence)string)).isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0)));
            bl = bl3 ? true : (!(option3 = this.arrayPattern().unapplySeq((CharSequence)string)).isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0 ? true : (!(option2 = this.lowCardinalityPattern().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0 ? true : !(option = this.decimalPattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0));
        }
        return bl;
    }

    public List<Clickhouse.HostAndPort> parseHost(String host) {
        return Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])host.split(",")).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$2) {
                return x$2.trim();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String[] apply(String x$3) {
                return x$3.split(":");
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(String.class))))).map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Clickhouse.HostAndPort apply(String[] hostAndPort) {
                return new Clickhouse.HostAndPort(hostAndPort[0], hostAndPort[1]);
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Clickhouse.HostAndPort.class)))).toList();
    }

    public ListBuffer<Clickhouse.Shard> getClusterShardList(ClickHouseConnectionImpl conn, String clusterName, String database, List<Clickhouse.HostAndPort> hosts) {
        ResultSet rs = conn.createStatement().executeQuery(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select shard_num,shard_weight,replica_num,host_name,host_address,"})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"port from system.clusters where cluster = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{clusterName}))).toString());
        ListBuffer nodeList = (ListBuffer)ListBuffer$.MODULE$.apply((Seq)Nil$.MODULE$);
        String defaultPort = ((Clickhouse.HostAndPort)hosts.head()).port();
        while (rs.next()) {
            String hostname = rs.getString(4);
            String hostAddress = rs.getString(5);
            String port = (String)((TraversableLike)hosts.toStream().filter((Function1)new Serializable(hostname, hostAddress){
                public static final long serialVersionUID = 0L;
                private final String hostname$1;
                private final String hostAddress$1;

                public final boolean apply(Clickhouse.HostAndPort hostAndPort) {
                    return this.hostname$1.equals(hostAndPort.host()) || this.hostAddress$1.equals(hostAndPort.host());
                }
                {
                    this.hostname$1 = hostname$1;
                    this.hostAddress$1 = hostAddress$1;
                }
            }).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Clickhouse.HostAndPort x$4) {
                    return x$4.port();
                }
            }, Stream$.MODULE$.canBuildFrom())).headOption().getOrElse((Function0)new Serializable(defaultPort){
                public static final long serialVersionUID = 0L;
                private final String defaultPort$1;

                public final String apply() {
                    return this.defaultPort$1;
                }
                {
                    this.defaultPort$1 = defaultPort$1;
                }
            });
            nodeList.$plus$eq((Object)new Clickhouse.Shard(rs.getInt(1), rs.getInt(2), rs.getInt(3), hostname, hostAddress, port, database));
        }
        return nodeList;
    }

    public Clickhouse.DistributedEngine getClickHouseDistributedTable(ClickHouseConnectionImpl conn, String database, String table) {
        Clickhouse.DistributedEngine distributedEngine;
        ResultSet rs = conn.createStatement().executeQuery(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"select engine_full from system.tables where "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"database = '", "' and name = '", "' and engine = '", "'"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{database, table, this.distributedEngine()}))).toString());
        if (rs.next()) {
            String engineFull = rs.getString(1);
            String[] infos = (String[])Predef$.MODULE$.refArrayOps((Object[])engineFull.substring(12).split(",")).map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(String s) {
                    return s.replaceAll("'", "");
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
            distributedEngine = new Clickhouse.DistributedEngine(infos[0], infos[1].trim(), infos[2].replaceAll("\\)", "").trim());
        } else {
            distributedEngine = null;
        }
        return distributedEngine;
    }

    public Clickhouse.Shard getRowShard(boolean splitMode, TreeMap<Object, Clickhouse.Shard> shards, String shardKey, String shardKeyType, int shardWeightCount, ThreadLocalRandom random, XXHash64 hashInstance, Row row) {
        Clickhouse.Shard shard;
        if (splitMode) {
            if (StringUtils.isEmpty((CharSequence)shardKey) || Predef$.MODULE$.refArrayOps((Object[])row.schema().fieldNames()).indexOf((Object)shardKey) == -1) {
                shard = shards.lowerEntry(BoxesRunTime.boxToInteger((int)(random.nextInt(shardWeightCount) + 1))).getValue();
            } else {
                int fieldIndex = row.fieldIndex(shardKey);
                if (row.isNullAt(fieldIndex)) {
                    shard = shards.lowerEntry(BoxesRunTime.boxToInteger((int)(random.nextInt(shardWeightCount) + 1))).getValue();
                } else {
                    int offset = 0;
                    String string = shardKeyType;
                    Option option = this.floatPattern().unapplySeq((CharSequence)string);
                    if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                        offset = (int)row.getFloat(fieldIndex) % shardWeightCount;
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    } else {
                        Option option2;
                        Option option3 = this.intPattern().unapplySeq((CharSequence)string);
                        boolean bl = !option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0 ? true : !(option2 = this.uintPattern().unapplySeq((CharSequence)string)).isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0;
                        if (bl) {
                            offset = row.getInt(fieldIndex) % shardWeightCount;
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        } else {
                            Option option4 = this.decimalPattern().unapplySeq((CharSequence)string);
                            if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(1) == 0) {
                                offset = row.getDecimal(fieldIndex).toBigInteger().mod(BigInteger.valueOf(shardWeightCount)).intValue();
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            } else {
                                offset = (int)(hashInstance.hash(ByteBuffer.wrap(row.getString(fieldIndex).getBytes()), 0L) & Long.MAX_VALUE % (long)shardWeightCount);
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            }
                        }
                    }
                    shard = shards.lowerEntry(BoxesRunTime.boxToInteger((int)(offset + 1))).getValue();
                }
            }
        } else {
            shard = (Clickhouse.Shard)((Tuple2)JavaConversions$.MODULE$.mapAsScalaMap(shards).head())._2();
        }
        return shard;
    }

    public CheckResult acceptedClickHouseSchema(List<String> fields, Map<String, String> tableSchema, String table) {
        List nonSupportedType;
        List nonExistsFields = (List)((TraversableLike)fields.map((Function1)new Serializable(tableSchema){
            public static final long serialVersionUID = 0L;
            private final Map tableSchema$1;

            public final Tuple2<String, Object> apply(String field) {
                return new Tuple2((Object)field, (Object)BoxesRunTime.boxToBoolean((boolean)this.tableSchema$1.contains((Object)field)));
            }
            {
                this.tableSchema$1 = tableSchema$1;
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    boolean exist = tuple2._2$mcZ$sp();
                    boolean bl = !exist;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        return nonExistsFields.nonEmpty() ? CheckResult.error((String)new StringBuilder().append((Object)"field ").append((Object)((TraversableOnce)nonExistsFields.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> option) {
                return new StringBuilder().append((Object)"[").append(option).append((Object)"]").toString();
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ")).append((Object)" not exist in table ").append((Object)table).toString()) : ((nonSupportedType = (List)((TraversableLike)fields.map((Function1)new Serializable(tableSchema){
            public static final long serialVersionUID = 0L;
            private final Map tableSchema$1;

            public final Tuple2<String, Object> apply(String field) {
                return new Tuple2(this.tableSchema$1.apply((Object)field), (Object)BoxesRunTime.boxToBoolean((boolean)Clickhouse$.MODULE$.supportOrNot((String)this.tableSchema$1.apply((Object)field))));
            }
            {
                this.tableSchema$1 = tableSchema$1;
            }
        }, List$.MODULE$.canBuildFrom())).filter((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<String, Object> x0$2) {
                Tuple2<String, Object> tuple2 = x0$2;
                if (tuple2 != null) {
                    boolean exist = tuple2._2$mcZ$sp();
                    boolean bl = !exist;
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        })).nonEmpty() ? CheckResult.error((String)new StringBuilder().append((Object)"clickHouse data type ").append((Object)((TraversableOnce)nonSupportedType.map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<String, Object> option) {
                return new StringBuilder().append((Object)"[").append(option).append((Object)"]").toString();
            }
        }, List$.MODULE$.canBuildFrom())).mkString(", ")).append((Object)" not support in current version.").toString()) : CheckResult.success());
    }

    public LinkedHashMap<String, String> getClickHouseSchema(ClickHouseConnectionImpl conn, String table) {
        String sql = String.format("desc %s", table);
        ResultSet resultSet = conn.createStatement().executeQuery(sql);
        LinkedHashMap<String, String> schema = new LinkedHashMap<String, String>();
        while (resultSet.next()) {
            schema.put(resultSet.getString(1), resultSet.getString(2));
        }
        return schema;
    }

    public Object getDefaultValue(String fieldType) {
        Object object;
        block5: {
            Option option;
            String string;
            while (true) {
                String lowCardinalityType;
                boolean bl;
                if (bl = "DateTime".equals(string = fieldType) ? true : ("Date".equals(string) ? true : "String".equals(string))) {
                    object = this.renderStringDefault(fieldType);
                    break block5;
                }
                Option option2 = this.datetime64Pattern().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(1) == 0) {
                    object = this.renderStringDefault(fieldType);
                    break block5;
                }
                Option option3 = this.datetime64Pattern().unapplySeq((CharSequence)string);
                if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                    object = this.renderStringDefault(fieldType);
                    break block5;
                }
                boolean bl2 = "Int8".equals(string) ? true : ("UInt8".equals(string) ? true : ("Int16".equals(string) ? true : ("Int32".equals(string) ? true : ("UInt32".equals(string) ? true : ("UInt16".equals(string) ? true : ("UInt64".equals(string) ? true : ("Int64".equals(string) ? true : ("Float32".equals(string) ? true : "Float64".equals(string)))))))));
                if (bl2) {
                    object = new Integer(0);
                    break block5;
                }
                Option option4 = this.lowCardinalityPattern().unapplySeq((CharSequence)string);
                if (option4.isEmpty() || option4.get() == null || ((LinearSeqOptimized)option4.get()).lengthCompare(1) != 0) break;
                fieldType = lowCardinalityType = (String)((LinearSeqOptimized)option4.get()).apply(0);
            }
            Option option5 = this.arrayPattern().unapplySeq((CharSequence)string);
            boolean bl = !option5.isEmpty() && option5.get() != null && ((LinearSeqOptimized)option5.get()).lengthCompare(1) == 0 ? true : !(option = this.nullablePattern().unapplySeq((CharSequence)string)).isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0;
            object = bl ? null : "";
        }
        return object;
    }

    public ClickHouseConnectionImpl getClickhouseConnection(String host, String database, Properties properties) {
        String globalJdbc = String.format("jdbc:clickhouse://%s/%s", host, database);
        BalancedClickhouseDataSource balanced = new BalancedClickhouseDataSource(globalJdbc, properties);
        return (ClickHouseConnectionImpl)balanced.getConnection();
    }

    public String renderStringDefault(String fieldType) {
        String string;
        block6: {
            String string2;
            block3: {
                block5: {
                    block4: {
                        block2: {
                            string = fieldType;
                            if (!"DateTime".equals(string)) break block2;
                            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                            string2 = dateFormat.format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
                            break block3;
                        }
                        Option option = this.datetime64Pattern().unapplySeq((CharSequence)string);
                        if (option.isEmpty() || option.get() == null || ((LinearSeqOptimized)option.get()).lengthCompare(1) != 0) break block4;
                        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
                        string2 = dateFormat.format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
                        break block3;
                    }
                    if (!"Date".equals(string)) break block5;
                    SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                    string2 = dateFormat.format(BoxesRunTime.boxToLong((long)System.currentTimeMillis()));
                    break block3;
                }
                if (!"String".equals(string)) break block6;
                string2 = "";
            }
            return string2;
        }
        throw new MatchError((Object)string);
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Clickhouse$() {
        MODULE$ = this;
        this.arrayPattern = new StringOps(Predef$.MODULE$.augmentString("(Array.*)")).r();
        this.nullablePattern = new StringOps(Predef$.MODULE$.augmentString("Nullable\\((.*)\\)")).r();
        this.lowCardinalityPattern = new StringOps(Predef$.MODULE$.augmentString("LowCardinality\\((.*)\\)")).r();
        this.intPattern = new StringOps(Predef$.MODULE$.augmentString("(Int.*)")).r();
        this.uintPattern = new StringOps(Predef$.MODULE$.augmentString("(UInt.*)")).r();
        this.floatPattern = new StringOps(Predef$.MODULE$.augmentString("(Float.*)")).r();
        this.decimalPattern = new StringOps(Predef$.MODULE$.augmentString("(Decimal.*)")).r();
        this.datetime64Pattern = new StringOps(Predef$.MODULE$.augmentString("(DateTime64\\(.*\\))")).r();
        this.distributedEngine = "Distributed";
    }
}

