/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse;

import com.google.common.base.Strings;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.sql.Array;
import java.sql.Blob;
import java.sql.CallableStatement;
import java.sql.Clob;
import java.sql.DatabaseMetaData;
import java.sql.NClob;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.SQLWarning;
import java.sql.SQLXML;
import java.sql.Savepoint;
import java.sql.Struct;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.impl.client.CloseableHttpClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.ClickHouseArray;
import ru.yandex.clickhouse.ClickHouseConnection;
import ru.yandex.clickhouse.ClickHouseDatabaseMetadata;
import ru.yandex.clickhouse.ClickHousePreparedStatement;
import ru.yandex.clickhouse.ClickHousePreparedStatementImpl;
import ru.yandex.clickhouse.ClickHouseStatement;
import ru.yandex.clickhouse.ClickHouseStatementImpl;
import ru.yandex.clickhouse.ClickhouseJdbcUrlParser;
import ru.yandex.clickhouse.domain.ClickHouseDataType;
import ru.yandex.clickhouse.except.ClickHouseUnknownException;
import ru.yandex.clickhouse.settings.ClickHouseConnectionSettings;
import ru.yandex.clickhouse.settings.ClickHouseProperties;
import ru.yandex.clickhouse.util.ClickHouseHttpClientBuilder;
import ru.yandex.clickhouse.util.LogProxy;
import ru.yandex.clickhouse.util.guava.StreamUtils;

public class ClickHouseConnectionImpl
implements ClickHouseConnection {
    private static final int DEFAULT_RESULTSET_TYPE = 1003;
    private static final Logger log = LoggerFactory.getLogger(ClickHouseConnectionImpl.class);
    private final CloseableHttpClient httpclient;
    private final ClickHouseProperties properties;
    private String url;
    private boolean closed = false;
    private TimeZone timezone;
    private volatile String serverVersion;

    public ClickHouseConnectionImpl(String url) {
        this(url, new ClickHouseProperties());
    }

    public ClickHouseConnectionImpl(String url, ClickHouseProperties properties) {
        this.url = url;
        try {
            this.properties = ClickhouseJdbcUrlParser.parse(url, properties.asProperties());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(e);
        }
        ClickHouseHttpClientBuilder clientBuilder = new ClickHouseHttpClientBuilder(this.properties);
        log.debug("Create a new connection to {}", (Object)url);
        try {
            this.httpclient = clientBuilder.buildClient();
        }
        catch (Exception e) {
            throw new IllegalStateException("cannot initialize http client", e);
        }
        this.initTimeZone(this.properties);
    }

    private void initTimeZone(ClickHouseProperties properties) {
        block8: {
            block7: {
                if (properties.isUseServerTimeZone() && !Strings.isNullOrEmpty(properties.getUseTimeZone())) {
                    throw new IllegalArgumentException(String.format("only one of %s or %s must be enabled", ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE.getKey(), ClickHouseConnectionSettings.USE_TIME_ZONE.getKey()));
                }
                if (!properties.isUseServerTimeZone() && Strings.isNullOrEmpty(properties.getUseTimeZone())) {
                    throw new IllegalArgumentException(String.format("one of %s or %s must be enabled", ClickHouseConnectionSettings.USE_SERVER_TIME_ZONE.getKey(), ClickHouseConnectionSettings.USE_TIME_ZONE.getKey()));
                }
                if (!properties.isUseServerTimeZone()) break block7;
                ResultSet rs = null;
                try {
                    this.timezone = TimeZone.getTimeZone("UTC");
                    rs = this.createStatement().executeQuery("select timezone()");
                    rs.next();
                    String timeZoneName = rs.getString(1);
                    this.timezone = TimeZone.getTimeZone(timeZoneName);
                }
                catch (SQLException e) {
                    try {
                        throw new RuntimeException(e);
                    }
                    catch (Throwable throwable) {
                        StreamUtils.close(rs);
                        throw throwable;
                    }
                }
                StreamUtils.close(rs);
                break block8;
            }
            if (!Strings.isNullOrEmpty(properties.getUseTimeZone())) {
                this.timezone = TimeZone.getTimeZone(properties.getUseTimeZone());
            }
        }
    }

    @Override
    public ClickHouseStatement createStatement() throws SQLException {
        return this.createStatement(1003);
    }

    public ClickHouseStatement createStatement(int resultSetType) throws SQLException {
        return LogProxy.wrap(ClickHouseStatement.class, new ClickHouseStatementImpl(this.httpclient, this, this.properties, resultSetType));
    }

    @Override
    @Deprecated
    public ClickHouseStatement createClickHouseStatement() throws SQLException {
        return this.createStatement();
    }

    @Override
    public TimeZone getTimeZone() {
        return this.timezone;
    }

    private ClickHouseStatement createClickHouseStatement(CloseableHttpClient httpClient) throws SQLException {
        return LogProxy.wrap(ClickHouseStatement.class, new ClickHouseStatementImpl(httpClient, this, this.properties, 1003));
    }

    public PreparedStatement createPreparedStatement(String sql, int resultSetType) throws SQLException {
        return LogProxy.wrap(PreparedStatement.class, new ClickHousePreparedStatementImpl(this.httpclient, this, this.properties, sql, this.getTimeZone(), resultSetType));
    }

    public ClickHousePreparedStatement createClickHousePreparedStatement(String sql, int resultSetType) throws SQLException {
        return LogProxy.wrap(ClickHousePreparedStatement.class, new ClickHousePreparedStatementImpl(this.httpclient, this, this.properties, sql, this.getTimeZone(), resultSetType));
    }

    @Override
    public ClickHouseStatement createStatement(int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createStatement(resultSetType, resultSetConcurrency, 2);
    }

    @Override
    public String getServerVersion() throws SQLException {
        if (this.serverVersion == null) {
            ResultSet rs = this.createStatement().executeQuery("select version()");
            rs.next();
            this.serverVersion = rs.getString(1);
            rs.close();
        }
        return this.serverVersion;
    }

    @Override
    public ClickHouseStatement createStatement(int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        if (resultSetType == 1005 || resultSetConcurrency != 1007 || resultSetHoldability != 2) {
            throw new SQLFeatureNotSupportedException();
        }
        return this.createStatement(resultSetType);
    }

    @Override
    public PreparedStatement prepareStatement(String sql) throws SQLException {
        return this.createPreparedStatement(sql, 1003);
    }

    @Override
    public CallableStatement prepareCall(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public String nativeSQL(String sql) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void setAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public boolean getAutoCommit() throws SQLException {
        return false;
    }

    @Override
    public void commit() throws SQLException {
    }

    @Override
    public void rollback() throws SQLException {
    }

    @Override
    public void close() throws SQLException {
        try {
            this.httpclient.close();
            this.closed = true;
        }
        catch (IOException e) {
            throw new ClickHouseUnknownException("HTTP client close exception", (Throwable)e, this.properties.getHost(), this.properties.getPort());
        }
    }

    @Override
    public boolean isClosed() throws SQLException {
        return this.closed;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return LogProxy.wrap(DatabaseMetaData.class, new ClickHouseDatabaseMetadata(this.url, this));
    }

    @Override
    public void setReadOnly(boolean readOnly) throws SQLException {
    }

    @Override
    public boolean isReadOnly() throws SQLException {
        return false;
    }

    @Override
    public void setCatalog(String catalog) throws SQLException {
        this.properties.setDatabase(catalog);
        URI old = URI.create(this.url.substring("jdbc:".length()));
        try {
            this.url = "jdbc:" + new URI(old.getScheme(), old.getUserInfo(), old.getHost(), old.getPort(), "/" + catalog, old.getQuery(), old.getFragment());
        }
        catch (URISyntaxException e) {
            throw new IllegalStateException(e);
        }
    }

    @Override
    public String getCatalog() throws SQLException {
        return this.properties.getDatabase();
    }

    @Override
    public void setTransactionIsolation(int level) throws SQLException {
    }

    @Override
    public int getTransactionIsolation() throws SQLException {
        return 0;
    }

    @Override
    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    @Override
    public void clearWarnings() throws SQLException {
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        return this.createPreparedStatement(sql, resultSetType);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Map<String, Class<?>> getTypeMap() throws SQLException {
        return null;
    }

    @Override
    public void setTypeMap(Map<String, Class<?>> map) throws SQLException {
    }

    @Override
    public void setHoldability(int holdability) throws SQLException {
    }

    @Override
    public int getHoldability() throws SQLException {
        return 0;
    }

    @Override
    public Savepoint setSavepoint() throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Savepoint setSavepoint(String name) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public void rollback(Savepoint savepoint) throws SQLException {
    }

    @Override
    public void releaseSavepoint(Savepoint savepoint) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        return this.createPreparedStatement(sql, resultSetType);
    }

    @Override
    public CallableStatement prepareCall(String sql, int resultSetType, int resultSetConcurrency, int resultSetHoldability) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int autoGeneratedKeys) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, int[] columnIndexes) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public PreparedStatement prepareStatement(String sql, String[] columnNames) throws SQLException {
        throw new SQLFeatureNotSupportedException();
    }

    @Override
    public Clob createClob() throws SQLException {
        return null;
    }

    @Override
    public Blob createBlob() throws SQLException {
        return null;
    }

    @Override
    public NClob createNClob() throws SQLException {
        return null;
    }

    @Override
    public SQLXML createSQLXML() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isValid(int timeout) throws SQLException {
        if (timeout < 0) {
            throw new SQLException("Timeout value mustn't be less 0");
        }
        if (this.isClosed()) {
            return false;
        }
        boolean isAnotherHttpClient = false;
        CloseableHttpClient closeableHttpClient = null;
        try {
            if (timeout == 0) {
                closeableHttpClient = this.httpclient;
            } else {
                ClickHouseProperties properties = new ClickHouseProperties(this.properties);
                properties.setConnectionTimeout((int)TimeUnit.SECONDS.toMillis(timeout));
                properties.setMaxExecutionTime(timeout);
                closeableHttpClient = new ClickHouseHttpClientBuilder(properties).buildClient();
                isAnotherHttpClient = true;
            }
            ClickHouseStatement statement = this.createClickHouseStatement(closeableHttpClient);
            statement.execute("SELECT 1");
            statement.close();
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            boolean isFailOnConnectionTimeout;
            boolean bl = isFailOnConnectionTimeout = e instanceof ConnectTimeoutException || e.getCause() instanceof ConnectTimeoutException;
            if (!isFailOnConnectionTimeout) {
                log.warn("Something had happened while validating a connection", e);
            }
            boolean bl2 = false;
            return bl2;
        }
        finally {
            if (isAnotherHttpClient) {
                try {
                    closeableHttpClient.close();
                }
                catch (IOException e) {
                    log.warn("Can't close a http client", e);
                }
            }
        }
    }

    @Override
    public void setClientInfo(String name, String value) throws SQLClientInfoException {
    }

    @Override
    public void setClientInfo(Properties properties) throws SQLClientInfoException {
    }

    @Override
    public String getClientInfo(String name) throws SQLException {
        return null;
    }

    @Override
    public Properties getClientInfo() throws SQLException {
        return null;
    }

    @Override
    public Array createArrayOf(String typeName, Object[] elements) throws SQLException {
        return new ClickHouseArray(ClickHouseDataType.resolveDefaultArrayDataType(typeName), elements);
    }

    @Override
    public Struct createStruct(String typeName, Object[] attributes) throws SQLException {
        return null;
    }

    @Override
    public <T> T unwrap(Class<T> iface) throws SQLException {
        if (iface.isAssignableFrom(this.getClass())) {
            return iface.cast(this);
        }
        throw new SQLException("Cannot unwrap to " + iface.getName());
    }

    @Override
    public boolean isWrapperFor(Class<?> iface) throws SQLException {
        return iface.isAssignableFrom(this.getClass());
    }

    @Override
    public void setSchema(String schema) throws SQLException {
        this.properties.setDatabase(schema);
    }

    @Override
    public String getSchema() throws SQLException {
        return this.properties.getDatabase();
    }

    @Override
    public void abort(Executor executor) throws SQLException {
        this.close();
    }

    @Override
    public void setNetworkTimeout(Executor executor, int milliseconds) throws SQLException {
    }

    @Override
    public int getNetworkTimeout() throws SQLException {
        return 0;
    }

    void cleanConnections() {
        this.httpclient.getConnectionManager().closeExpiredConnections();
        this.httpclient.getConnectionManager().closeIdleConnections(2 * this.properties.getSocketTimeout(), TimeUnit.MILLISECONDS);
    }

    String getUrl() {
        return this.url;
    }

    ClickHouseProperties getProperties() {
        return this.properties;
    }
}

