/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.doris.sink;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.flink.api.common.io.RichOutputFormat;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.util.ExecutorThreadFactory;
import org.apache.flink.shaded.guava18.com.google.common.collect.Maps;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.flink.types.Row;
import org.apache.seatunnel.flink.doris.sink.DorisStreamLoad;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DorisOutputFormat<T>
extends RichOutputFormat<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(DorisOutputFormat.class);
    private static final long serialVersionUID = -4514164348993670086L;
    private static final long DEFAULT_INTERVAL_MS = TimeUnit.SECONDS.toMillis(1L);
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String FIELD_DELIMITER_KEY = "column_separator";
    private static final String FIELD_DELIMITER_DEFAULT = "\t";
    private static final String LINE_DELIMITER_KEY = "line_delimiter";
    private static final String LINE_DELIMITER_DEFAULT = "\n";
    private static final String FORMAT_KEY = "format";
    private static final String FORMAT_JSON_VALUE = "json";
    private static final String NULL_VALUE = "\\N";
    private static final String ESCAPE_DELIMITERS_KEY = "escape_delimiters";
    private static final String ESCAPE_DELIMITERS_DEFAULT = "false";
    private static final Pattern DELIMITER_PATTERN = Pattern.compile("\\\\x(\\d{2})");
    private final String[] fieldNames;
    private final boolean jsonFormat;
    private final int batchSize;
    private final int maxRetries;
    private final long batchIntervalMs;
    private final List<Object> batch = new ArrayList<Object>();
    private String fieldDelimiter;
    private String lineDelimiter;
    private final DorisStreamLoad dorisStreamLoad;
    private transient ScheduledExecutorService scheduler;
    private transient ScheduledFuture<?> scheduledFuture;
    private volatile transient Exception flushException;
    private volatile transient boolean closed = false;

    public DorisOutputFormat(DorisStreamLoad dorisStreamLoad, String[] fieldNames, int batchSize, long batchIntervalMs, int maxRetries) {
        this.dorisStreamLoad = dorisStreamLoad;
        this.parseDelimiter();
        this.fieldNames = fieldNames;
        this.batchSize = batchSize;
        this.batchIntervalMs = batchIntervalMs;
        this.maxRetries = maxRetries;
        this.jsonFormat = FORMAT_JSON_VALUE.equals(dorisStreamLoad.getStreamLoadProp().getProperty(FORMAT_KEY));
    }

    private void parseDelimiter() {
        Properties streamLoadProp = this.dorisStreamLoad.getStreamLoadProp();
        boolean ifEscape = Boolean.parseBoolean(streamLoadProp.getProperty(ESCAPE_DELIMITERS_KEY, ESCAPE_DELIMITERS_DEFAULT));
        if (ifEscape) {
            this.fieldDelimiter = this.escapeString(streamLoadProp.getProperty(FIELD_DELIMITER_KEY, FIELD_DELIMITER_DEFAULT));
            this.lineDelimiter = this.escapeString(streamLoadProp.getProperty(LINE_DELIMITER_KEY, LINE_DELIMITER_DEFAULT));
            if (streamLoadProp.contains(ESCAPE_DELIMITERS_KEY)) {
                streamLoadProp.remove(ESCAPE_DELIMITERS_KEY);
            }
        } else {
            this.fieldDelimiter = streamLoadProp.getProperty(FIELD_DELIMITER_KEY, FIELD_DELIMITER_DEFAULT);
            this.lineDelimiter = streamLoadProp.getProperty(LINE_DELIMITER_KEY, LINE_DELIMITER_DEFAULT);
        }
    }

    private String escapeString(String s) {
        Matcher m = DELIMITER_PATTERN.matcher(s);
        StringBuffer buf = new StringBuffer();
        while (m.find()) {
            m.appendReplacement(buf, String.format("%s", Character.valueOf((char)Integer.parseInt(m.group(1)))));
        }
        m.appendTail(buf);
        return buf.toString();
    }

    public void configure(Configuration configuration) {
    }

    public void open(int taskNumber, int numTasks) {
        if (this.batchIntervalMs > 0L && this.batchSize != 1) {
            this.scheduler = new ScheduledThreadPoolExecutor(1, (ThreadFactory)new ExecutorThreadFactory("doris-streamload-outputformat"));
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(() -> {
                DorisOutputFormat dorisOutputFormat = this;
                synchronized (dorisOutputFormat) {
                    if (!this.closed) {
                        try {
                            this.flush();
                        }
                        catch (Exception e) {
                            this.flushException = e;
                        }
                    }
                }
            }, this.batchIntervalMs, this.batchIntervalMs, TimeUnit.MILLISECONDS);
        }
    }

    private void checkFlushException() {
        if (this.flushException != null) {
            throw new RuntimeException("Writing records to streamload failed.", this.flushException);
        }
    }

    public synchronized void writeRecord(T row) throws IOException {
        this.checkFlushException();
        this.addBatch(row);
        if (this.batchSize > 0 && this.batch.size() >= this.batchSize) {
            this.flush();
        }
    }

    private void addBatch(T row) {
        if (row instanceof Row) {
            Row rowData = (Row)row;
            HashMap valueMap = Maps.newHashMap();
            StringJoiner value = new StringJoiner(this.fieldDelimiter);
            for (int i = 0; i < rowData.getArity(); ++i) {
                String data;
                Object field = rowData.getField(i);
                if (this.jsonFormat) {
                    data = field != null ? field.toString() : null;
                    valueMap.put(this.fieldNames[i], data);
                    continue;
                }
                data = field != null ? field.toString() : NULL_VALUE;
                value.add(data);
            }
            Object data = this.jsonFormat ? valueMap : value.toString();
            this.batch.add(data);
        } else if (row instanceof String) {
            this.batch.add(row);
        } else {
            throw new RuntimeException("The type of element should be 'RowData' or 'String' only.");
        }
    }

    public synchronized void close() {
        if (!this.closed) {
            this.closed = true;
            if (this.scheduledFuture != null) {
                this.scheduledFuture.cancel(false);
                this.scheduler.shutdown();
            }
            try {
                this.flush();
            }
            catch (Exception e) {
                throw new RuntimeException("Writing records to doris failed.", e);
            }
        }
        this.checkFlushException();
    }

    public synchronized void flush() throws IOException {
        this.checkFlushException();
        if (this.batch.isEmpty()) {
            return;
        }
        String result = this.jsonFormat ? (this.batch.get(0) instanceof String ? this.batch.toString() : OBJECT_MAPPER.writeValueAsString(this.batch)) : String.join((CharSequence)this.lineDelimiter, this.batch.toArray(new CharSequence[this.batch.size()]));
        for (int i = 0; i <= this.maxRetries; ++i) {
            try {
                this.dorisStreamLoad.load(result);
                this.batch.clear();
                break;
            }
            catch (Exception e) {
                LOGGER.error("doris sink error, retry times = {}", (Object)i, (Object)e);
                if (i >= this.maxRetries) {
                    throw new IOException(e);
                }
                try {
                    Thread.sleep(DEFAULT_INTERVAL_MS * (long)i);
                    continue;
                }
                catch (InterruptedException ex) {
                    Thread.currentThread().interrupt();
                    throw new IOException("unable to flush; interrupted while doing another attempt", e);
                }
            }
        }
    }
}

