/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.flink.doris.sink;

import com.google.auto.service.AutoService;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.flink.api.java.DataSet;
import org.apache.flink.api.java.operators.DataSink;
import org.apache.flink.streaming.api.datastream.DataStream;
import org.apache.flink.streaming.api.datastream.DataStreamSink;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.bridge.java.BatchTableEnvironment;
import org.apache.flink.table.api.bridge.java.StreamTableEnvironment;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.seatunnel.common.PropertiesUtil;
import org.apache.seatunnel.common.config.CheckConfigUtil;
import org.apache.seatunnel.common.config.CheckResult;
import org.apache.seatunnel.flink.BaseFlinkSink;
import org.apache.seatunnel.flink.FlinkEnvironment;
import org.apache.seatunnel.flink.batch.FlinkBatchSink;
import org.apache.seatunnel.flink.doris.sink.DorisOutputFormat;
import org.apache.seatunnel.flink.doris.sink.DorisSinkFunction;
import org.apache.seatunnel.flink.doris.sink.DorisStreamLoad;
import org.apache.seatunnel.flink.stream.FlinkStreamSink;
import org.apache.seatunnel.shade.com.typesafe.config.Config;

@AutoService(value={BaseFlinkSink.class})
public class DorisSink
implements FlinkStreamSink,
FlinkBatchSink {
    private static final long serialVersionUID = 4747849769146047770L;
    private static final int DEFAULT_BATCH_SIZE = 5000;
    private static final long DEFAULT_INTERVAL_MS = TimeUnit.SECONDS.toMillis(5L);
    private static final String PARALLELISM = "parallelism";
    private Config config;
    private String fenodes;
    private String username;
    private String password;
    private String tableName;
    private String dbName;
    private int batchSize = 5000;
    private long batchIntervalMs = DEFAULT_INTERVAL_MS;
    private int maxRetries = 1;
    private final Properties streamLoadProp = new Properties();

    public Config getConfig() {
        return this.config;
    }

    public void setConfig(Config config) {
        this.config = config;
    }

    public CheckResult checkConfig() {
        return CheckConfigUtil.checkAllExists((Config)this.config, (String[])new String[]{"fenodes", "user", "password", "table", "database"});
    }

    public void prepare(FlinkEnvironment prepareEnv) {
        this.fenodes = this.config.getString("fenodes");
        this.username = this.config.getString("user");
        this.tableName = this.config.getString("table");
        this.password = this.config.getString("password");
        this.dbName = this.config.getString("database");
        if (this.config.hasPath("batch_size")) {
            this.batchSize = this.config.getInt("batch_size");
            Preconditions.checkArgument((this.batchSize > 0 ? 1 : 0) != 0, (Object)"batch_size must be greater than 0");
        }
        if (this.config.hasPath("interval")) {
            this.batchIntervalMs = this.config.getInt("interval");
            Preconditions.checkArgument((this.batchIntervalMs > 0L ? 1 : 0) != 0, (Object)"interval must be greater than 0");
        }
        if (this.config.hasPath("max_retries")) {
            this.maxRetries = this.config.getInt("max_retries");
            Preconditions.checkArgument((this.maxRetries > 0 ? 1 : 0) != 0, (Object)"max_retries must be greater than 0");
        }
        String producerPrefix = "doris.";
        PropertiesUtil.setProperties((Config)this.config, (Properties)this.streamLoadProp, (String)producerPrefix, (boolean)false);
    }

    public String getPluginName() {
        return "DorisSink";
    }

    public void outputBatch(FlinkEnvironment env, DataSet<Row> dataSet) {
        this.batchIntervalMs = 0L;
        BatchTableEnvironment tableEnvironment = env.getBatchTableEnvironment();
        Table table = tableEnvironment.fromDataSet(dataSet);
        String[] fieldNames = table.getSchema().getFieldNames();
        DorisStreamLoad dorisStreamLoad = new DorisStreamLoad(this.fenodes, this.dbName, this.tableName, this.username, this.password, this.streamLoadProp);
        DataSink rowDataSink = dataSet.output(new DorisOutputFormat(dorisStreamLoad, fieldNames, this.batchSize, this.batchIntervalMs, this.maxRetries));
        if (this.config.hasPath(PARALLELISM)) {
            int parallelism = this.config.getInt(PARALLELISM);
            rowDataSink.setParallelism(parallelism);
        }
    }

    public void outputStream(FlinkEnvironment env, DataStream<Row> dataStream) {
        StreamTableEnvironment tableEnvironment = env.getStreamTableEnvironment();
        Table table = tableEnvironment.fromDataStream(dataStream);
        String[] fieldNames = table.getSchema().getFieldNames();
        DorisStreamLoad dorisStreamLoad = new DorisStreamLoad(this.fenodes, this.dbName, this.tableName, this.username, this.password, this.streamLoadProp);
        DataStreamSink rowDataStreamSink = dataStream.addSink(new DorisSinkFunction(new DorisOutputFormat<Object>(dorisStreamLoad, fieldNames, this.batchSize, this.batchIntervalMs, this.maxRetries)));
        if (this.config.hasPath(PARALLELISM)) {
            int parallelism = this.config.getInt(PARALLELISM);
            rowDataStreamSink.setParallelism(parallelism);
        }
    }
}

