/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.miscellaneous;

import java.io.IOException;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.PositionIncrementAttribute;
import org.apache.lucene.analysis.tokenattributes.TypeAttribute;
import org.apache.lucene.util.AttributeSource;

public final class TypeAsSynonymFilter
extends TokenFilter {
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final TypeAttribute typeAtt = this.addAttribute(TypeAttribute.class);
    private final PositionIncrementAttribute posIncrAtt = this.addAttribute(PositionIncrementAttribute.class);
    private final String prefix;
    AttributeSource.State savedToken = null;

    public TypeAsSynonymFilter(TokenStream input) {
        this(input, null);
    }

    public TypeAsSynonymFilter(TokenStream input, String prefix) {
        super(input);
        this.prefix = prefix;
    }

    @Override
    public boolean incrementToken() throws IOException {
        if (this.savedToken != null) {
            this.restoreState(this.savedToken);
            this.savedToken = null;
            this.termAtt.setEmpty();
            if (this.prefix != null) {
                this.termAtt.append(this.prefix);
            }
            this.termAtt.append(this.typeAtt.type());
            this.posIncrAtt.setPositionIncrement(0);
            return true;
        }
        if (this.input.incrementToken()) {
            this.savedToken = this.captureState();
            return true;
        }
        return false;
    }

    @Override
    public void reset() throws IOException {
        super.reset();
        this.savedToken = null;
    }
}

