/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import org.apache.lucene.geo.EdgeTree;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Line;
import org.apache.lucene.geo.Rectangle;
import org.apache.lucene.geo.XYLine;
import org.apache.lucene.index.PointValues;

public final class Line2D
extends EdgeTree {
    private Line2D(Line line) {
        super(line.minLat, line.maxLat, line.minLon, line.maxLon, line.getLats(), line.getLons());
    }

    private Line2D(XYLine line) {
        super(line.minY, line.maxY, line.minX, line.maxX, line.getY(), line.getX());
    }

    public static Line2D create(Line ... lines) {
        EdgeTree[] components = new Line2D[lines.length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = new Line2D(lines[i]);
        }
        return (Line2D)Line2D.createTree(components, 0, components.length - 1, false);
    }

    public static Line2D create(XYLine ... lines) {
        EdgeTree[] components = new Line2D[lines.length];
        for (int i = 0; i < components.length; ++i) {
            components[i] = new Line2D(lines[i]);
        }
        return (Line2D)Line2D.createTree(components, 0, components.length - 1, false);
    }

    @Override
    protected PointValues.Relation componentRelate(double minLat, double maxLat, double minLon, double maxLon) {
        if (this.tree.crossesBox(minLat, maxLat, minLon, maxLon, true)) {
            return PointValues.Relation.CELL_CROSSES_QUERY;
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    @Override
    protected PointValues.Relation componentRelateTriangle(double ax, double ay, double bx, double by, double cx, double cy) {
        if (ax == bx && bx == cx && ay == by && by == cy) {
            if (this.isPointOnLine(this.tree, ax, ay)) {
                return PointValues.Relation.CELL_INSIDE_QUERY;
            }
        } else {
            if (ax == cx && ay == cy || bx == cx && by == cy) {
                if (this.tree.crossesLine(ax, ay, bx, by)) {
                    return PointValues.Relation.CELL_CROSSES_QUERY;
                }
                return PointValues.Relation.CELL_OUTSIDE_QUERY;
            }
            if (Line2D.pointInTriangle(this.tree.lon1, this.tree.lat1, ax, ay, bx, by, cx, cy) || this.tree.crossesTriangle(ax, ay, bx, by, cx, cy)) {
                return PointValues.Relation.CELL_CROSSES_QUERY;
            }
        }
        return PointValues.Relation.CELL_OUTSIDE_QUERY;
    }

    private boolean isPointOnLine(EdgeTree.Edge tree, double x, double y) {
        if (y <= tree.max) {
            double maxX;
            double minX;
            double maxY;
            double minY = StrictMath.min(tree.lat1, tree.lat2);
            if (Rectangle.containsPoint(y, x, minY, maxY = StrictMath.max(tree.lat1, tree.lat2), minX = StrictMath.min(tree.lon1, tree.lon2), maxX = StrictMath.max(tree.lon1, tree.lon2)) && GeoUtils.orient(tree.lon1, tree.lat1, tree.lon2, tree.lat2, x, y) == 0) {
                return true;
            }
            if (tree.left != null && this.isPointOnLine(tree.left, x, y)) {
                return true;
            }
            if (tree.right != null && maxY >= tree.low && this.isPointOnLine(tree.right, x, y)) {
                return true;
            }
        }
        return false;
    }
}

