/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.geo;

import java.util.Arrays;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Polygon;

public class XYPolygon {
    private final double[] x;
    private final double[] y;
    private final XYPolygon[] holes;
    public final double minX;
    public final double maxX;
    public final double minY;
    public final double maxY;
    private final GeoUtils.WindingOrder windingOrder;

    public XYPolygon(float[] x, float[] y, XYPolygon ... holes) {
        int i;
        if (x == null) {
            throw new IllegalArgumentException("x must not be null");
        }
        if (y == null) {
            throw new IllegalArgumentException("y must not be null");
        }
        if (holes == null) {
            throw new IllegalArgumentException("holes must not be null");
        }
        if (x.length != y.length) {
            throw new IllegalArgumentException("x and y must be equal length");
        }
        if (x.length < 4) {
            throw new IllegalArgumentException("at least 4 polygon points required");
        }
        if (x[0] != x[x.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): x[0]=" + x[0] + " x[" + (x.length - 1) + "]=" + x[x.length - 1]);
        }
        if (y[0] != y[y.length - 1]) {
            throw new IllegalArgumentException("first and last points of the polygon must be the same (it must close itself): y[0]=" + y[0] + " y[" + (y.length - 1) + "]=" + y[y.length - 1]);
        }
        for (i = 0; i < holes.length; ++i) {
            XYPolygon inner = holes[i];
            if (inner.holes.length <= 0) continue;
            throw new IllegalArgumentException("holes may not contain holes: polygons may not nest.");
        }
        this.x = new double[x.length];
        this.y = new double[y.length];
        for (i = 0; i < x.length; ++i) {
            this.x[i] = x[i];
            this.y[i] = y[i];
        }
        this.holes = (XYPolygon[])holes.clone();
        double minX = x[0];
        double maxX = x[0];
        double minY = y[0];
        double maxY = y[0];
        double windingSum = 0.0;
        int numPts = x.length - 1;
        int i2 = 1;
        int j = 0;
        while (i2 < numPts) {
            minX = Math.min((double)x[i2], minX);
            maxX = Math.max((double)x[i2], maxX);
            minY = Math.min((double)y[i2], minY);
            maxY = Math.max((double)y[i2], maxY);
            windingSum += (double)((x[j] - x[numPts]) * (y[i2] - y[numPts]) - (y[j] - y[numPts]) * (x[i2] - x[numPts]));
            j = i2++;
        }
        this.minX = minX;
        this.maxX = maxX;
        this.minY = minY;
        this.maxY = maxY;
        this.windingOrder = windingSum < 0.0 ? GeoUtils.WindingOrder.CCW : GeoUtils.WindingOrder.CW;
    }

    public int numPoints() {
        return this.x.length;
    }

    public double[] getPolyX() {
        return (double[])this.x.clone();
    }

    public double getPolyX(int vertex) {
        return this.x[vertex];
    }

    public double[] getPolyY() {
        return (double[])this.y.clone();
    }

    public double getPolyY(int vertex) {
        return this.y[vertex];
    }

    public XYPolygon[] getHoles() {
        return (XYPolygon[])this.holes.clone();
    }

    XYPolygon getHole(int i) {
        return this.holes[i];
    }

    public GeoUtils.WindingOrder getWindingOrder() {
        return this.windingOrder;
    }

    public int numHoles() {
        return this.holes.length;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + Arrays.hashCode(this.holes);
        result = 31 * result + Arrays.hashCode(this.x);
        result = 31 * result + Arrays.hashCode(this.y);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        XYPolygon other = (XYPolygon)obj;
        if (!Arrays.equals(this.holes, other.holes)) {
            return false;
        }
        if (!Arrays.equals(this.x, other.x)) {
            return false;
        }
        return Arrays.equals(this.y, other.y);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.x.length; ++i) {
            sb.append("[").append(this.x[i]).append(", ").append(this.y[i]).append("] ");
        }
        if (this.holes.length > 0) {
            sb.append(", holes=");
            sb.append(Arrays.toString(this.holes));
        }
        return sb.toString();
    }

    public String toGeoJSON() {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        sb.append(Polygon.verticesToGeoJSON(this.y, this.x));
        for (XYPolygon hole : this.holes) {
            sb.append(",");
            sb.append(Polygon.verticesToGeoJSON(hole.y, hole.x));
        }
        sb.append("]");
        return sb.toString();
    }
}

