/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial3d;

import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.geo.Polygon;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial3d.Geo3DUtil;
import org.apache.lucene.spatial3d.PointInGeo3DShapeQuery;
import org.apache.lucene.spatial3d.geom.GeoBBox;
import org.apache.lucene.spatial3d.geom.GeoCircle;
import org.apache.lucene.spatial3d.geom.GeoPath;
import org.apache.lucene.spatial3d.geom.GeoPoint;
import org.apache.lucene.spatial3d.geom.GeoPolygon;
import org.apache.lucene.spatial3d.geom.GeoShape;
import org.apache.lucene.spatial3d.geom.PlanetModel;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.NumericUtils;

public final class Geo3DPoint
extends Field {
    public static final FieldType TYPE = new FieldType();

    public Geo3DPoint(String name, double latitude, double longitude) {
        super(name, TYPE);
        GeoUtils.checkLatitude(latitude);
        GeoUtils.checkLongitude(longitude);
        GeoPoint point = new GeoPoint(PlanetModel.WGS84, Geo3DUtil.fromDegrees(latitude), Geo3DUtil.fromDegrees(longitude));
        this.fillFieldsData(point.x, point.y, point.z);
    }

    public static Query newDistanceQuery(String field, double latitude, double longitude, double radiusMeters) {
        GeoCircle shape = Geo3DUtil.fromDistance(latitude, longitude, radiusMeters);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    public static Query newBoxQuery(String field, double minLatitude, double maxLatitude, double minLongitude, double maxLongitude) {
        GeoBBox shape = Geo3DUtil.fromBox(minLatitude, maxLatitude, minLongitude, maxLongitude);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    public static Query newPolygonQuery(String field, Polygon ... polygons) {
        GeoPolygon shape = Geo3DUtil.fromPolygon(polygons);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    public static Query newLargePolygonQuery(String field, Polygon ... polygons) {
        GeoPolygon shape = Geo3DUtil.fromLargePolygon(polygons);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    public static Query newPathQuery(String field, double[] pathLatitudes, double[] pathLongitudes, double pathWidthMeters) {
        GeoPath shape = Geo3DUtil.fromPath(pathLatitudes, pathLongitudes, pathWidthMeters);
        return Geo3DPoint.newShapeQuery(field, shape);
    }

    public Geo3DPoint(String name, double x, double y, double z) {
        super(name, TYPE);
        this.fillFieldsData(x, y, z);
    }

    private void fillFieldsData(double x, double y, double z) {
        byte[] bytes = new byte[12];
        Geo3DPoint.encodeDimension(x, bytes, 0);
        Geo3DPoint.encodeDimension(y, bytes, 4);
        Geo3DPoint.encodeDimension(z, bytes, 8);
        this.fieldsData = new BytesRef(bytes);
    }

    public static void encodeDimension(double value, byte[] bytes, int offset) {
        NumericUtils.intToSortableBytes(Geo3DUtil.encodeValue(value), bytes, offset);
    }

    public static double decodeDimension(byte[] value, int offset) {
        return Geo3DUtil.decodeValue(NumericUtils.sortableBytesToInt(value, offset));
    }

    public static Query newShapeQuery(String field, GeoShape shape) {
        return new PointInGeo3DShapeQuery(field, shape);
    }

    @Override
    public String toString() {
        StringBuilder result = new StringBuilder();
        result.append(this.getClass().getSimpleName());
        result.append(" <");
        result.append(this.name);
        result.append(':');
        BytesRef bytes = (BytesRef)this.fieldsData;
        result.append(" x=").append(Geo3DPoint.decodeDimension(bytes.bytes, bytes.offset));
        result.append(" y=").append(Geo3DPoint.decodeDimension(bytes.bytes, bytes.offset + 4));
        result.append(" z=").append(Geo3DPoint.decodeDimension(bytes.bytes, bytes.offset + 8));
        result.append('>');
        return result.toString();
    }

    static {
        TYPE.setDimensions(3, 4);
        TYPE.freeze();
    }
}

